/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.deployment.ide.Ide;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class OpenIdeHandler
extends DevConsolePostHandler {
    private static final Logger log = Logger.getLogger(OpenIdeHandler.class);
    private static final Map<String, String> LANG_TO_EXT = new HashMap<String, String>();
    private final Ide ide;

    public OpenIdeHandler(Ide ide) {
        this.ide = ide;
    }

    protected void dispatch(RoutingContext routingContext, MultiMap form) {
        String className = form.get("className");
        String lang = form.get("lang");
        String srcMainPath = form.get("srcMainPath");
        String line = form.get("line");
        if (this.isNullOrEmpty(className) || this.isNullOrEmpty(lang) || this.isNullOrEmpty(srcMainPath)) {
            routingContext.fail(400);
        }
        if (this.ide != null) {
            this.typicalProcessLaunch(routingContext, className, lang, srcMainPath, line, this.ide);
        } else {
            log.debug((Object)("Unhandled IDE : " + this.ide));
            routingContext.fail(500);
        }
    }

    private void typicalProcessLaunch(RoutingContext routingContext, String className, String lang, String srcMainPath, String line, Ide ide) {
        Object arg = this.toFileName(className, lang, srcMainPath);
        if (!this.isNullOrEmpty(line)) {
            arg = (String)arg + ":" + line;
        }
        this.launchInIDE(ide, (String)arg, routingContext);
    }

    private String toFileName(String className, String lang, String srcMainPath) {
        String effectiveClassName = className;
        int dollarIndex = className.indexOf("$");
        if (dollarIndex > -1) {
            effectiveClassName = className.substring(0, dollarIndex);
        }
        return srcMainPath + File.separator + lang + File.separator + effectiveClassName.replace('.', File.separatorChar) + "." + LANG_TO_EXT.get(lang);
    }

    protected void launchInIDE(final Ide ide, final String arg, final RoutingContext routingContext) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String effectiveCommand = ide.getEffectiveCommand();
                    if (OpenIdeHandler.this.isNullOrEmpty(effectiveCommand)) {
                        log.debug((Object)("Unable to determine proper launch command for IDE: " + ide));
                        routingContext.response().setStatusCode(500).end();
                        return;
                    }
                    new ProcessBuilder(Arrays.asList(effectiveCommand, arg)).inheritIO().start().waitFor(10L, TimeUnit.SECONDS);
                    routingContext.response().setStatusCode(200).end();
                }
                catch (Exception e) {
                    routingContext.fail((Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
    }

    private boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }

    static {
        LANG_TO_EXT.put("java", "java");
        LANG_TO_EXT.put("kotlin", "kt");
    }
}

