/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.undertow.runtime.QuarkusUndertowAccount;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.vertx.VertxHttpExchange;
import io.vertx.ext.web.RoutingContext;

public class QuarkusAuthMechanism
implements AuthenticationMechanism {
    public static final QuarkusAuthMechanism INSTANCE = new QuarkusAuthMechanism();

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        VertxHttpExchange delegate = (VertxHttpExchange)exchange.getDelegate();
        RoutingContext context = (RoutingContext)delegate.getContext();
        try {
            SecurityIdentity identity = QuarkusHttpUser.getSecurityIdentityBlocking((RoutingContext)context, null);
            if (identity != null && !identity.isAnonymous()) {
                securityContext.authenticationComplete((Account)new QuarkusUndertowAccount(identity), "Quarkus", false);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        catch (AuthenticationFailedException e) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        VertxHttpExchange delegate = (VertxHttpExchange)exchange.getDelegate();
        RoutingContext context = (RoutingContext)delegate.getContext();
        HttpAuthenticator authenticator = (HttpAuthenticator)context.get(HttpAuthenticator.class.getName());
        if (authenticator == null) {
            exchange.setStatusCode(401);
            exchange.endExchange();
            return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getStatusCode()));
        }
        authenticator.sendChallenge(context).await().indefinitely();
        exchange.endExchange();
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(exchange.getStatusCode()));
    }
}

