/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.oidc.Oidc;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TenantIdentityProvider;
import io.quarkus.oidc.runtime.BackChannelLogoutHandler;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcImpl;
import io.quarkus.oidc.runtime.ResourceMetadataHandler;
import io.quarkus.oidc.runtime.StepUpAuthenticationPolicy;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantContextFactory;
import io.quarkus.oidc.runtime.TenantSpecificOidcIdentityProvider;
import io.quarkus.proxy.ProxyConfigurationRegistry;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.runtime.SecurityConfig;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OidcRecorder {
    public static final String ACR_VALUES_TO_MAX_AGE_SEPARATOR = "@#$%@";
    static final Logger LOG = Logger.getLogger(OidcRecorder.class);
    private final RuntimeValue<OidcConfig> oidcConfig;
    private final RuntimeValue<SecurityConfig> securityConfig;

    public OidcRecorder(RuntimeValue<OidcConfig> oidcConfig, RuntimeValue<SecurityConfig> securityConfig) {
        this.oidcConfig = oidcConfig;
        this.securityConfig = securityConfig;
    }

    public Supplier<DefaultTokenIntrospectionUserInfoCache> setupTokenCache(final Supplier<Vertx> vertx) {
        return new Supplier<DefaultTokenIntrospectionUserInfoCache>(){

            @Override
            public DefaultTokenIntrospectionUserInfoCache get() {
                return new DefaultTokenIntrospectionUserInfoCache((OidcConfig)OidcRecorder.this.oidcConfig.getValue(), (Vertx)vertx.get());
            }
        };
    }

    public void setUserInfoInjectionPointDetected(boolean userInfoInjectionPointDetected) {
        TenantContextFactory.userInfoInjectionPointDetected = userInfoInjectionPointDetected;
    }

    public Function<SyntheticCreationalContext<TenantConfigBean>, TenantConfigBean> createTenantConfigBean(final Supplier<Vertx> vertx, final Supplier<TlsConfigurationRegistry> registry, final Supplier<ProxyConfigurationRegistry> proxyConfigurationRegistrySupplier) {
        return new Function<SyntheticCreationalContext<TenantConfigBean>, TenantConfigBean>(){

            @Override
            public TenantConfigBean apply(SyntheticCreationalContext<TenantConfigBean> ctx) {
                OidcImpl oidc = new OidcImpl((OidcConfig)OidcRecorder.this.oidcConfig.getValue());
                ((Event)ctx.getInjectedReference((TypeLiteral)new TypeLiteral<Event<Oidc>>(){}, new Annotation[0])).fire((Object)oidc);
                return new TenantConfigBean((Vertx)vertx.get(), (TlsConfigurationRegistry)registry.get(), oidc, ((SecurityConfig)OidcRecorder.this.securityConfig.getValue()).events().enabled(), (ProxyConfigurationRegistry)proxyConfigurationRegistrySupplier.get());
            }
        };
    }

    public void initTenantConfigBean() {
        try {
            Arc.container().instance(TenantConfigBean.class, new Annotation[0]).get();
        }
        catch (CreationException wrapper) {
            Throwable throwable = wrapper.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw wrapper;
        }
    }

    public Function<String, Consumer<RoutingContext>> tenantResolverInterceptorCreator() {
        return new Function<String, Consumer<RoutingContext>>(){

            @Override
            public Consumer<RoutingContext> apply(final String tenantId) {
                return new Consumer<RoutingContext>(){

                    @Override
                    public void accept(RoutingContext routingContext) {
                        OidcTenantConfig tenantConfig = (OidcTenantConfig)routingContext.get(OidcTenantConfig.class.getName());
                        if (tenantConfig != null) {
                            String tenantUsedForAuth = tenantConfig.tenantId().orElse(null);
                            if (tenantId.equals(tenantUsedForAuth)) {
                                return;
                            }
                            throw new AuthenticationFailedException("The '%1$s' selected with the @Tenant annotation must be used to authenticate\nthe request but it was already authenticated with the '%2$s' tenant. It\ncan happen if the '%1$s' is selected with an annotation but '%2$s' is\nresolved during authentication required by the HTTP Security Policy which\nis enforced before the JAX-RS chain is run. In such cases, please set the\n'quarkus.http.auth.permission.\"permissions\".applies-to=JAXRS' to all HTTP\nSecurity Policies which secure the same REST endpoints as the ones\nwhere the '%1$s' tenant is resolved by the '@Tenant' annotation.\n".formatted(tenantId, tenantUsedForAuth));
                        }
                        LOG.debugf("@Tenant annotation set a '%s' tenant id on the %s request path", (Object)tenantId, (Object)routingContext.request().path());
                        routingContext.put("tenant-id-set-by-annotation", (Object)tenantId);
                        routingContext.put("tenant-id", (Object)tenantId);
                    }
                };
            }
        };
    }

    public Supplier<TenantIdentityProvider> createTenantIdentityProvider(final String tenantName) {
        return new Supplier<TenantIdentityProvider>(){

            @Override
            public TenantIdentityProvider get() {
                return new TenantSpecificOidcIdentityProvider(tenantName);
            }
        };
    }

    public Function<String, Consumer<RoutingContext>> authenticationContextInterceptorCreator() {
        StepUpAuthenticationPolicy.markAsEnabled();
        return new Function<String, Consumer<RoutingContext>>(){

            @Override
            public Consumer<RoutingContext> apply(String annotationBinding) {
                int separatorIndex = annotationBinding.indexOf(OidcRecorder.ACR_VALUES_TO_MAX_AGE_SEPARATOR);
                final String acrValues = annotationBinding.substring(0, separatorIndex);
                final String maxAgeAsStr = annotationBinding.substring(separatorIndex + OidcRecorder.ACR_VALUES_TO_MAX_AGE_SEPARATOR.length());
                Duration maxAgeDuration = maxAgeAsStr.isEmpty() ? null : DurationConverter.parseDuration((String)maxAgeAsStr);
                final StepUpAuthenticationPolicy policy = new StepUpAuthenticationPolicy(acrValues, maxAgeDuration);
                return new Consumer<RoutingContext>(){

                    @Override
                    public void accept(RoutingContext routingContext) {
                        String requestPath = routingContext.request().path();
                        OidcTenantConfig tenantConfig = (OidcTenantConfig)routingContext.get(OidcTenantConfig.class.getName());
                        if (tenantConfig != null || routingContext.user() != null) {
                            throw new AuthenticationFailedException("Authentication has happened before the '@AuthenticationContext' annotation was\nmatched with the HTTP request path '%s'. It can happen when the authentication\nis required by an HTTP Security Policy before the JAX-RS chain is run. In such\ncases, please set the 'quarkus.http.auth.permission.\"permissions\".applies-to=JAXRS'\nto all HTTP Security Policies which secure the same REST endpoints as the ones\nannotated with the '@AuthenticationContext' annotation.\n".formatted(requestPath));
                        }
                        LOG.debugf("The '@AuthenticationContext' annotation set required 'acr' values '%s' and max age '%s' for the request path '%s'", (Object)acrValues, (Object)maxAgeAsStr, (Object)requestPath);
                        policy.storeSelfOnContext(routingContext);
                    }
                };
            }
        };
    }

    public Handler<RoutingContext> getBackChannelLogoutHandler(BeanContainer beanContainer) {
        return (Handler)beanContainer.beanInstance(BackChannelLogoutHandler.class, new Annotation[0]);
    }

    public Handler<RoutingContext> getResourceMetadataHandler(BeanContainer beanContainer) {
        return (Handler)beanContainer.beanInstance(ResourceMetadataHandler.class, new Annotation[0]);
    }
}

