/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedRuntimeSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.ModuleEnableNativeAccessBuildItem;
import io.quarkus.deployment.builditem.ModuleOpenBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.netty.BossEventLoopGroup;
import io.quarkus.netty.MainEventLoopGroup;
import io.quarkus.netty.deployment.EventLoopGroupBuildItem;
import io.quarkus.netty.deployment.EventLoopSupplierBuildItem;
import io.quarkus.netty.deployment.JBossNettyLoggerFactory;
import io.quarkus.netty.deployment.MinNettyAllocatorMaxOrderBuildItem;
import io.quarkus.netty.deployment.NettyBuildTimeConfig;
import io.quarkus.netty.runtime.EmptyByteBufStub;
import io.quarkus.netty.runtime.MachineIdGenerator;
import io.quarkus.netty.runtime.NettyRecorder;
import io.quarkus.netty.runtime.NettySharable;
import io.quarkus.runtime.util.JavaVersionGreaterOrEqual25;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

class NettyProcessor {
    private static final Logger log = Logger.getLogger(NettyProcessor.class);
    private static final int DEFAULT_NETTY_ALLOCATOR_MAX_ORDER = 3;

    NettyProcessor() {
    }

    @BuildStep
    public NativeImageSystemPropertyBuildItem limitMem() {
        return new NativeImageSystemPropertyBuildItem("sun.nio.ch.maxUpdateArraySize", "100");
    }

    @BuildStep
    public SystemPropertyBuildItem limitArenaSize(NettyBuildTimeConfig config, List<MinNettyAllocatorMaxOrderBuildItem> minMaxOrderBuildItems) {
        String maxOrder = this.calculateMaxOrder(config.allocatorMaxOrder(), minMaxOrderBuildItems, true);
        return new SystemPropertyBuildItem("io.netty.allocator.maxOrder", maxOrder);
    }

    @BuildStep
    public GeneratedRuntimeSystemPropertyBuildItem setNettyMachineId() {
        return new GeneratedRuntimeSystemPropertyBuildItem("io.netty.machineId", MachineIdGenerator.class);
    }

    @BuildStep
    public SystemPropertyBuildItem disableFinalizers() {
        return new SystemPropertyBuildItem("io.netty.allocator.disableCacheFinalizersForFastThreadLocalThreads", "true");
    }

    @BuildStep(onlyIf={JavaVersionGreaterOrEqual25.class})
    NativeImageConfigBuildItem build25Specific(BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, BuildProducer<ModuleOpenBuildItem> moduleOpenBuildItem) {
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Reflectively accessed through Netty's PlatformDependent0.", "jdk.internal.misc.Unsafe", "allocateUninitializedArray", new String[]{Class.class.getName(), Integer.TYPE.getName()}));
        reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem("Reflectively accessed through Netty's PlatformDependent0.", "java.nio.Bits", "UNSAFE_SET_THRESHOLD"));
        moduleOpenBuildItem.produce((BuildItem)new ModuleOpenBuildItem("java.base", "io.netty.common", new String[]{"java.nio", "jdk.internal.misc"}));
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.tryReflectionSetAccessible", "true").addNativeImageSystemProperty("io.netty.noUnsafe", "false");
        return builder.build();
    }

    @BuildStep
    NativeImageConfigBuildItem build(NettyBuildTimeConfig config, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ReflectiveFieldBuildItem> reflectiveFields, List<MinNettyAllocatorMaxOrderBuildItem> minMaxOrderBuildItems) {
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "jdk.internal.misc.Unsafe", "getUnsafe", new String[0]));
        reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "java.nio.DirectByteBuffer", "<init>", new String[]{Long.TYPE.getName(), Long.TYPE.getName()}));
        reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "java.nio.Bits", "UNALIGNED"));
        reflectiveFields.produce((BuildItem)new ReflectiveFieldBuildItem("Reflectively accessed through PlatformDependent0's static initializer", "java.nio.Bits", "MAX_MEMORY"));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioServerSocketChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.socket.nio.NioDatagramChannel"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"java.util.LinkedHashMap"}).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"sun.nio.ch.SelectorImpl"}).methods().fields().build());
        String maxOrder = this.calculateMaxOrder(config.allocatorMaxOrder(), minMaxOrderBuildItems, false);
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.allocator.maxOrder", maxOrder).addRuntimeInitializedClass("io.netty.handler.ssl.ConscryptAlpnSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslContext").addRuntimeInitializedClass("io.netty.handler.ssl.JdkSslServerContext").addRuntimeInitializedClass("io.netty.handler.ssl.util.ThreadLocalInsecureRandom").addRuntimeInitializedClass("io.netty.channel.DefaultChannelId").addNativeImageSystemProperty("io.netty.leakDetection.level", "DISABLED");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.handler.codec.http.HttpObjectEncoder")) {
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http.HttpObjectEncoder").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder");
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)"com.github.luben.zstd.Zstd")) {
                builder.addRuntimeInitializedClass("io.netty.handler.codec.compression.ZstdOptions").addRuntimeInitializedClass("io.netty.handler.codec.compression.ZstdConstants");
            }
            if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.handler.codec.compression.BrotliOptions")) {
                builder.addRuntimeInitializedClass("io.netty.handler.codec.compression.BrotliOptions");
            }
        } else {
            log.debug((Object)"Not registering Netty HTTP classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.handler.codec.http2.Http2CodecUtil")) {
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2CodecUtil").addRuntimeInitializedClass("io.netty.handler.codec.http2.DefaultHttp2FrameWriter").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ConnectionHandler").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ClientUpgradeCodec");
        } else {
            log.debug((Object)"Not registering Netty HTTP2 classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.unix.UnixChannel")) {
            builder.addRuntimeInitializedClass("io.netty.channel.unix.Errors").addRuntimeInitializedClass("io.netty.channel.unix.FileDescriptor").addRuntimeInitializedClass("io.netty.channel.unix.IovArray").addRuntimeInitializedClass("io.netty.channel.unix.Limits");
        } else {
            log.debug((Object)"Not registering Netty native unix classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.epoll.EpollMode")) {
            builder.addRuntimeInitializedClass("io.netty.channel.epoll.Epoll").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventArray").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventLoop").addRuntimeInitializedClass("io.netty.channel.epoll.Native");
        } else {
            log.debug((Object)"Not registering Netty native epoll classes as they were not found");
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.kqueue.AcceptFilter")) {
            builder.addRuntimeInitializedClass("io.netty.channel.kqueue.KQueue").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventArray").addRuntimeInitializedClass("io.netty.channel.kqueue.Native").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventLoop");
        } else {
            log.debug((Object)"Not registering Netty native kqueue classes as they were not found");
        }
        builder.addRuntimeInitializedClass("io.netty.util.internal.PlatformDependent").addRuntimeInitializedClass("io.netty.util.internal.PlatformDependent0").addRuntimeInitializedClass("io.netty.util.AbstractReferenceCounted").addRuntimeInitializedClass("io.netty.buffer.AbstractReferenceCountedByteBuf");
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.buffer.UnpooledByteBufAllocator")) {
            builder.addRuntimeInitializedClass("io.netty.buffer.UnpooledByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.Unpooled").addRuntimeInitializedClass("io.netty.handler.codec.http.HttpObjectAggregator").addRuntimeInitializedClass("io.netty.handler.codec.ReplayingDecoderByteBuf").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil$HexUtil").addRuntimeInitializedClass("io.netty.buffer.PooledByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil");
            if (QuarkusClassLoader.isClassPresentAtRuntime((String)"org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload")) {
                builder.addRuntimeInitializedClass("org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload");
            }
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerEventLoopBeans(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Optional<EventLoopSupplierBuildItem> loopSupplierBuildItem, NettyRecorder recorder, BuildProducer<EventLoopGroupBuildItem> eventLoopGroups) {
        Supplier<EventLoopGroup> main;
        Supplier<EventLoopGroup> boss;
        if (loopSupplierBuildItem.isPresent()) {
            boss = loopSupplierBuildItem.get().getBossSupplier();
            main = loopSupplierBuildItem.get().getMainSupplier();
        } else {
            boss = recorder.createEventLoop(1);
            main = recorder.createEventLoop(0);
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EventLoopGroup.class).supplier(boss).scope(Singleton.class)).addQualifier(BossEventLoopGroup.class)).unremovable()).setRuntimeInit().done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EventLoopGroup.class).supplier(main).scope(Singleton.class)).addQualifier(MainEventLoopGroup.class)).unremovable()).setRuntimeInit().done());
        eventLoopGroups.produce((BuildItem)new EventLoopGroupBuildItem(boss, main));
    }

    @BuildStep
    AdditionalBeanBuildItem registerQualifiers() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{BossEventLoopGroup.class, MainEventLoopGroup.class}).build();
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem reinitScheduledFutureTask() {
        return new RuntimeInitializedClassBuildItem("io.quarkus.netty.runtime.graal.Holder_io_netty_util_concurrent_ScheduledFutureTask");
    }

    @BuildStep
    public List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields() {
        return Arrays.asList(new UnsafeAccessedFieldBuildItem("sun.nio.ch.SelectorImpl", "selectedKeys"), new UnsafeAccessedFieldBuildItem("sun.nio.ch.SelectorImpl", "publicSelectedKeys"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess", "REF_ELEMENT_SHIFT"));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitBcryptUtil() {
        return new RuntimeInitializedClassBuildItem(EmptyByteBufStub.class.getName());
    }

    @BuildStep
    LogCleanupFilterBuildItem cleanupUnsafeLog() {
        return new LogCleanupFilterBuildItem(PlatformDependent.class.getName() + "0", (Level)org.jboss.logmanager.Level.TRACE, new String[]{"direct buffer constructor", "jdk.internal.misc.Unsafe", "sun.misc.Unsafe"});
    }

    @BuildStep
    LogCleanupFilterBuildItem cleanupMacDNSInLog() {
        return new LogCleanupFilterBuildItem(DnsServerAddressStreamProviders.class.getName(), (Level)org.jboss.logmanager.Level.WARN, new String[]{"Can not find io.netty.resolver.dns.macos.MacOSDnsServerAddressStreamProvider in the classpath"});
    }

    @BuildStep
    NativeImageResourceBuildItem nettyVersions() {
        return new NativeImageResourceBuildItem(new String[]{"META-INF/io.netty.versions.properties"});
    }

    private String calculateMaxOrder(OptionalInt userConfig, List<MinNettyAllocatorMaxOrderBuildItem> minMaxOrderBuildItems, boolean shouldWarn) {
        int result = 3;
        for (MinNettyAllocatorMaxOrderBuildItem minMaxOrderBuildItem : minMaxOrderBuildItems) {
            if (minMaxOrderBuildItem.getMaxOrder() <= result) continue;
            result = minMaxOrderBuildItem.getMaxOrder();
        }
        if (userConfig.isPresent()) {
            int v = userConfig.getAsInt();
            if (result > v && shouldWarn) {
                log.warnf("The configuration set `quarkus.netty.allocator-max-order` to %d. This value is lower than the value requested by the extensions (%d). %d will be used anyway.", (Object)v, (Object)result, (Object)v);
            }
            return Integer.toString(v);
        }
        return Integer.toString(result);
    }

    @BuildStep
    BytecodeTransformerBuildItem transformCleanerJava9() {
        final String className = "io.netty.util.internal.CleanerJava9";
        return new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setVisitorFunction((BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

            @Override
            public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                FieldDescriptor supportedFieldDescriptor = FieldDescriptor.of((String)className, (String)"SUPPORTED", Boolean.TYPE);
                ClassTransformer transformer = new ClassTransformer(className);
                transformer.addField(supportedFieldDescriptor).setModifiers(26);
                transformer.removeField("INVOKE_CLEANER", Method.class);
                MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"<clinit>", Void.TYPE, (Object[])new Object[0]);
                transformer.removeMethod(methodDescriptor);
                MethodCreator clinitMethod = (MethodCreator)transformer.addMethod(methodDescriptor).setModifiers(9);
                ResultHandle cleanerClass = clinitMethod.loadClass(className);
                ResultHandle loggerInstance = clinitMethod.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"io.netty.util.internal.logging.InternalLoggerFactory", (String)"getInstance", (Object)InternalLogger.class.getName(), (Object[])new Object[]{Class.class}), new ResultHandle[]{cleanerClass});
                FieldDescriptor loggerFieldDescriptor = FieldDescriptor.of((String)className, (String)"logger", (String)InternalLogger.class.getName());
                clinitMethod.writeStaticField(loggerFieldDescriptor, loggerInstance);
                AssignableResultHandle supportedVar = clinitMethod.createVariable(Boolean.TYPE);
                clinitMethod.assign(supportedVar, clinitMethod.load(false));
                AssignableResultHandle errorVar = clinitMethod.createVariable(Throwable.class);
                clinitMethod.assign(errorVar, clinitMethod.loadNull());
                ResultHandle hasUnsafe = clinitMethod.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"io.netty.util.internal.PlatformDependent0", (String)"hasUnsafe", Boolean.TYPE, (Object[])new Object[0]), new ResultHandle[0]);
                BranchResult hasUnsafeResult = clinitMethod.ifTrue(hasUnsafe);
                BytecodeCreator hasUnsafeTrueBranch = hasUnsafeResult.trueBranch();
                TryBlock tryBlock = hasUnsafeTrueBranch.tryBlock();
                ResultHandle buffer = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(ByteBuffer.class, (String)"allocateDirect", ByteBuffer.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{tryBlock.load(1)});
                ResultHandle unsafe = tryBlock.readStaticField(FieldDescriptor.of((String)"io.netty.util.internal.PlatformDependent0", (String)"UNSAFE", (String)"sun.misc.Unsafe"));
                tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)"sun.misc.Unsafe", (String)"invokeCleaner", Void.TYPE, (Object[])new Object[]{ByteBuffer.class}), unsafe, new ResultHandle[]{buffer});
                tryBlock.assign(supportedVar, tryBlock.load(true));
                CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
                catchBlock.assign(errorVar, catchBlock.getCaughtException());
                BytecodeCreator hasUnsafeFalseBranch = hasUnsafeResult.falseBranch();
                ResultHandle unsupportedEx = hasUnsafeFalseBranch.newInstance(MethodDescriptor.ofConstructor(UnsupportedOperationException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{hasUnsafeFalseBranch.load("sun.misc.Unsafe unavailable")});
                hasUnsafeFalseBranch.assign(errorVar, unsupportedEx);
                clinitMethod.writeStaticField(supportedFieldDescriptor, (ResultHandle)supportedVar);
                BranchResult errorCheck = clinitMethod.ifNull((ResultHandle)errorVar);
                BytecodeCreator errorNull = errorCheck.trueBranch();
                errorNull.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)"io.netty.util.internal.logging.InternalLogger", (String)"debug", Void.TYPE, (Object[])new Object[]{String.class}), errorNull.readStaticField(loggerFieldDescriptor), new ResultHandle[]{errorNull.load("java.nio.ByteBuffer.cleaner(): available")});
                BytecodeCreator errorNotNull = errorCheck.falseBranch();
                errorNotNull.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)"io.netty.util.internal.logging.InternalLogger", (String)"debug", Void.TYPE, (Object[])new Object[]{String.class, Throwable.class}), errorNotNull.readStaticField(loggerFieldDescriptor), new ResultHandle[]{errorNotNull.load("java.nio.ByteBuffer.cleaner(): unavailable"), errorVar});
                clinitMethod.returnValue(null);
                methodDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"isSupported", Boolean.TYPE, (Object[])new Object[0]);
                transformer.removeMethod(methodDescriptor);
                MethodCreator isSupportedMethod = transformer.addMethod(methodDescriptor);
                isSupportedMethod.setModifiers(9);
                isSupportedMethod.returnValue(isSupportedMethod.readStaticField(supportedFieldDescriptor));
                MethodDescriptor freeDirectBufferDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"freeDirectBuffer", Void.TYPE, (Object[])new Object[]{ByteBuffer.class});
                transformer.removeMethod(freeDirectBufferDescriptor);
                MethodCreator freeDirectBufferMethod = transformer.addMethod(freeDirectBufferDescriptor);
                freeDirectBufferMethod.setModifiers(1);
                ResultHandle bufferParam = freeDirectBufferMethod.getMethodParam(0);
                ResultHandle securityManager = freeDirectBufferMethod.invokeStaticMethod(MethodDescriptor.ofMethod(System.class, (String)"getSecurityManager", SecurityManager.class, (Class[])new Class[0]), new ResultHandle[0]);
                BranchResult securityCheck = freeDirectBufferMethod.ifNull(securityManager);
                BytecodeCreator noSecurityBranch = securityCheck.trueBranch();
                ResultHandle unsafe2 = noSecurityBranch.readStaticField(FieldDescriptor.of((String)"io.netty.util.internal.PlatformDependent0", (String)"UNSAFE", (String)"sun.misc.Unsafe"));
                noSecurityBranch.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)"sun.misc.Unsafe", (String)"invokeCleaner", Void.TYPE, (Object[])new Object[]{ByteBuffer.class}), unsafe2, new ResultHandle[]{bufferParam});
                BytecodeCreator withSecurityBranch = securityCheck.falseBranch();
                withSecurityBranch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)"io.netty.util.internal.CleanerJava9", (String)"freeDirectBufferPrivileged", Void.TYPE, (Object[])new Object[]{ByteBuffer.class}), new ResultHandle[]{bufferParam});
                freeDirectBufferMethod.returnValue(null);
                transformer.removeMethod("access$000", Method.class, new Object[0]);
                return transformer.applyTo(classVisitor);
            }
        }).build();
    }

    @BuildStep
    void transformPlatformDependent0(CompiledJavaVersionBuildItem compiledJavaVersion, BuildProducer<BytecodeTransformerBuildItem> producer) {
        if (compiledJavaVersion.getJavaVersion().isJava21OrHigher() != CompiledJavaVersionBuildItem.JavaVersion.Status.TRUE) {
            return;
        }
        final String className = "io.netty.util.internal.PlatformDependent0";
        producer.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setVisitorFunction((BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

            @Override
            public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                ClassTransformer transformer = new ClassTransformer(className);
                MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"getIsVirtualThreadMethod", Method.class, (Object[])new Object[0]);
                transformer.removeMethod(methodDescriptor);
                MethodCreator getIsVirtualThreadMethod = (MethodCreator)transformer.addMethod(methodDescriptor).setModifiers(10);
                getIsVirtualThreadMethod.returnValue(getIsVirtualThreadMethod.loadNull());
                methodDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"getBaseVirtualThreadClass", Class.class, (Object[])new Object[0]);
                transformer.removeMethod(methodDescriptor);
                MethodCreator getBaseVirtualThreadClassMethod = (MethodCreator)transformer.addMethod(methodDescriptor).setModifiers(10);
                getBaseVirtualThreadClassMethod.returnValue(getBaseVirtualThreadClassMethod.loadNull());
                methodDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"isVirtualThread", Boolean.TYPE, (Object[])new Object[]{Thread.class});
                transformer.removeMethod(methodDescriptor);
                MethodCreator isVirtualThreadMethod = (MethodCreator)transformer.addMethod(methodDescriptor).setModifiers(8);
                ResultHandle threadParam = isVirtualThreadMethod.getMethodParam(0);
                BranchResult nullCheck = isVirtualThreadMethod.ifNull(threadParam);
                nullCheck.trueBranch().returnValue(nullCheck.trueBranch().load(false));
                MethodDescriptor isVirtualMethod = MethodDescriptor.ofMethod(Thread.class, (String)"isVirtual", Boolean.TYPE, (Class[])new Class[0]);
                ResultHandle isVirtualResult = nullCheck.falseBranch().invokeVirtualMethod(isVirtualMethod, threadParam, new ResultHandle[0]);
                nullCheck.falseBranch().returnValue(isVirtualResult);
                return transformer.applyTo(classVisitor);
            }
        }).build());
    }

    @BuildStep
    void transformDefaultChannelId(BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformers) {
        String className = DefaultChannelId.class.getName();
        bytecodeTransformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setVisitorFunction((s, classVisitor) -> {
            ClassVisitor updateBytecodeVersion = new ClassVisitor(589824, (ClassVisitor)classVisitor){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(Math.max(version, 52), access, name, signature, superName, interfaces);
                }
            };
            ClassTransformer transformer = new ClassTransformer(className);
            MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Object)className, (String)"processHandlePid", Integer.TYPE, (Object[])new Object[]{ClassLoader.class});
            transformer.removeMethod(methodDescriptor);
            MethodCreator method = (MethodCreator)transformer.addMethod(methodDescriptor).setModifiers(8);
            AssignableResultHandle resultVar = method.createVariable(Integer.TYPE);
            TryBlock tryBlock = method.tryBlock();
            ResultHandle processHandle = tryBlock.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(ProcessHandle.class, (String)"current", ProcessHandle.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle pid = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(ProcessHandle.class, (String)"pid", Long.TYPE, (Class[])new Class[0]), processHandle, new ResultHandle[0]);
            ResultHandle maxInt = tryBlock.load(Integer.MAX_VALUE);
            ResultHandle cmp = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Long.class, (String)"compare", Integer.TYPE, (Class[])new Class[]{Long.TYPE, Long.TYPE}), new ResultHandle[]{pid, maxInt});
            BranchResult branchResult = tryBlock.ifGreaterThanZero(cmp);
            BytecodeCreator outOfRangeBranch = branchResult.trueBranch();
            outOfRangeBranch.assign(resultVar, outOfRangeBranch.load(-1));
            BytecodeCreator inRangeBranch = branchResult.falseBranch();
            inRangeBranch.assign(resultVar, inRangeBranch.convertPrimitive(pid, Integer.TYPE));
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            catchBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(InternalLogger.class, (String)"debug", Void.TYPE, (Class[])new Class[]{String.class, Throwable.class}), catchBlock.readStaticField(FieldDescriptor.of((String)className, (String)"logger", InternalLogger.class)), new ResultHandle[]{catchBlock.load("Could not invoke ProcessHandle.current().pid();"), catchBlock.getCaughtException()});
            catchBlock.assign(resultVar, catchBlock.load(-1));
            method.returnValue((ResultHandle)resultVar);
            return transformer.applyTo(updateBytecodeVersion);
        }).build());
    }

    @BuildStep
    void nativeTransportsEnableNativeAccess(BuildProducer<ModuleEnableNativeAccessBuildItem> nativeAccess) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.epoll.EpollMode")) {
            nativeAccess.produce((BuildItem)new ModuleEnableNativeAccessBuildItem("io.netty.transport.classes.epoll"));
        }
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.netty.channel.kqueue.AcceptFilter")) {
            nativeAccess.produce((BuildItem)new ModuleEnableNativeAccessBuildItem("io.netty.transport.classes.kqueue"));
        }
    }

    @BuildStep
    void indexTransports(BuildProducer<IndexDependencyBuildItem> producer) {
        producer.produce((BuildItem)new IndexDependencyBuildItem("io.netty", "netty-transport"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void transformIsSharable(CombinedIndexBuildItem indexBuildItem, NettyRecorder recorder, BuildProducer<BytecodeTransformerBuildItem> producer) {
        IndexView index = indexBuildItem.getIndex();
        index.getAnnotations(ChannelHandler.Sharable.class).forEach(ai -> {
            if (ai.target().kind() != AnnotationTarget.Kind.CLASS) {
                return;
            }
            String className = ai.target().asClass().name().toString();
            producer.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(className).setCacheable(true).setVisitorFunction((BiFunction)new AddSharableVisitorFunction(className)).build());
        });
        final String classAdapterClassName = "io.netty.channel.ChannelHandlerAdapter";
        producer.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(classAdapterClassName).setCacheable(true).setVisitorFunction((BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

            @Override
            public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                ClassTransformer transformer = new ClassTransformer(classAdapterClassName);
                MethodDescriptor isSharableMethod = MethodDescriptor.ofMethod((Object)classAdapterClassName, (String)"isSharable", Boolean.TYPE, (Object[])new Object[0]);
                transformer.modifyMethod(isSharableMethod).rename("isSharable0");
                MethodDescriptor isSharable0Method = MethodDescriptor.ofMethod((Object)classAdapterClassName, (String)"isSharable0", Boolean.TYPE, (Object[])new Object[0]);
                MethodCreator mc = transformer.addMethod(isSharableMethod);
                ResultHandle isInstanceOf = mc.instanceOf(mc.getThis(), NettySharable.class);
                BytecodeCreator trueBranch = mc.ifNonZero(isInstanceOf).trueBranch();
                trueBranch.returnValue(trueBranch.load(true));
                ResultHandle result = mc.invokeVirtualMethod(isSharable0Method, mc.getThis(), new ResultHandle[0]);
                mc.returnValue(result);
                return transformer.applyTo(classVisitor);
            }
        }).build());
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new JBossNettyLoggerFactory());
    }

    private static class AddSharableVisitorFunction
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final String className;

        private AddSharableVisitorFunction(String className) {
            this.className = className;
        }

        @Override
        public ClassVisitor apply(String s, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(this.className);
            transformer.addInterface(NettySharable.class);
            return transformer.applyTo(classVisitor);
        }
    }
}

