/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.deployment;

import io.netty.channel.EventLoopGroup;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.netty.BossEventLoopGroup;
import io.quarkus.netty.MainEventLoopGroup;
import io.quarkus.netty.deployment.EventLoopSupplierBuildItem;
import io.quarkus.netty.deployment.JBossNettyLoggerFactory;
import io.quarkus.netty.runtime.EmptyByteBufStub;
import io.quarkus.netty.runtime.NettyRecorder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.jboss.logging.Logger;
import org.jboss.logmanager.Level;

class NettyProcessor {
    private static final Logger log = Logger.getLogger(NettyProcessor.class);

    NettyProcessor() {
    }

    @BuildStep
    public NativeImageSystemPropertyBuildItem limitMem() {
        return new NativeImageSystemPropertyBuildItem("sun.nio.ch.maxUpdateArraySize", "100");
    }

    @BuildStep
    public SystemPropertyBuildItem limitArenaSize() {
        return new SystemPropertyBuildItem("io.netty.allocator.maxOrder", "1");
    }

    @BuildStep
    public SystemPropertyBuildItem setNettyMachineId() {
        int EUI64_MAC_ADDRESS_LENGTH = 8;
        byte[] machineIdBytes = new byte[8];
        new Random().nextBytes(machineIdBytes);
        String nettyMachineId = MacAddressUtil.formatAddress((byte[])machineIdBytes);
        return new SystemPropertyBuildItem("io.netty.machineId", nettyMachineId);
    }

    @BuildStep
    NativeImageConfigBuildItem build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioSocketChannel"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"io.netty.channel.socket.nio.NioServerSocketChannel"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"java.util.LinkedHashMap"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"sun.nio.ch.SelectorImpl"}));
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder().addNativeImageSystemProperty("io.netty.allocator.maxOrder", "1").addRuntimeInitializedClass("io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator").addRuntimeInitializedClass("io.netty.handler.ssl.ConscryptAlpnSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslEngine").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslContext").addRuntimeInitializedClass("io.netty.handler.ssl.ReferenceCountedOpenSslClientContext").addRuntimeInitializedClass("io.netty.handler.ssl.util.ThreadLocalInsecureRandom").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil$HexUtil").addRuntimeInitializedClass("io.netty.buffer.PooledByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufAllocator").addRuntimeInitializedClass("io.netty.buffer.ByteBufUtil").addNativeImageSystemProperty("io.netty.leakDetection.level", "DISABLED");
        try {
            Class.forName("io.netty.handler.codec.http.HttpObjectEncoder");
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http.HttpObjectEncoder").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder").addRuntimeInitializedClass("io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty HTTP classes as they were not found");
        }
        try {
            Class.forName("io.netty.handler.codec.http2.Http2CodecUtil");
            builder.addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2CodecUtil").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ClientUpgradeCodec").addRuntimeInitializedClass("io.netty.handler.codec.http2.DefaultHttp2FrameWriter").addRuntimeInitializedClass("io.netty.handler.codec.http2.Http2ConnectionHandler");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty HTTP2 classes as they were not found");
        }
        try {
            Class.forName("io.netty.channel.unix.UnixChannel");
            builder.addRuntimeInitializedClass("io.netty.channel.unix.Errors").addRuntimeInitializedClass("io.netty.channel.unix.FileDescriptor").addRuntimeInitializedClass("io.netty.channel.unix.IovArray").addRuntimeInitializedClass("io.netty.channel.unix.Limits");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty native unix classes as they were not found");
        }
        try {
            Class.forName("io.netty.channel.epoll.EpollMode");
            builder.addRuntimeInitializedClass("io.netty.channel.epoll.Epoll").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventArray").addRuntimeInitializedClass("io.netty.channel.epoll.EpollEventLoop").addRuntimeInitializedClass("io.netty.channel.epoll.Native");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty native epoll classes as they were not found");
        }
        try {
            Class.forName("io.netty.channel.kqueue.AcceptFilter");
            builder.addRuntimeInitializedClass("io.netty.channel.kqueue.KQueue").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventArray").addRuntimeInitializedClass("io.netty.channel.kqueue.KQueueEventLoop").addRuntimeInitializedClass("io.netty.channel.kqueue.Native");
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Not registering Netty native kqueue classes as they were not found");
        }
        return builder.build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void eagerlyInitClass(NettyRecorder recorder) {
        recorder.eagerlyInitChannelId();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerEventLoopBeans(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, Optional<EventLoopSupplierBuildItem> loopSupplierBuildItem, NettyRecorder recorder) {
        Supplier<EventLoopGroup> main;
        Supplier<EventLoopGroup> boss;
        if (loopSupplierBuildItem.isPresent()) {
            boss = loopSupplierBuildItem.get().getBossSupplier();
            main = loopSupplierBuildItem.get().getMainSupplier();
        } else {
            boss = recorder.createEventLoop(1);
            main = recorder.createEventLoop(0);
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EventLoopGroup.class).supplier(boss).scope(Singleton.class)).addQualifier(BossEventLoopGroup.class)).unremovable()).setRuntimeInit().done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EventLoopGroup.class).supplier(main).scope(Singleton.class)).addQualifier(MainEventLoopGroup.class)).unremovable()).setRuntimeInit().done());
    }

    @BuildStep
    AdditionalBeanBuildItem registerQualifiers() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{BossEventLoopGroup.class, MainEventLoopGroup.class}).build();
    }

    @BuildStep
    public RuntimeReinitializedClassBuildItem reinitScheduledFutureTask() {
        return new RuntimeReinitializedClassBuildItem("io.quarkus.netty.runtime.graal.Holder_io_netty_util_concurrent_ScheduledFutureTask");
    }

    @BuildStep
    public List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields() {
        return Arrays.asList(new UnsafeAccessedFieldBuildItem("sun.nio.ch.SelectorImpl", "selectedKeys"), new UnsafeAccessedFieldBuildItem("sun.nio.ch.SelectorImpl", "publicSelectedKeys"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerIndexField", "producerIndex"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueProducerLimitField", "producerLimit"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueueConsumerIndexField", "consumerIndex"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueProducerFields", "producerIndex"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields", "producerLimit"), new UnsafeAccessedFieldBuildItem("io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueConsumerFields", "consumerIndex"));
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitBcryptUtil() {
        return new RuntimeInitializedClassBuildItem(EmptyByteBufStub.class.getName());
    }

    @BuildStep
    LogCleanupFilterBuildItem cleanup() {
        return new LogCleanupFilterBuildItem(PlatformDependent.class.getName() + "0", (java.util.logging.Level)Level.TRACE, new String[]{"direct buffer constructor", "jdk.internal.misc.Unsafe", "sun.misc.Unsafe"});
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new JBossNettyLoggerFactory());
    }
}

