/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.mailer.Mail;
import io.quarkus.mailer.MockMailbox;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class MockMailboxImpl
implements MockMailbox {
    private Map<String, List<Mail>> sentMessages = new HashMap<String, List<Mail>>();
    private int sentMessagesCount;

    CompletionStage<Void> send(Mail email) {
        if (email.getTo() != null) {
            for (String to : email.getTo()) {
                this.send(email, to);
            }
        }
        if (email.getCc() != null) {
            for (String to : email.getCc()) {
                this.send(email, to);
            }
        }
        if (email.getBcc() != null) {
            for (String to : email.getBcc()) {
                this.send(email, to);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private void send(Mail sentMail, String to) {
        List<Mail> mails = this.sentMessages.get(to);
        if (mails == null) {
            mails = new LinkedList<Mail>();
            this.sentMessages.put(to, mails);
        }
        ++this.sentMessagesCount;
        mails.add(sentMail);
    }

    @Override
    public List<Mail> getMessagesSentTo(String address) {
        return this.sentMessages.get(address);
    }

    @Override
    public void clear() {
        this.sentMessagesCount = 0;
        this.sentMessages.clear();
    }

    @Override
    public int getTotalMessagesSent() {
        return this.sentMessagesCount;
    }
}

