/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class MockSupport {
    private static final Deque<List<Object>> contexts = new ArrayDeque<List<Object>>();

    MockSupport() {
    }

    static void pushContext() {
        contexts.push(new ArrayList());
    }

    static void popContext() {
        List<Object> val = contexts.pop();
        for (Object i : val) {
            try {
                i.getClass().getDeclaredMethod("arc$clearMock", new Class[0]).invoke(i, new Object[0]);
                MockSupport.mockObservers(i, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static <T> void installMock(T instance, T mock) {
        List<Object> inst = contexts.peek();
        if (inst == null) {
            throw new IllegalStateException("No test in progress");
        }
        if (!instance.getClass().getSuperclass().isAssignableFrom(mock.getClass())) {
            throw new RuntimeException(mock + " is not assignable to type " + instance.getClass().getSuperclass());
        }
        try {
            Method setMethod = instance.getClass().getDeclaredMethod("arc$setMock", Object.class);
            setMethod.invoke(instance, mock);
            inst.add(instance);
            MockSupport.mockObservers(instance, true);
        }
        catch (Exception e) {
            throw new RuntimeException(instance + " is not a normal scoped CDI bean, make sure the bean is a normal scope like @ApplicationScoped or @RequestScoped");
        }
    }

    private static <T> void mockObservers(T instance, boolean mock) throws NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method getBeanMethod = instance.getClass().getDeclaredMethod("arc_bean", new Class[0]);
        Object bean = getBeanMethod.invoke(instance, new Object[0]);
        Method getIdMethod = bean.getClass().getDeclaredMethod("getIdentifier", new Class[0]);
        String id = getIdMethod.invoke(bean, new Object[0]).toString();
        Method mockObserversMethod = instance.getClass().getClassLoader().loadClass("io.quarkus.arc.impl.ArcContainerImpl").getDeclaredMethod("mockObservers", String.class, Boolean.TYPE);
        mockObserversMethod.invoke(null, id, mock);
    }
}

