/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.ExclusiveProviderConflictException;
import io.quarkus.registry.PlatformPreferenceIndex;
import io.quarkus.registry.PlatformReleasePreferenceIndex;
import io.quarkus.registry.RegistryExtensionResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformReleaseVersion;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.PlatformStreamCoords;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.maven.MavenRegistryClientFactory;
import io.quarkus.registry.client.spi.RegistryClientEnvironment;
import io.quarkus.registry.client.spi.RegistryClientFactoryProvider;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class ExtensionCatalogResolver {
    private MessageWriter log;
    private RegistriesConfig config;
    private List<RegistryExtensionResolver> registries;

    public static ExtensionCatalogResolver empty() {
        ExtensionCatalogResolver resolver = new ExtensionCatalogResolver();
        resolver.registries = Collections.emptyList();
        resolver.log = MessageWriter.info();
        return resolver;
    }

    public static Builder builder() {
        return new ExtensionCatalogResolver().new Builder();
    }

    public RegistriesConfig getConfig() {
        return this.config;
    }

    public boolean hasRegistries() {
        return !this.registries.isEmpty();
    }

    public PlatformCatalog resolvePlatformCatalog() throws RegistryResolutionException {
        return this.resolvePlatformCatalog(null);
    }

    public PlatformCatalog resolvePlatformCatalog(String quarkusVersion) throws RegistryResolutionException {
        ArrayList<PlatformCatalog.Mutable> catalogs = new ArrayList<PlatformCatalog.Mutable>(this.registries.size());
        for (RegistryExtensionResolver qer : this.registries) {
            PlatformCatalog.Mutable catalog = qer.resolvePlatformCatalog(quarkusVersion);
            if (catalog == null) continue;
            catalogs.add(catalog);
        }
        if (catalogs.isEmpty()) {
            return null;
        }
        if (catalogs.size() == 1) {
            return (PlatformCatalog)catalogs.get(0);
        }
        ArrayList<Platform> collectedPlatforms = new ArrayList<Platform>();
        HashSet<String> collectedPlatformKeys = new HashSet<String>();
        String lastUpdated = null;
        boolean sawUnknownLastUpdate = false;
        for (PlatformCatalog platformCatalog : catalogs) {
            this.collectPlatforms(platformCatalog, collectedPlatforms, collectedPlatformKeys);
            if (sawUnknownLastUpdate) continue;
            Object catalogLastUpdated = platformCatalog.getMetadata().get("last-updated");
            if (catalogLastUpdated == null) {
                lastUpdated = null;
                sawUnknownLastUpdate = true;
                continue;
            }
            if (lastUpdated == null) {
                lastUpdated = catalogLastUpdated.toString();
                continue;
            }
            if (lastUpdated.compareTo(catalogLastUpdated.toString()) >= 0) continue;
            lastUpdated = catalogLastUpdated.toString();
        }
        PlatformCatalog.Mutable result = PlatformCatalog.builder();
        if (lastUpdated != null) {
            result.getMetadata().put("last-updated", lastUpdated);
        }
        result.setPlatforms(collectedPlatforms);
        return result.build();
    }

    private void collectPlatforms(PlatformCatalog catalog, List<Platform> collectedPlatforms, Set<String> collectedPlatformKeys) {
        for (Platform p : catalog.getPlatforms()) {
            if (!collectedPlatformKeys.add(p.getPlatformKey())) continue;
            collectedPlatforms.add(p);
        }
    }

    public PlatformCatalog resolvePlatformCatalogFromRegistry(String registryId) throws RegistryResolutionException {
        return this.getRegistryExtensionResolver(registryId).resolvePlatformCatalog();
    }

    public PlatformCatalog resolvePlatformCatalogFromRegistry(String registryId, String quarkusVersion) throws RegistryResolutionException {
        return quarkusVersion == null ? this.resolvePlatformCatalogFromRegistry(registryId) : this.getRegistryExtensionResolver(registryId).resolvePlatformCatalog(quarkusVersion);
    }

    private RegistryExtensionResolver getRegistryExtensionResolver(String registryId) {
        for (RegistryExtensionResolver registryExtResolver : this.registries) {
            if (!registryExtResolver.getId().equals(registryId)) continue;
            return registryExtResolver;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to locate ").append(registryId).append(" among the configured registries:");
        this.registries.forEach(r -> buf.append(" ").append(r.getId()));
        throw new IllegalStateException(buf.toString());
    }

    public ExtensionCatalog resolveExtensionCatalog() throws RegistryResolutionException {
        this.ensureRegistriesConfigured();
        ExtensionCatalogBuilder catalogBuilder = new ExtensionCatalogBuilder();
        for (RegistryExtensionResolver registry : this.registries) {
            this.collectPlatformExtensions(catalogBuilder, registry);
        }
        return catalogBuilder.build();
    }

    private void collectPlatformExtensions(ExtensionCatalogBuilder catalogBuilder, RegistryExtensionResolver registry) throws RegistryResolutionException {
        PlatformCatalog pc = ExtensionCatalogResolver.resolvePlatformCatalog(registry, catalogBuilder.upstreamQuarkusVersions);
        if (pc == null) {
            return;
        }
        int registryPreferenceIndex = catalogBuilder.getRegistryPreferenceIndex(registry.getId());
        for (Platform platform : pc.getPlatforms()) {
            PlatformReleasePreferenceIndex releasePreferenceIndex = catalogBuilder.getPlatformPreferenceIndex(registryPreferenceIndex, platform.getPlatformKey());
            int platformIndex = releasePreferenceIndex.getPlatformIndex();
            for (PlatformStream stream : platform.getStreams()) {
                for (PlatformRelease release : stream.getReleases()) {
                    int releaseIndex = releasePreferenceIndex.getReleaseIndex(release.getVersion().toString());
                    String quarkusVersion = release.getQuarkusCoreVersion();
                    int compatiblityCode = catalogBuilder.getCompatibilityCode(quarkusVersion, release.getUpstreamQuarkusCoreVersion());
                    if (!registry.isExclusiveProviderOf(quarkusVersion)) {
                        catalogBuilder.addUpstreamQuarkusVersion(quarkusVersion);
                    }
                    if (release.getUpstreamQuarkusCoreVersion() != null) {
                        catalogBuilder.addUpstreamQuarkusVersion(release.getUpstreamQuarkusCoreVersion());
                    }
                    int memberIndex = 0;
                    for (ArtifactCoords bom : release.getMemberBoms()) {
                        ++memberIndex;
                        ExtensionCatalog.Mutable ec = registry.resolvePlatformExtensions(bom);
                        if (ec != null) {
                            OriginPreference originPreference = new OriginPreference(registryPreferenceIndex, platformIndex, releaseIndex, memberIndex, compatiblityCode);
                            ExtensionCatalogResolver.addOriginPreference(ec, originPreference);
                            catalogBuilder.addCatalog(ec);
                            continue;
                        }
                        this.log.warn("Failed to resolve extension catalog for %s from registry %s", new Object[]{bom, registry.getId()});
                    }
                }
            }
        }
    }

    private static PlatformCatalog resolvePlatformCatalog(RegistryExtensionResolver registry, List<String> quarkusVersions) throws RegistryResolutionException {
        PlatformCatalog.Mutable defaultCatalog = registry.resolvePlatformCatalog();
        if (quarkusVersions.isEmpty()) {
            return defaultCatalog;
        }
        List<PlatformCatalog> catalogsToMerge = List.of();
        for (int i = 0; i < quarkusVersions.size(); ++i) {
            PlatformCatalog.Mutable pcForQuarkusVersion;
            String quarkusVersion = quarkusVersions.get(i);
            if (!registry.isAcceptsQuarkusVersionQueries(quarkusVersion) || (pcForQuarkusVersion = registry.resolvePlatformCatalog(quarkusVersion)) == null) continue;
            if (catalogsToMerge.isEmpty()) {
                catalogsToMerge = new ArrayList<PlatformCatalog>(quarkusVersions.size() - i + 1);
                if (defaultCatalog != null) {
                    catalogsToMerge.add(defaultCatalog);
                }
            }
            catalogsToMerge.add(pcForQuarkusVersion);
        }
        if (catalogsToMerge.isEmpty()) {
            return defaultCatalog;
        }
        return CatalogMergeUtility.mergePlatformCatalogs(catalogsToMerge);
    }

    private static void addOriginPreference(ExtensionCatalog.Mutable ec, OriginPreference originPreference) {
        ec.getMetadata().put("registry-client:origin-preference", originPreference);
    }

    public ExtensionCatalog resolveExtensionCatalog(String quarkusCoreVersion) throws RegistryResolutionException {
        if (quarkusCoreVersion == null) {
            return this.resolveExtensionCatalog();
        }
        int registriesTotal = this.registries.size();
        if (registriesTotal == 0) {
            throw new RegistryResolutionException("No registries configured");
        }
        return this.resolveExtensionCatalog(quarkusCoreVersion, new ExtensionCatalogBuilder(), Collections.emptySet());
    }

    private ExtensionCatalog resolveExtensionCatalog(String quarkusCoreVersion, ExtensionCatalogBuilder catalogBuilder, Set<String> preferredPlatformKeys) throws RegistryResolutionException {
        ExtensionCatalogResolver.collectPlatformExtensions(quarkusCoreVersion, catalogBuilder, preferredPlatformKeys);
        int i = 0;
        while (i < catalogBuilder.upstreamQuarkusVersions.size()) {
            ExtensionCatalogResolver.collectPlatformExtensions(catalogBuilder.upstreamQuarkusVersions.get(i++), catalogBuilder, preferredPlatformKeys);
        }
        return catalogBuilder.build();
    }

    public ExtensionCatalog resolveExtensionCatalog(PlatformStreamCoords streamCoords) throws RegistryResolutionException {
        this.ensureRegistriesConfigured();
        ExtensionCatalog catalog = this.resolveExtensionCatalogForStreamIfFound(streamCoords, true);
        if (catalog != null) {
            return catalog;
        }
        catalog = this.resolveExtensionCatalogForStreamIfFound(streamCoords, false);
        if (catalog != null) {
            return catalog;
        }
        throw this.unknownStreamException(streamCoords, false);
    }

    protected ExtensionCatalog resolveExtensionCatalogForStreamIfFound(PlatformStreamCoords streamCoords, boolean amongRecommended) throws RegistryResolutionException {
        for (RegistryExtensionResolver registry : this.registries) {
            PlatformStream stream;
            PlatformCatalog.Mutable platforms = amongRecommended ? registry.resolvePlatformCatalog() : registry.resolvePlatformCatalog("all");
            if (platforms == null) continue;
            if (streamCoords.getPlatformKey() == null) {
                for (Platform p : platforms.getPlatforms()) {
                    PlatformStream stream2 = p.getStream(streamCoords.getStreamId());
                    if (stream2 == null) continue;
                    return this.resolveExtensionCatalogForStream(stream2, List.of(registry));
                }
                continue;
            }
            Platform platform = platforms.getPlatform(streamCoords.getPlatformKey());
            if (platform == null || (stream = platform.getStream(streamCoords.getStreamId())) == null) continue;
            return this.resolveExtensionCatalogForStream(stream, List.of(registry));
        }
        return null;
    }

    private ExtensionCatalog resolveExtensionCatalogForStream(PlatformStream stream, List<RegistryExtensionResolver> registries) throws RegistryResolutionException {
        ExtensionCatalogBuilder catalogBuilder = new ExtensionCatalogBuilder();
        for (PlatformRelease release : stream.getReleases()) {
            this.collectExtensionCatalogs(release.getMemberBoms(), catalogBuilder, registries);
        }
        return catalogBuilder.build();
    }

    protected RegistryResolutionException unknownStreamException(PlatformStreamCoords stream, boolean amongRecommended) throws RegistryResolutionException {
        Platform requestedPlatform = null;
        ArrayList<Platform> knownPlatforms = new ArrayList<Platform>();
        for (RegistryExtensionResolver qer : this.registries) {
            PlatformCatalog.Mutable platforms = amongRecommended ? qer.resolvePlatformCatalog() : qer.resolvePlatformCatalog("all");
            if (platforms == null) continue;
            if (stream.getPlatformKey() != null && (requestedPlatform = platforms.getPlatform(stream.getPlatformKey())) != null) break;
            knownPlatforms.addAll(platforms.getPlatforms());
        }
        StringBuilder buf = new StringBuilder();
        if (requestedPlatform != null) {
            buf.append("Failed to locate stream ").append(stream.getStreamId()).append(" in platform ").append(requestedPlatform.getPlatformKey());
        } else if (knownPlatforms.isEmpty()) {
            buf.append("None of the registries provided any platform");
        } else {
            if (stream.getPlatformKey() == null) {
                buf.append("Failed to locate stream ").append(stream.getStreamId()).append(" in platform(s): ");
            } else {
                buf.append("Failed to locate platform ").append(stream.getPlatformKey()).append(" among available platform(s): ");
            }
            buf.append(((Platform)knownPlatforms.get(0)).getPlatformKey());
            for (int i = 1; i < knownPlatforms.size(); ++i) {
                buf.append(", ").append(((Platform)knownPlatforms.get(i)).getPlatformKey());
            }
        }
        return new RegistryResolutionException(buf.toString());
    }

    public ExtensionCatalog resolveExtensionCatalog(Collection<ArtifactCoords> preferredPlatforms) throws RegistryResolutionException {
        if (preferredPlatforms.isEmpty()) {
            return this.resolveExtensionCatalog();
        }
        ExtensionCatalogBuilder catalogBuilder = new ExtensionCatalogBuilder();
        this.collectExtensionCatalogs(preferredPlatforms, catalogBuilder, List.of());
        return catalogBuilder.build();
    }

    private void collectExtensionCatalogs(Collection<ArtifactCoords> preferredPlatforms, ExtensionCatalogBuilder catalogBuilder, List<RegistryExtensionResolver> registries) throws RegistryResolutionException {
        HashSet<String> preferredPlatformKeys = new HashSet<String>(4);
        HashSet<ArtifactCoords> addedPlatformBoms = new HashSet<ArtifactCoords>();
        String quarkusVersion = null;
        for (ArtifactCoords bom : preferredPlatforms) {
            Map platformRelease;
            Object o;
            Map<String, Object> md;
            if (!addedPlatformBoms.add(bom)) continue;
            if (registries == null || registries.isEmpty()) {
                try {
                    registries = this.filterRegistries(r -> r.checkPlatform(bom));
                }
                catch (ExclusiveProviderConflictException e) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("The following registries were configured as exclusive providers of the ");
                    buf.append(PlatformArtifacts.ensureBomArtifact(bom).toCompactCoords());
                    buf.append(" platform: ").append(e.conflictingRegistries.get(0).getId());
                    for (int i = 1; i < e.conflictingRegistries.size(); ++i) {
                        buf.append(", ").append(e.conflictingRegistries.get(i).getId());
                    }
                    throw new RegistryResolutionException(buf.toString());
                }
                if (registries.isEmpty()) {
                    this.log.warn("None of the configured registries recognizes platform " + bom.toCompactCoords());
                    continue;
                }
            }
            ExtensionCatalog catalog = null;
            RegistryExtensionResolver registry = null;
            int registryPreferenceIndex = 0;
            for (int i = 0; i < registries.size(); ++i) {
                registry = registries.get(i);
                try {
                    catalog = registry.resolvePlatformExtensions(bom);
                    registryPreferenceIndex = catalogBuilder.getRegistryPreferenceIndex(registry.getId());
                    break;
                }
                catch (RegistryResolutionException e) {
                    if (registries.size() == i + 1) {
                        throw e;
                    }
                    this.log.debug("%s", new Object[]{e.getLocalizedMessage()});
                    continue;
                }
            }
            if (catalog == null) {
                StringBuilder buf = new StringBuilder();
                buf.append("Failed to resolve extension catalog of ").append(PlatformArtifacts.ensureBomArtifact(bom).toCompactCoords()).append(" from ");
                buf.append(registries.get(0).getId());
                for (int i = 1; i < registries.size(); ++i) {
                    buf.append(", ").append(registries.get(i));
                }
                this.log.warn(buf.toString());
                throw new RegistryResolutionException(buf.toString());
            }
            if (quarkusVersion == null) {
                quarkusVersion = catalog.getQuarkusCoreVersion();
            }
            if ((md = catalog.getMetadata()) != null && (o = md.get("platform-release")) instanceof Map && (o = (platformRelease = (Map)o).get("platform-key")) instanceof String) {
                String platformKey = (String)o;
                if (!preferredPlatformKeys.add(platformKey)) continue;
                Platform.Mutable platform = Platform.builder().setPlatformKey(platformKey);
                PlatformStream.Mutable stream = PlatformStream.builder().setId(String.valueOf(platformRelease.getOrDefault("stream", "default")));
                platform.addStream(stream);
                PlatformRelease.Mutable release = PlatformRelease.builder().setVersion(PlatformReleaseVersion.fromString(String.valueOf(platformRelease.getOrDefault("version", "default")))).setQuarkusCoreVersion(catalog.getQuarkusCoreVersion()).setUpstreamQuarkusCoreVersion(catalog.getUpstreamQuarkusCoreVersion());
                stream.addRelease(release);
                o = platformRelease.get("members");
                if (o != null) {
                    Collection col = (Collection)o;
                    ArrayList<ArtifactCoords> memberCatalogs = new ArrayList<ArtifactCoords>(col.size());
                    for (String s : col) {
                        ArtifactCoords memberCatalogCoords = ArtifactCoords.fromString((String)s);
                        memberCatalogs.add(memberCatalogCoords);
                        addedPlatformBoms.add(PlatformArtifacts.getBomArtifactForCatalog(memberCatalogCoords));
                    }
                    release.setMemberBoms(memberCatalogs);
                }
                ExtensionCatalogResolver.collectPlatformExtensions(catalogBuilder, registry, platform);
                continue;
            }
            int platformIndex = catalogBuilder.getPlatformPreferenceIndex(registryPreferenceIndex, bom.getGroupId()).getPlatformIndex();
            OriginPreference originPreference = new OriginPreference(registryPreferenceIndex, platformIndex, 1, 1, catalogBuilder.getCompatibilityCode(quarkusVersion));
            ExtensionCatalogResolver.addOriginPreference((ExtensionCatalog.Mutable)catalog, originPreference);
            catalogBuilder.addCatalog((ExtensionCatalog.Mutable)catalog);
        }
        if (quarkusVersion == null && catalogBuilder.catalogs.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            Iterator<ArtifactCoords> boms = preferredPlatforms.iterator();
            buf.append(PlatformArtifacts.ensureBomArtifact(boms.next()).toCompactCoords());
            while (boms.hasNext()) {
                buf.append(", ").append(PlatformArtifacts.ensureBomArtifact(boms.next()).toCompactCoords());
            }
            buf.append(" could not be resolved from ");
            RegistryExtensionResolver registry = registries.get(0);
            buf.append(registry.getId());
            for (int i = 1; i < registries.size(); ++i) {
                buf.append(", ").append(registries.get(i).getId());
            }
            throw new RegistryResolutionException(buf.toString());
        }
        catalogBuilder.addUpstreamExtensionCatalogs(quarkusVersion, preferredPlatformKeys);
    }

    public void clearRegistryCache() throws RegistryResolutionException {
        for (RegistryExtensionResolver registry : this.registries) {
            registry.clearCache();
        }
    }

    private void ensureRegistriesConfigured() throws RegistryResolutionException {
        int registriesTotal = this.registries.size();
        if (registriesTotal == 0) {
            throw new RegistryResolutionException("No registries configured");
        }
    }

    private static void appendNonPlatformExtensions(ExtensionCatalogBuilder catalogBuilder, String quarkusVersion) throws RegistryResolutionException {
        for (RegistryExtensionResolver registry : catalogBuilder.getRegistriesForQuarkusCore(quarkusVersion)) {
            ExtensionCatalogResolver.appendNonPlatformExtensions(registry, catalogBuilder, quarkusVersion);
        }
    }

    private static void appendNonPlatformExtensions(RegistryExtensionResolver registry, ExtensionCatalogBuilder catalogBuilder, String quarkusVersion) throws RegistryResolutionException {
        ExtensionCatalog.Mutable nonPlatformCatalog = registry.resolveNonPlatformExtensions(quarkusVersion);
        if (nonPlatformCatalog == null) {
            return;
        }
        int compatibilityCode = catalogBuilder.getCompatibilityCode(quarkusVersion);
        OriginPreference originPreference = new OriginPreference(catalogBuilder.getRegistryPreferenceIndex(registry.getId()), Integer.MAX_VALUE, compatibilityCode, 0, compatibilityCode);
        ExtensionCatalogResolver.addOriginPreference(nonPlatformCatalog, originPreference);
        catalogBuilder.addCatalog(nonPlatformCatalog);
    }

    private static void collectPlatformExtensions(String quarkusCoreVersion, ExtensionCatalogBuilder catalogBuilder, Set<String> processedPlatformKeys) throws RegistryResolutionException {
        List<RegistryExtensionResolver> quarkusVersionRegistries = catalogBuilder.getRegistriesForQuarkusCore(quarkusCoreVersion);
        for (RegistryExtensionResolver registry : quarkusVersionRegistries) {
            Collection<Platform> platforms;
            PlatformCatalog.Mutable platformCatalog = registry.resolvePlatformCatalog(quarkusCoreVersion);
            if (platformCatalog == null || (platforms = platformCatalog.getPlatforms()).isEmpty()) continue;
            for (Platform p : platforms) {
                if (processedPlatformKeys.contains(p.getPlatformKey())) continue;
                ExtensionCatalogResolver.collectPlatformExtensions(catalogBuilder, registry, p);
            }
        }
    }

    private static void collectPlatformExtensions(ExtensionCatalogBuilder catalogBuilder, RegistryExtensionResolver registry, Platform platform) throws RegistryResolutionException {
        int registryPreferenceIndex = catalogBuilder.getRegistryPreferenceIndex(registry.getId());
        PlatformReleasePreferenceIndex releasePreference = catalogBuilder.getPlatformPreferenceIndex(registryPreferenceIndex, platform.getPlatformKey());
        for (PlatformStream s : platform.getStreams()) {
            for (PlatformRelease r : s.getReleases()) {
                int releaseIndex = releasePreference.getReleaseIndex(r.getVersion().toString());
                int memberIndex = 0;
                int compatibilityCode = catalogBuilder.getCompatibilityCode(r.getQuarkusCoreVersion(), r.getUpstreamQuarkusCoreVersion());
                for (ArtifactCoords bom : r.getMemberBoms()) {
                    ExtensionCatalog.Mutable catalog = registry.resolvePlatformExtensions(bom);
                    if (catalog == null) continue;
                    OriginPreference originPreference = new OriginPreference(registryPreferenceIndex, releasePreference.getPlatformIndex(), releaseIndex, ++memberIndex, compatibilityCode);
                    ExtensionCatalogResolver.addOriginPreference(catalog, originPreference);
                    catalogBuilder.addCatalog(catalog);
                }
                String upstreamQuarkusVersion = r.getUpstreamQuarkusCoreVersion();
                if (upstreamQuarkusVersion == null) continue;
                catalogBuilder.addUpstreamQuarkusVersion(upstreamQuarkusVersion);
            }
        }
    }

    private List<RegistryExtensionResolver> getRegistriesForQuarkusVersion(String quarkusCoreVersion) {
        try {
            return this.filterRegistries(r -> r.checkQuarkusVersion(quarkusCoreVersion));
        }
        catch (ExclusiveProviderConflictException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("The following registries were configured as exclusive providers of extensions based on Quarkus version ");
            buf.append(quarkusCoreVersion);
            buf.append(": ").append(e.conflictingRegistries.get(0).getId());
            for (int i = 1; i < e.conflictingRegistries.size(); ++i) {
                buf.append(", ").append(e.conflictingRegistries.get(i).getId());
            }
            throw new RuntimeException(buf.toString());
        }
    }

    private List<RegistryExtensionResolver> filterRegistries(Function<RegistryExtensionResolver, Integer> recognizer) throws ExclusiveProviderConflictException {
        RegistryExtensionResolver exclusiveProvider = null;
        ArrayList<RegistryExtensionResolver> filtered = null;
        ArrayList<RegistryExtensionResolver> conflicts = null;
        for (int i = 0; i < this.registries.size(); ++i) {
            RegistryExtensionResolver registry = this.registries.get(i);
            int versionCheck = recognizer.apply(registry);
            if (versionCheck == -1) {
                if (exclusiveProvider != null || filtered != null) continue;
                filtered = new ArrayList<RegistryExtensionResolver>(this.registries.size() - 1);
                for (int j = 0; j < i; ++j) {
                    filtered.add(this.registries.get(j));
                }
                continue;
            }
            if (versionCheck == 2) {
                if (exclusiveProvider == null) {
                    exclusiveProvider = registry;
                } else {
                    if (conflicts == null) {
                        conflicts = new ArrayList<RegistryExtensionResolver>();
                        conflicts.add(exclusiveProvider);
                    }
                    conflicts.add(registry);
                }
            }
            if (filtered == null) continue;
            filtered.add(registry);
        }
        if (conflicts != null) {
            throw new ExclusiveProviderConflictException(conflicts);
        }
        return exclusiveProvider == null ? (filtered == null ? this.registries : filtered) : List.of(exclusiveProvider);
    }

    public class Builder {
        private MavenArtifactResolver artifactResolver;
        private boolean built;
        private RegistryClientFactory defaultClientFactory;
        private RegistryClientEnvironment clientEnv;

        private Builder() {
        }

        public Builder artifactResolver(MavenArtifactResolver resolver) {
            this.assertNotBuilt();
            this.artifactResolver = resolver;
            return this;
        }

        public Builder messageWriter(MessageWriter messageWriter) {
            this.assertNotBuilt();
            ExtensionCatalogResolver.this.log = messageWriter;
            return this;
        }

        public Builder config(RegistriesConfig registriesConfig) {
            this.assertNotBuilt();
            ExtensionCatalogResolver.this.config = registriesConfig;
            return this;
        }

        public ExtensionCatalogResolver build() throws RegistryResolutionException {
            this.assertNotBuilt();
            this.built = true;
            this.completeConfig();
            this.buildRegistryClients();
            return ExtensionCatalogResolver.this;
        }

        private void completeConfig() {
            if (ExtensionCatalogResolver.this.config == null) {
                ExtensionCatalogResolver.this.config = RegistriesConfigLocator.resolveConfig();
            }
            if (ExtensionCatalogResolver.this.log == null) {
                MessageWriter messageWriter = ExtensionCatalogResolver.this.log = ExtensionCatalogResolver.this.config.isDebug() ? MessageWriter.debug() : MessageWriter.info();
            }
            if (this.artifactResolver == null) {
                try {
                    this.artifactResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setWorkspaceDiscovery(false)).setArtifactTransferLogging(ExtensionCatalogResolver.this.config.isDebug())).build();
                }
                catch (BootstrapMavenException e) {
                    throw new IllegalStateException("Failed to intialize the default Maven artifact resolver", e);
                }
            }
        }

        private void buildRegistryClients() throws RegistryResolutionException {
            ExtensionCatalogResolver.this.registries = new ArrayList<RegistryExtensionResolver>(ExtensionCatalogResolver.this.config.getRegistries().size());
            for (RegistryConfig config : ExtensionCatalogResolver.this.config.getRegistries()) {
                if (!config.isEnabled()) continue;
                RegistryClientFactory clientFactory = this.getClientFactory(config);
                ExtensionCatalogResolver.this.registries.add(new RegistryExtensionResolver(clientFactory.buildRegistryClient(config), ExtensionCatalogResolver.this.log));
            }
        }

        private RegistryClientFactory getClientFactory(RegistryConfig config) {
            if (config.getExtra().isEmpty()) {
                return this.getDefaultClientFactory();
            }
            Object provider = config.getExtra().get("client-factory-artifact");
            if (provider != null) {
                return this.loadFromArtifact(config, provider);
            }
            provider = config.getExtra().get("client-factory-url");
            if (provider != null) {
                URL url;
                try {
                    url = new URL((String)provider);
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Failed to translate " + String.valueOf(provider) + " to URL", e);
                }
                return this.loadFromUrl(url);
            }
            return this.getDefaultClientFactory();
        }

        public RegistryClientFactory loadFromArtifact(RegistryConfig config, Object providerValue) {
            URL url;
            File providerJar;
            ArtifactCoords providerArtifact;
            try {
                String providerStr = (String)providerValue;
                providerArtifact = ArtifactCoords.fromString((String)providerStr);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to process configuration of " + config.getId() + " registry: failed to cast " + String.valueOf(providerValue) + " to String", e);
            }
            try {
                providerJar = this.artifactResolver.resolve((Artifact)new DefaultArtifact(providerArtifact.getGroupId(), providerArtifact.getArtifactId(), providerArtifact.getClassifier(), providerArtifact.getType(), providerArtifact.getVersion())).getArtifact().getFile();
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to resolve the registry client factory provider artifact " + String.valueOf(providerArtifact), e);
            }
            ExtensionCatalogResolver.this.log.debug("Loading registry client factory for %s from %s", new Object[]{config.getId(), providerArtifact});
            try {
                url = providerJar.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to translate " + String.valueOf(providerJar) + " to URL", e);
            }
            return this.loadFromUrl(url);
        }

        private RegistryClientFactory loadFromUrl(URL url) {
            try {
                URLClassLoader providerCl = new URLClassLoader(new URL[]{url}, RegistryClientFactoryProvider.class.getClassLoader());
                Iterator<RegistryClientFactoryProvider> i = ServiceLoader.load(RegistryClientFactoryProvider.class, providerCl).iterator();
                if (!i.hasNext()) {
                    throw new Exception("Failed to locate an implementation of " + RegistryClientFactoryProvider.class.getName() + " service provider");
                }
                RegistryClientFactoryProvider provider = i.next();
                if (i.hasNext()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Found more than one registry client factory provider ").append(provider.getClass().getName());
                    while (i.hasNext()) {
                        buf.append(", ").append(i.next().getClass().getName());
                    }
                    throw new Exception(buf.toString());
                }
                return provider.newRegistryClientFactory(this.getClientEnv());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load registry client factory from " + String.valueOf(url), e);
            }
        }

        private RegistryClientFactory getDefaultClientFactory() {
            return this.defaultClientFactory == null ? (this.defaultClientFactory = new MavenRegistryClientFactory(this.artifactResolver, ExtensionCatalogResolver.this.log)) : this.defaultClientFactory;
        }

        private RegistryClientEnvironment getClientEnv() {
            return this.clientEnv == null ? (this.clientEnv = new RegistryClientEnvironment(){

                @Override
                public MessageWriter log() {
                    return ExtensionCatalogResolver.this.log;
                }

                @Override
                public MavenArtifactResolver resolver() {
                    return Builder.this.artifactResolver;
                }
            }) : this.clientEnv;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("The builder has already built an instance");
            }
        }
    }

    private class ExtensionCatalogBuilder {
        private final List<ExtensionCatalog.Mutable> catalogs = new ArrayList<ExtensionCatalog.Mutable>();
        final Map<String, List<RegistryExtensionResolver>> registriesByQuarkusCore = new HashMap<String, List<RegistryExtensionResolver>>();
        private final Map<String, Integer> compatibilityCodes = new LinkedHashMap<String, Integer>();
        final List<String> upstreamQuarkusVersions = new ArrayList<String>(1);
        final PlatformPreferenceIndex platformPreferenceIndex = new PlatformPreferenceIndex();
        final List<String> registryPreferenceIndex = new ArrayList<String>(2);

        private ExtensionCatalogBuilder() {
        }

        int getRegistryPreferenceIndex(String registryId) {
            for (int i = 0; i < this.registryPreferenceIndex.size(); ++i) {
                if (!this.registryPreferenceIndex.get(i).equals(registryId)) continue;
                return i;
            }
            this.registryPreferenceIndex.add(registryId);
            return this.registryPreferenceIndex.size() - 1;
        }

        PlatformReleasePreferenceIndex getPlatformPreferenceIndex(int registryIndex, String platformKey) {
            return this.platformPreferenceIndex.getReleaseIndex(registryIndex, platformKey);
        }

        void addCatalog(ExtensionCatalog.Mutable c) {
            this.catalogs.add(c);
        }

        void addUpstreamQuarkusVersion(String quarkusVersion) {
            if (!this.upstreamQuarkusVersions.contains(quarkusVersion)) {
                this.upstreamQuarkusVersions.add(quarkusVersion);
            }
        }

        List<RegistryExtensionResolver> getRegistriesForQuarkusCore(String quarkusVersion) {
            return this.registriesByQuarkusCore.computeIfAbsent(quarkusVersion, ExtensionCatalogResolver.this::getRegistriesForQuarkusVersion);
        }

        public int getCompatibilityCode(String quarkusVersion) {
            return this.getCompatibilityCode(quarkusVersion, null);
        }

        public int getCompatibilityCode(String quarkusVersion, String upstreamQuarkusVersion) {
            Integer i = this.compatibilityCodes.get(quarkusVersion);
            if (i == null) {
                i = upstreamQuarkusVersion != null ? this.compatibilityCodes.computeIfAbsent(upstreamQuarkusVersion, cc -> this.compatibilityCodes.size()) : Integer.valueOf(this.compatibilityCodes.size());
                this.compatibilityCodes.put(quarkusVersion, i);
            }
            return i;
        }

        void appendAllNonPlatformExtensions() throws RegistryResolutionException {
            for (String quarkusVersion : this.compatibilityCodes.keySet()) {
                ExtensionCatalogResolver.appendNonPlatformExtensions(this, quarkusVersion);
            }
        }

        void addUpstreamExtensionCatalogs(String quarkusCoreVersion, Set<String> processedPlatformKeys) throws RegistryResolutionException {
            ExtensionCatalogResolver.collectPlatformExtensions(quarkusCoreVersion, this, processedPlatformKeys);
            int i = 0;
            while (i < this.upstreamQuarkusVersions.size()) {
                ExtensionCatalogResolver.collectPlatformExtensions(this.upstreamQuarkusVersions.get(i++), this, processedPlatformKeys);
            }
            this.upstreamQuarkusVersions.clear();
        }

        ExtensionCatalog build() throws RegistryResolutionException {
            this.appendAllNonPlatformExtensions();
            if (this.catalogs.isEmpty()) {
                List<RegistryExtensionResolver> registries = ExtensionCatalogResolver.this.registries;
                if (registries.isEmpty()) {
                    throw new RegistryResolutionException("Quarkus extension registry is not available");
                }
                if (registries.size() == 1) {
                    throw new RegistryResolutionException("Quarkus extension registry " + registries.get(0).getId() + " did not provide any extension catalog");
                }
                StringBuilder buf = new StringBuilder();
                buf.append("Quarkus extension registries ");
                buf.append(registries.get(0).getId());
                for (int i = 1; i < registries.size(); ++i) {
                    buf.append(", ").append(registries.get(i).getId());
                }
                buf.append(" did not provide any extension catalog");
                throw new RegistryResolutionException(buf.toString());
            }
            return CatalogMergeUtility.merge(this.catalogs);
        }
    }
}

