/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.client.RegistryClientDispatcher;
import io.quarkus.registry.client.RegistryClientFactory;
import io.quarkus.registry.client.RegistryNonPlatformExtensionsResolver;
import io.quarkus.registry.client.RegistryPlatformsResolver;
import io.quarkus.registry.client.maven.MavenNonPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenPlatformsResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolverWithCleanup;
import io.quarkus.registry.client.maven.MavenRegistryCache;
import io.quarkus.registry.client.maven.RegistryCacheRefreshLogger;
import io.quarkus.registry.config.RegistryArtifactConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryMavenRepoConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.TransferListener;

public class MavenRegistryClientFactory
implements RegistryClientFactory {
    private static final String CLEANUP_TIMESTAMPED_ARTIFACTS = "cleanup-timestamped-artifacts";
    private final MessageWriter log;
    private final MavenArtifactResolver originalResolver;

    public MavenRegistryClientFactory(MavenArtifactResolver resolver, MessageWriter log) {
        this.originalResolver = Objects.requireNonNull(resolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public RegistryClient buildRegistryClient(RegistryConfig config) throws RegistryResolutionException {
        RegistryConfig.Mutable descriptor;
        ArtifactResult result;
        MavenArtifactResolver resolver;
        Objects.requireNonNull(config, "The registry config is null");
        Artifact registryDescriptorCoords = MavenRegistryClientFactory.getDescriptorCoords(config);
        boolean cleanupTimestampedArtifacts = MavenRegistryClientFactory.isCleanupTimestampedArtifacts(config);
        List<RemoteRepository> registryRepos = this.determineRegistryRepos(config, this.originalResolver.getRepositories());
        if (!registryRepos.isEmpty()) {
            List<RemoteRepository> aggregatedRepos = this.applyMirrorsAndProxies(registryRepos);
            resolver = MavenRegistryClientFactory.newResolver(this.originalResolver, aggregatedRepos, config, this.log);
            try {
                result = MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(resolver, registryDescriptorCoords, cleanupTimestampedArtifacts);
            }
            catch (BootstrapMavenException e) {
                if (MavenRegistryClientFactory.areMatching(registryRepos, aggregatedRepos)) {
                    throw new RegistryResolutionException(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e), e);
                }
                this.log.warn(MavenRegistryClientFactory.getDescriptorResolutionFailureFromMirrorMessage(config, resolver, e, registryRepos));
                resolver = MavenRegistryClientFactory.newResolver(this.originalResolver, registryRepos, config, this.log);
                try {
                    result = MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(resolver, registryDescriptorCoords, cleanupTimestampedArtifacts);
                }
                catch (BootstrapMavenException e1) {
                    throw new RegistryResolutionException(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e));
                }
            }
        } else {
            resolver = MavenRegistryClientFactory.newResolver(this.originalResolver, this.originalResolver.getRepositories(), config, this.log);
            try {
                result = MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(resolver, registryDescriptorCoords, cleanupTimestampedArtifacts);
            }
            catch (BootstrapMavenException e) {
                throw new RegistryResolutionException(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e));
            }
        }
        String srcRepoId = result.getRepository() == null ? "n/a" : result.getRepository().getId();
        this.log.debug("Resolved registry descriptor %s from %s", new Object[]{registryDescriptorCoords, srcRepoId});
        if (!registryRepos.isEmpty()) {
            if (srcRepoId != null && !"local".equals(srcRepoId)) {
                String srcRepoUrl = null;
                for (RemoteRepository repo : resolver.getRepositories()) {
                    if (!repo.getId().equals(srcRepoId)) continue;
                    srcRepoUrl = repo.getUrl();
                    break;
                }
                if (srcRepoUrl == null) {
                    throw new IllegalStateException("Failed to locate the repository URL corresponding to repository " + srcRepoId);
                }
            } else {
                this.log.debug("Failed to determine the remote repository for %s registry descriptor %s", new Object[]{config.getId(), registryDescriptorCoords});
            }
        }
        try {
            descriptor = RegistryConfig.mutableFromFile(result.getArtifact().getFile().toPath());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize registries descriptor " + String.valueOf(result.getArtifact().getFile()), e);
        }
        if (!MavenRegistryClientFactory.isComplete(config, descriptor)) {
            config = MavenRegistryClientFactory.completeRegistryConfig(config, descriptor);
        }
        MavenRegistryArtifactResolver registryArtifactResolver = MavenRegistryClientFactory.newRegistryArtifactResolver(resolver, cleanupTimestampedArtifacts);
        return new RegistryClientDispatcher(config, this.getPlatformsResolver(config, registryArtifactResolver), this.getPlatformExtensionsResolver(config, registryArtifactResolver, cleanupTimestampedArtifacts), this.getNonPlatformExtensionsResolver(config, registryArtifactResolver), new MavenRegistryCache(config, registryArtifactResolver, this.log));
    }

    private List<RemoteRepository> applyMirrorsAndProxies(List<RemoteRepository> registryRepos) {
        return this.originalResolver.getRemoteRepositoryManager().aggregateRepositories(this.originalResolver.getSession(), List.of(), registryRepos, true);
    }

    private MavenPlatformExtensionsResolver getPlatformExtensionsResolver(RegistryConfig config, MavenRegistryArtifactResolver registryArtifactResolver, boolean cleanupTimestampedArtifacts) {
        RegistryMavenRepoConfig repoConfig;
        RegistryPlatformsConfig platformsConfig = config.getPlatforms();
        if (platformsConfig != null && platformsConfig.getExtensionCatalogsIncluded() != null && platformsConfig.getExtensionCatalogsIncluded().booleanValue()) {
            return new MavenPlatformExtensionsResolver(registryArtifactResolver, this.log);
        }
        RegistryMavenRepoConfig registryMavenRepoConfig = platformsConfig == null ? null : (platformsConfig.getMaven() == null ? null : (repoConfig = platformsConfig.getMaven().getRepository() == null ? null : platformsConfig.getMaven().getRepository()));
        if (repoConfig != null) {
            List<RemoteRepository> resolverRepos = this.applyMirrorsAndProxies(List.of(new RemoteRepository.Builder(repoConfig.getId(), "default", repoConfig.getUrl()).build()));
            return new MavenPlatformExtensionsResolver(MavenRegistryClientFactory.newRegistryArtifactResolver(MavenRegistryClientFactory.newResolver(this.originalResolver, resolverRepos, config, this.log), cleanupTimestampedArtifacts), this.log);
        }
        return new MavenPlatformExtensionsResolver(MavenRegistryClientFactory.newRegistryArtifactResolver(this.originalResolver, cleanupTimestampedArtifacts), this.log);
    }

    private RegistryPlatformsResolver getPlatformsResolver(RegistryConfig config, MavenRegistryArtifactResolver registryArtifactResolver) {
        RegistryPlatformsConfig platformsConfig = config.getPlatforms();
        if (platformsConfig == null || platformsConfig.isDisabled()) {
            this.log.debug("Platform catalogs were disabled for registry %s", new Object[]{config.getId()});
            return null;
        }
        return new MavenPlatformsResolver(platformsConfig, registryArtifactResolver, this.log);
    }

    private RegistryNonPlatformExtensionsResolver getNonPlatformExtensionsResolver(RegistryConfig config, MavenRegistryArtifactResolver registryArtifactResolver) {
        RegistryNonPlatformExtensionsConfig nonPlatformExtensions = config.getNonPlatformExtensions();
        if (nonPlatformExtensions == null || nonPlatformExtensions.isDisabled()) {
            this.log.debug("Non-platform extension catalogs were disabled for registry %s", new Object[]{config.getId()});
            return null;
        }
        return new MavenNonPlatformExtensionsResolver(nonPlatformExtensions, registryArtifactResolver, this.log);
    }

    private static Artifact getDescriptorCoords(RegistryConfig config) {
        RegistryDescriptorConfig descriptorConfig = config.getDescriptor();
        if (descriptorConfig == null) {
            throw new IllegalArgumentException("The registry descriptor configuration is missing for " + config.getId());
        }
        ArtifactCoords originalDescrCoords = descriptorConfig.getArtifact();
        return new DefaultArtifact(originalDescrCoords.getGroupId(), originalDescrCoords.getArtifactId(), originalDescrCoords.getClassifier(), originalDescrCoords.getType(), originalDescrCoords.getVersion());
    }

    private static boolean isCleanupTimestampedArtifacts(RegistryConfig config) {
        Object o = config.getExtra().get(CLEANUP_TIMESTAMPED_ARTIFACTS);
        return o == null || Boolean.parseBoolean(o.toString());
    }

    private static MavenRegistryArtifactResolver newRegistryArtifactResolver(MavenArtifactResolver resolver, boolean cleanupTimestampedArtifacts) {
        return new MavenRegistryArtifactResolverWithCleanup(resolver, cleanupTimestampedArtifacts);
    }

    static RegistryConfig.Mutable completeRegistryConfig(RegistryConfig local, RegistryConfig remote) {
        RegistryConfig.Mutable complete = RegistryConfig.builder();
        complete.setId(local.getId() == null ? remote.getId() : local.getId());
        if (local.getDescriptor() == null) {
            complete.setDescriptor(remote.getDescriptor());
        } else {
            complete.setDescriptor(local.getDescriptor());
        }
        if (local.getPlatforms() == null) {
            complete.setPlatforms(remote.getPlatforms());
        } else {
            complete.setPlatforms(MavenRegistryClientFactory.completeRegistryPlatformConfig(local.getPlatforms(), remote.getPlatforms()));
        }
        if (local.getNonPlatformExtensions() == null) {
            complete.setNonPlatformExtensions(remote.getNonPlatformExtensions());
        } else {
            complete.setNonPlatformExtensions(local.getNonPlatformExtensions());
        }
        if (local.getUpdatePolicy() == null) {
            complete.setUpdatePolicy(remote.getUpdatePolicy());
        } else {
            complete.setUpdatePolicy(local.getUpdatePolicy());
        }
        if (local.getMaven() == null) {
            complete.setMaven(remote.getMaven());
        } else if (MavenRegistryClientFactory.isMavenConfigComplete(local.getMaven())) {
            complete.setMaven(local.getMaven());
        } else {
            complete.setMaven(RegistryMavenConfig.builder().setRepository(MavenRegistryClientFactory.completeMavenRepoConfig(local.getMaven().getRepository(), remote.getMaven().getRepository())));
        }
        complete.setQuarkusVersions(MavenRegistryClientFactory.complete(local.getQuarkusVersions(), remote.getQuarkusVersions()));
        if (local.getExtra().isEmpty()) {
            complete.setExtra(remote.getExtra());
        } else if (remote.getExtra().isEmpty()) {
            complete.setExtra(local.getExtra());
        } else {
            HashMap<String, Object> extra = new HashMap<String, Object>(remote.getExtra());
            extra.putAll(local.getExtra());
            complete.setExtra(extra);
        }
        return complete;
    }

    private static RegistryQuarkusVersionsConfig complete(RegistryQuarkusVersionsConfig local, RegistryQuarkusVersionsConfig remote) {
        if (local == null) {
            return remote;
        }
        if (remote == null || local.equals(remote)) {
            return local;
        }
        RegistryQuarkusVersionsConfig.Mutable complete = RegistryQuarkusVersionsConfig.builder();
        complete.setExclusiveProvider(local.isExclusiveProvider() || remote.isExclusiveProvider());
        complete.setRecognizedGroupIds(local.getRecognizedGroupIds().isEmpty() ? remote.getRecognizedGroupIds() : local.getRecognizedGroupIds());
        complete.setRecognizedVersionsExpression(local.getRecognizedVersionsExpression() == null ? remote.getRecognizedVersionsExpression() : local.getRecognizedVersionsExpression());
        return complete;
    }

    private static RegistryPlatformsConfig completeRegistryPlatformConfig(RegistryPlatformsConfig local, RegistryPlatformsConfig remote) {
        if (local == null) {
            return remote;
        }
        if (MavenRegistryClientFactory.isPlatformsConfigComplete(local, remote)) {
            return local;
        }
        Boolean extensionCatalogsIncluded = local.getExtensionCatalogsIncluded();
        RegistryMavenConfig mavenConfig = null;
        if (local.getMaven() != null && local.getMaven().getRepository() != null) {
            if (extensionCatalogsIncluded != null && extensionCatalogsIncluded.booleanValue()) {
                throw new IllegalArgumentException("Either extension-catalogs-included or mavenConfig/repository configuration can be enabled at the same time");
            }
            mavenConfig = local.getMaven();
        }
        if (mavenConfig == null) {
            if (!(extensionCatalogsIncluded != null && extensionCatalogsIncluded.booleanValue() || extensionCatalogsIncluded != null || (extensionCatalogsIncluded = remote.getExtensionCatalogsIncluded()) != null && extensionCatalogsIncluded.booleanValue())) {
                mavenConfig = remote.getMaven();
            }
        } else if (remote.getMaven() != null && !MavenRegistryClientFactory.isMavenConfigComplete(mavenConfig)) {
            mavenConfig = RegistryMavenConfig.builder().setRepository(MavenRegistryClientFactory.completeMavenRepoConfig(mavenConfig.getRepository(), remote.getMaven().getRepository()));
        }
        return RegistryPlatformsConfig.builder().setArtifact(local.getArtifact() == null ? remote.getArtifact() : local.getArtifact()).setDisabled(local.isDisabled()).setExtensionCatalogsIncluded(extensionCatalogsIncluded).setMaven(mavenConfig);
    }

    private static RegistryMavenRepoConfig completeMavenRepoConfig(RegistryMavenRepoConfig local, RegistryMavenRepoConfig remote) {
        if (local == null) {
            return remote;
        }
        if (MavenRegistryClientFactory.isMavenRepoComplete(local) || remote == null) {
            return local;
        }
        return RegistryMavenRepoConfig.builder().setId(local.getId() != null ? local.getId() : remote.getId()).setUrl(local.getUrl() != null ? local.getUrl() : remote.getUrl());
    }

    private static boolean isComplete(RegistryConfig client, RegistryConfig descriptor) {
        if (!client.isEnabled()) {
            return true;
        }
        if (client.getDescriptor() == null) {
            return false;
        }
        if (!MavenRegistryClientFactory.isPlatformsConfigComplete(client.getPlatforms(), descriptor.getPlatforms())) {
            return false;
        }
        if (!MavenRegistryClientFactory.isArtifactConfigComplete(client.getNonPlatformExtensions())) {
            return false;
        }
        if (!MavenRegistryClientFactory.isMavenConfigComplete(client.getMaven())) {
            return false;
        }
        if (client.getQuarkusVersions() == null && descriptor.getQuarkusVersions() != null) {
            return false;
        }
        return client.getUpdatePolicy() != null || descriptor.getUpdatePolicy() == null;
    }

    private static boolean isMavenConfigComplete(RegistryMavenConfig config) {
        return config != null && MavenRegistryClientFactory.isMavenRepoComplete(config.getRepository());
    }

    private static boolean isPlatformsConfigComplete(RegistryPlatformsConfig client, RegistryPlatformsConfig descriptor) {
        if (!MavenRegistryClientFactory.isArtifactConfigComplete(client)) {
            return false;
        }
        if (client.getMaven() != null && client.getMaven().getRepository() != null && client.getMaven().getRepository().getUrl() != null || client.getExtensionCatalogsIncluded() != null) {
            return true;
        }
        if (descriptor != null) {
            return !Boolean.TRUE.equals(descriptor.getExtensionCatalogsIncluded()) && descriptor.getMaven() == null;
        }
        return true;
    }

    private static boolean isArtifactConfigComplete(RegistryArtifactConfig config) {
        return config != null && (config.isDisabled() || config.getArtifact() != null);
    }

    private static boolean isMavenRepoComplete(RegistryMavenRepoConfig config) {
        return config != null && config.getId() != null && config.getUrl() != null;
    }

    private static MavenArtifactResolver newResolver(MavenArtifactResolver resolver, List<RemoteRepository> aggregatedRepos, RegistryConfig config, MessageWriter log) {
        try {
            LocalProject currentProject = resolver.getMavenContext().getCurrentProject();
            BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystem(resolver.getSystem()).setRepositorySystemSession((RepositorySystemSession)MavenRegistryClientFactory.setRegistryTransferListener(config, log, resolver.getSession())).setRemoteRepositoryManager(resolver.getRemoteRepositoryManager()).setRemoteRepositories(aggregatedRepos).setLocalRepository(resolver.getMavenContext().getLocalRepo()).setCurrentProject(currentProject).setWorkspaceDiscovery(currentProject != null));
            return new MavenArtifactResolver(mvnCtx);
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to initialize Maven context", e);
        }
    }

    private static DefaultRepositorySystemSession setRegistryTransferListener(RegistryConfig config, MessageWriter log, RepositorySystemSession session) {
        DefaultRepositorySystemSession newSession = new DefaultRepositorySystemSession(session);
        newSession.setTransferListener((TransferListener)new RegistryCacheRefreshLogger(config, log, newSession.getTransferListener()));
        return newSession;
    }

    private List<RemoteRepository> determineRegistryRepos(RegistryConfig config, List<RemoteRepository> configuredRepos) {
        String repoUrl;
        RegistryMavenConfig mavenConfig = config.getMaven() == null ? null : config.getMaven();
        RegistryMavenRepoConfig repoConfig = mavenConfig == null ? null : mavenConfig.getRepository();
        String repoId = repoConfig == null || repoConfig.getId() == null ? config.getId() : repoConfig.getId();
        String string = repoUrl = repoConfig == null ? null : repoConfig.getUrl();
        if (repoUrl == null || repoUrl.isBlank()) {
            for (RemoteRepository r : configuredRepos) {
                if (!r.getId().equals(repoId)) continue;
                return Collections.emptyList();
            }
            try {
                repoUrl = new URL("https", config.getId(), "/maven").toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to derive the Maven repository URL for registry " + config.getId(), e);
            }
        } else {
            for (RemoteRepository repo : configuredRepos) {
                if (!repo.getUrl().equals(repoUrl)) continue;
                return Collections.emptyList();
            }
        }
        RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repoId, "default", repoUrl);
        String updatePolicy = config.getUpdatePolicy();
        if (updatePolicy != null) {
            if (updatePolicy.equalsIgnoreCase("daily") || updatePolicy.equalsIgnoreCase("always") || updatePolicy.equalsIgnoreCase("never") || updatePolicy.startsWith("interval")) {
                repoBuilder.setPolicy(new RepositoryPolicy(true, updatePolicy, "warn"));
            } else {
                throw new IllegalStateException("Unrecognized update policy '" + updatePolicy + "' for repository " + repoId);
            }
        }
        return List.of(repoBuilder.build());
    }

    private static String getDescriptorResolutionFailureFromMirrorMessage(RegistryConfig config, MavenArtifactResolver resolver, BootstrapMavenException e, List<RemoteRepository> originalRegistryRepos) {
        StringBuilder buf = new StringBuilder();
        buf.append(MavenRegistryClientFactory.getDescriptorResolutionFailureMessage(config, resolver, e));
        buf.append(" having applied the mirrors and/or proxies from the Maven settings to ");
        MavenRegistryClientFactory.appendRepoInfo(buf, originalRegistryRepos.get(0));
        for (int i = 1; i < originalRegistryRepos.size(); ++i) {
            buf.append(", ");
            MavenRegistryClientFactory.appendRepoInfo(buf, originalRegistryRepos.get(i));
        }
        buf.append(". Re-trying with the original ").append(config.getId()).append(" repository configuration.");
        return buf.toString();
    }

    private static String getDescriptorResolutionFailureMessage(RegistryConfig config, MavenArtifactResolver resolver, BootstrapMavenException e) {
        StringWriter buf = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(buf);){
            writer.write("Failed to resolve the Quarkus extension registry descriptor of ");
            writer.write(config.getId());
            writer.write(" from ");
            List repos = resolver.getRepositories();
            MavenRegistryClientFactory.appendRepoInfo(writer, (RemoteRepository)repos.get(0));
            for (int i = 1; i < repos.size(); ++i) {
                writer.append(", ");
                MavenRegistryClientFactory.appendRepoInfo(writer, (RemoteRepository)repos.get(i));
            }
        }
        catch (IOException e1) {
            buf.append(e.getLocalizedMessage());
        }
        return buf.toString();
    }

    private static void appendRepoInfo(Appendable writer, RemoteRepository repo) {
        try {
            writer.append(repo.getId());
            writer.append(" (");
            writer.append(repo.getUrl());
            writer.append(")");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compose an error message", e);
        }
    }

    private static boolean areMatching(List<RemoteRepository> registryRepos, List<RemoteRepository> aggregatedRepos) {
        if (registryRepos.size() != aggregatedRepos.size()) {
            return false;
        }
        for (int i = 0; i < registryRepos.size(); ++i) {
            RemoteRepository original = registryRepos.get(i);
            RemoteRepository aggregated = aggregatedRepos.get(i);
            if (original.getId().equals(aggregated.getId()) && original.getUrl().equals(aggregated.getUrl())) continue;
            return false;
        }
        return true;
    }
}

