/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.json.JsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIdentityInfo(property="id", generator=ObjectIdGenerators.PropertyGenerator.class, scope=ExtensionOrigin.class)
public class ExtensionOriginImpl
implements ExtensionOrigin {
    protected final String id;
    protected final boolean platform;
    protected final ArtifactCoords bom;
    protected final Map<String, Object> metadata;

    protected ExtensionOriginImpl(String id) {
        this.id = id;
        this.platform = false;
        this.bom = null;
        this.metadata = Collections.emptyMap();
    }

    protected ExtensionOriginImpl(Builder builder) {
        this.id = builder.id;
        this.platform = builder.platform;
        this.bom = builder.bom;
        this.metadata = JsonBuilder.toUnmodifiableMap(builder.metadata);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ArtifactCoords getBom() {
        return this.bom;
    }

    @Override
    public boolean isPlatform() {
        return this.platform;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        return ExtensionOriginImpl.originEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return ExtensionOriginImpl.originToString(this);
    }

    static final boolean originEquals(ExtensionOrigin o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (!(o2 instanceof ExtensionOrigin)) {
            return false;
        }
        ExtensionOrigin origin = (ExtensionOrigin)o2;
        return Objects.equals(o1.getId(), origin.getId());
    }

    static final String originToString(ExtensionOrigin o1) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (o1.getId() != null) {
            buf.append("id=").append(o1.getId()).append(", ");
        }
        buf.append("platform=").append(o1.isPlatform());
        buf.append(", boms=").append(o1.getBom());
        return buf.append(']').toString();
    }

    @JsonIdentityInfo(property="id", generator=ObjectIdGenerators.PropertyGenerator.class, scope=ExtensionOrigin.class)
    public static class Builder
    implements ExtensionOrigin.Mutable {
        protected String id;
        protected boolean platform;
        protected ArtifactCoords bom;
        private Map<String, Object> metadata;

        public Builder() {
        }

        Builder(ExtensionOrigin source) {
            this.id = source.getId();
            this.platform = source.isPlatform();
            this.bom = source.getBom();
            this.setMetadata((Map)source.getMetadata());
        }

        public Builder(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        @Override
        public ArtifactCoords getBom() {
            return this.bom;
        }

        @Override
        public Builder setBom(ArtifactCoords bom) {
            this.bom = bom;
            return this;
        }

        @Override
        public boolean isPlatform() {
            return this.platform;
        }

        @Override
        public Builder setPlatform(boolean platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public Map<String, Object> getMetadata() {
            return this.metadata == null ? (this.metadata = new HashMap<String, Object>()) : this.metadata;
        }

        @Override
        public Builder setMetadata(Map<String, Object> newValues) {
            this.metadata = JsonBuilder.modifiableMapOrNull(newValues, HashMap::new);
            return this;
        }

        @Override
        @JsonIgnore
        public Builder setMetadata(String key, Object value) {
            this.getMetadata().put(key, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            this.getMetadata().remove(key);
            return this;
        }

        @Override
        public ExtensionOriginImpl build() {
            return new ExtensionOriginImpl(this);
        }

        public boolean equals(Object o) {
            return ExtensionOriginImpl.originEquals(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return ExtensionOriginImpl.originToString(this);
        }
    }
}

