/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.appstate;

import io.quarkus.dev.appstate.ApplicationStartException;

public class ApplicationStateNotification {
    private static State state = State.INITIAL;
    private static Throwable startupProblem;

    public static synchronized void reset() {
        if (state == State.STARTED) {
            throw new IllegalStateException("Cannot reset a started application");
        }
        state = State.INITIAL;
        startupProblem = null;
    }

    public static synchronized void notifyStartupComplete() {
        state = State.STARTED;
        ApplicationStateNotification.class.notifyAll();
    }

    public static synchronized void notifyApplicationStopped() {
        state = State.STOPPED;
        ApplicationStateNotification.class.notifyAll();
    }

    public static synchronized void notifyStartupFailed(Throwable t) {
        startupProblem = t;
        state = State.STOPPED;
        ApplicationStateNotification.class.notifyAll();
    }

    public static synchronized void waitForApplicationStart() {
        while (state == State.INITIAL) {
            try {
                ApplicationStateNotification.class.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (startupProblem != null) {
            Throwable localStartupProblem = startupProblem;
            startupProblem = null;
            throw new ApplicationStartException(localStartupProblem);
        }
    }

    public static synchronized void waitForApplicationStop() {
        while (state != State.STOPPED) {
            try {
                ApplicationStateNotification.class.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static State getState() {
        return state;
    }

    public static enum State {
        INITIAL,
        STARTED,
        STOPPED;

    }
}

