/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.jvm;

import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.builditem.ModuleEnableNativeAccessBuildItem;
import io.quarkus.deployment.builditem.ModuleOpenBuildItem;
import io.quarkus.deployment.jvm.JvmModulesReconfigurer;
import io.quarkus.deployment.jvm.ModulesClassloaderContext;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.Attributes;
import org.jboss.logging.Logger;

public final class ResolvedJVMRequirements
extends SimpleBuildItem {
    private static final Attributes.Name ADD_OPENS_JARATTRIBUTENAME = new Attributes.Name("Add-Opens");
    private static final Attributes.Name ENABLE_NATIVE_JARATTRIBUTENAME = new Attributes.Name("Enable-Native-Access");
    private final List<ModuleOpenBuildItem> addOpens;
    private final List<ModuleEnableNativeAccessBuildItem> enableNativeAccesses;

    public ResolvedJVMRequirements(List<ModuleOpenBuildItem> addOpens, List<ModuleEnableNativeAccessBuildItem> enableNativeAccesses) throws BuildException {
        this.addOpens = addOpens;
        this.enableNativeAccesses = enableNativeAccesses;
    }

    public void renderAddOpensElementToJarManifest(Attributes attributes) {
        TreeSet<CallSite> modulesToAddOpens = new TreeSet<CallSite>();
        for (ModuleOpenBuildItem moduleOpenBuildItem : this.addOpens) {
            for (String packageName : moduleOpenBuildItem.packageNames()) {
                modulesToAddOpens.add((CallSite)((Object)(moduleOpenBuildItem.openedModuleName() + "/" + packageName)));
            }
        }
        if (!modulesToAddOpens.isEmpty()) {
            if (attributes.getValue(ADD_OPENS_JARATTRIBUTENAME) != null) {
                Logger.getLogger(ResolvedJVMRequirements.class).warn((Object)"An 'Add-Opens' entry was already defined in your MANIFEST.MF or using the property quarkus.package.jar.manifest.attributes.\"Add-Opens\". Quarkus has overwritten this existing entry.");
            }
            attributes.put(ADD_OPENS_JARATTRIBUTENAME, String.join((CharSequence)" ", modulesToAddOpens));
        }
        if (!this.enableNativeAccesses.isEmpty()) {
            attributes.put(ENABLE_NATIVE_JARATTRIBUTENAME, "ALL-UNNAMED");
        }
    }

    public void applyJavaModuleConfigurationToRuntime(JvmModulesReconfigurer reconfigurer, ClassLoader referenceClassloader) {
        if (this.addOpens.isEmpty()) {
            return;
        }
        ModulesClassloaderContext context = new ModulesClassloaderContext(referenceClassloader);
        reconfigurer.openJavaModules(this.addOpens, context);
    }
}

