/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.ErrorReplacingProcessReader;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.smallrye.common.process.ProcessBuilder;
import io.smallrye.common.process.ProcessUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public abstract class NativeImageBuildRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildRunner.class);
    private static GraalVM.Version graalVMVersion = null;

    public GraalVM.Version getGraalVMVersion() {
        if (graalVMVersion == null) {
            String[] versionCommand = this.getGraalVMVersionCommand(List.of("--version"));
            try {
                graalVMVersion = (GraalVM.Version)((Object)ProcessBuilder.newBuilder((String)versionCommand[0]).arguments(Arrays.copyOfRange(versionCommand, 1, versionCommand.length)).error().redirect().output().processWith(br -> GraalVM.Version.of(br.lines())).run());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get GraalVM version", e);
            }
        }
        return graalVMVersion;
    }

    public abstract boolean isContainer();

    public void setup(boolean processInheritIODisabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(List<String> args, String nativeImageName, String resultingExecutableName, Path outputDir, GraalVM.Version graalVMVersion, boolean debugSymbolsEnabled, boolean processInheritIODisabled) throws InterruptedException, IOException {
        this.preBuild(outputDir, args);
        try {
            CharSequence[] buildCommand = this.getBuildCommand(outputDir, args);
            log.info((Object)String.join((CharSequence)" ", buildCommand).replace("$", "\\$"));
            ProcessBuilder pb = ProcessBuilder.newBuilder((String)buildCommand[0]).arguments((String[])Arrays.copyOfRange(buildCommand, 1, buildCommand.length)).directory(outputDir);
            pb.whileRunning(ph -> {
                if (!ph.isAlive()) {
                    return;
                }
                Thread hook = new Thread(() -> {
                    if (ph.supportsNormalTermination()) {
                        ph.destroy();
                    }
                    ph.waitUninterruptiblyFor(10L, TimeUnit.SECONDS);
                    ProcessUtil.destroyAllForcibly((ProcessHandle)ph);
                }, "GraalVM terminator");
                Runtime.getRuntime().addShutdownHook(hook);
                try {
                    ph.waitUninterruptiblyFor();
                }
                finally {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
            });
            pb.output().consumeLinesWith(8192, System.out::println);
            pb.error().logOnSuccess(false).consumeWith(br -> new ErrorReplacingProcessReader((BufferedReader)br, outputDir.resolve("reports").toFile()).run());
            pb.run();
            boolean objcopyExists = this.objcopyExists();
            if (!debugSymbolsEnabled) {
                if (objcopyExists) {
                    this.objcopy(outputDir, "--strip-debug", resultingExecutableName);
                } else if (SystemUtils.IS_OS_LINUX) {
                    log.warn((Object)"objcopy executable not found in PATH. Debug symbols will therefore not be separated from the executable.");
                    log.warn((Object)"That also means that resulting native executable is larger as it embeds the debug symbols.");
                }
            }
        }
        finally {
            this.postBuild(outputDir, nativeImageName, resultingExecutableName);
        }
    }

    protected abstract String[] getGraalVMVersionCommand(List<String> var1);

    protected abstract String[] getBuildCommand(Path var1, List<String> var2);

    protected boolean objcopyExists() {
        return true;
    }

    protected abstract void objcopy(Path var1, String ... var2);

    protected void preBuild(Path outputDir, List<String> buildArgs) throws IOException, InterruptedException {
    }

    protected void postBuild(Path outputDir, String nativeImageName, String resultingExecutableName) throws InterruptedException, IOException {
    }

    static void runCommand(String[] command, String errorMsg, File workingDirectory) {
        log.info((Object)String.join((CharSequence)" ", command).replace("$", "\\$"));
        try {
            ProcessBuilder pb = ProcessBuilder.newBuilder((String)command[0]).arguments(Arrays.copyOfRange(command, 1, command.length));
            if (workingDirectory != null) {
                pb.directory(workingDirectory.toPath());
            }
            pb.error().logOnSuccess(false);
            pb.run();
        }
        catch (Exception e) {
            if (errorMsg != null) {
                log.errorf((Throwable)e, errorMsg, new Object[0]);
            }
            log.debugf((Throwable)e, "Command: " + String.join((CharSequence)" ", command) + " failed.", new Object[0]);
        }
    }

    static void runCommand(String[] command, String errorMsg) {
        NativeImageBuildRunner.runCommand(command, errorMsg, null);
    }

    static class Result {
        private final int exitCode;

        public Result(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

