/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.internal.UncheckedException;
import org.gradle.util.GradleVersion;

public class DistributionLocator {
    private static final String RELEASE_REPOSITORY = "https://services.gradle.org/distributions";
    private static final String SNAPSHOT_REPOSITORY = "https://services.gradle.org/distributions-snapshots";

    public URI getDistributionFor(GradleVersion version) {
        return this.getDistributionFor(version, "bin");
    }

    public URI getDistributionFor(GradleVersion version, String type) {
        return this.getDistribution(this.getDistributionRepository(version), version, "gradle", type);
    }

    private String getDistributionRepository(GradleVersion version) {
        if (version.isSnapshot()) {
            return SNAPSHOT_REPOSITORY;
        }
        return RELEASE_REPOSITORY;
    }

    private URI getDistribution(String repositoryUrl, GradleVersion version, String archiveName, String archiveClassifier) {
        try {
            return new URI(repositoryUrl + "/" + archiveName + "-" + version.getVersion() + "-" + archiveClassifier + ".zip");
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

