/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.model.Mappable;
import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.paths.EmptyPathTree;
import io.quarkus.paths.MultiRootPathTree;
import io.quarkus.paths.PathTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface ArtifactSources
extends Mappable {
    public static final String MAIN = "";
    public static final String TEST = "tests";

    public static ArtifactSources main(SourceDir sources, SourceDir resources) {
        return new DefaultArtifactSources(MAIN, List.of(sources), List.of(resources));
    }

    public static ArtifactSources test(SourceDir sources, SourceDir resources) {
        return new DefaultArtifactSources(TEST, List.of(sources), List.of(resources));
    }

    public String getClassifier();

    public Collection<SourceDir> getSourceDirs();

    public Collection<SourceDir> getResourceDirs();

    default public boolean isOutputAvailable() {
        for (SourceDir src : this.getSourceDirs()) {
            if (!src.isOutputAvailable()) continue;
            return true;
        }
        for (SourceDir src : this.getResourceDirs()) {
            if (!src.isOutputAvailable()) continue;
            return true;
        }
        return false;
    }

    default public PathTree getOutputTree() {
        PathTree outputTree;
        Collection<SourceDir> sourceDirs = this.getSourceDirs();
        Collection<SourceDir> resourceDirs = this.getResourceDirs();
        ArrayList<PathTree> trees = new ArrayList<PathTree>(sourceDirs.size() + resourceDirs.size());
        for (SourceDir src : sourceDirs) {
            outputTree = src.getOutputTree();
            if (outputTree == null || outputTree.isEmpty() || trees.contains(outputTree)) continue;
            trees.add(outputTree);
        }
        for (SourceDir src : resourceDirs) {
            outputTree = src.getOutputTree();
            if (outputTree == null || outputTree.isEmpty() || trees.contains(outputTree)) continue;
            trees.add(outputTree);
        }
        if (trees.isEmpty()) {
            return EmptyPathTree.getInstance();
        }
        if (trees.size() == 1) {
            return (PathTree)trees.get(0);
        }
        return new MultiRootPathTree(trees.toArray(new PathTree[0]));
    }

    @Override
    default public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Collection<SourceDir> resources;
        Map<String, Object> map = factory.newMap(3);
        map.put("classifier", this.getClassifier());
        Collection<SourceDir> sources = this.getSourceDirs();
        if (!sources.isEmpty()) {
            map.put("sources", Mappable.asMaps(sources, factory));
        }
        if (!(resources = this.getResourceDirs()).isEmpty()) {
            map.put("resources", Mappable.asMaps(resources, factory));
        }
        return map;
    }
}

