/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.ArtifactKey;
import java.io.Serializable;
import java.util.Objects;

public class GACT
implements ArtifactKey,
Serializable {
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;

    public static GACT fromString(String str) {
        return new GACT(GACT.split(str, new String[4], str.length()));
    }

    protected static String[] split(String str, String[] parts, int fromIndex) {
        int i = str.lastIndexOf(58, fromIndex - 1);
        if (i <= 0) {
            throw new IllegalArgumentException("GroupId and artifactId separating ':' is absent or not in the right place in '" + str.substring(0, fromIndex) + "'");
        }
        parts[3] = str.substring(i + 1, fromIndex);
        fromIndex = i;
        if ((i = str.lastIndexOf(58, fromIndex - 1)) < 0) {
            parts[0] = str.substring(0, fromIndex);
            parts[1] = parts[3];
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("ArtifactId is empty in `" + str + "`");
            }
            parts[2] = "";
            parts[3] = null;
            return parts;
        }
        if (i == 0) {
            throw new IllegalArgumentException("One of groupId or artifactId is missing from '" + str.substring(0, fromIndex) + "'");
        }
        parts[2] = i == fromIndex - 1 ? "" : str.substring(i + 1, fromIndex);
        fromIndex = i;
        if ((i = str.lastIndexOf(58, fromIndex - 1)) < 0) {
            parts[0] = str.substring(0, fromIndex);
            parts[1] = parts[2];
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("ArtifactId is empty in `" + str + "`");
            }
            parts[2] = parts[3];
            parts[3] = null;
            return parts;
        }
        if (i == 0 || i == fromIndex - 1) {
            throw new IllegalArgumentException("One of groupId or artifactId is missing from '" + str.substring(0, fromIndex) + "'");
        }
        parts[0] = str.substring(0, i);
        parts[1] = str.substring(i + 1, fromIndex);
        if (parts[3].isEmpty()) {
            parts[3] = null;
        }
        return parts;
    }

    public GACT(String[] parts) {
        if (parts == null || parts.length < 2 || parts.length > 4) {
            StringBuilder sb = new StringBuilder().append("Artifact key ");
            if (parts == null) {
                sb.append("null");
            } else {
                sb.append('\'');
                if (parts.length > 0) {
                    sb.append(parts[0]);
                    for (int i = 1; i < parts.length; ++i) {
                        sb.append(':').append(parts[i]);
                    }
                }
                sb.append('\'');
            }
            throw new IllegalArgumentException(sb.append(" does not follow format <groupId>:<artifactId>[:<classifier>[:<type>]]").toString());
        }
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts.length == 2 || parts[2] == null ? "" : parts[2];
        this.type = parts.length <= 3 || parts[3] == null ? "jar" : parts[3];
    }

    public GACT(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public GACT(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, null);
    }

    public GACT(String groupId, String artifactId, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.classifier, this.groupId, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey other = (ArtifactKey)obj;
        return Objects.equals(this.artifactId, other.getArtifactId()) && Objects.equals(this.classifier, other.getClassifier()) && Objects.equals(this.groupId, other.getGroupId()) && Objects.equals(this.type, other.getType());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        } else if (this.type != null) {
            buf.append(':');
        }
        if (this.type != null) {
            buf.append(':').append(this.type);
        }
        return buf.toString();
    }
}

