/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSourceSupport;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesExcludedFromHealthChecks;
import io.quarkus.datasource.runtime.DataSourcesRuntimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;

@Recorder
public class AgroalRecorder {
    public Supplier<DataSourceSupport> dataSourceSupportSupplier(final DataSourceSupport dataSourceSupport) {
        return new Supplier<DataSourceSupport>(){

            @Override
            public DataSourceSupport get() {
                return dataSourceSupport;
            }
        };
    }

    public Supplier<AgroalDataSource> agroalDataSourceSupplier(String dataSourceName, DataSourcesRuntimeConfig dataSourcesRuntimeConfig) {
        final AgroalDataSource agroalDataSource = DataSources.fromName(dataSourceName);
        return new Supplier<AgroalDataSource>(){

            @Override
            public AgroalDataSource get() {
                return agroalDataSource;
            }
        };
    }

    public Supplier<DataSourcesExcludedFromHealthChecks> dataSourcesExcludedFromHealthChecks(final DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) {
        return new Supplier<DataSourcesExcludedFromHealthChecks>(){

            @Override
            public DataSourcesExcludedFromHealthChecks get() {
                ArrayList<String> excludedNames = new ArrayList<String>();
                if (dataSourcesBuildTimeConfig.defaultDataSource.healthExclude) {
                    excludedNames.add("<default>");
                }
                for (Map.Entry dataSource : dataSourcesBuildTimeConfig.namedDataSources.entrySet()) {
                    if (!((DataSourceBuildTimeConfig)dataSource.getValue()).healthExclude) continue;
                    excludedNames.add((String)dataSource.getKey());
                }
                return new DataSourcesExcludedFromHealthChecks(excludedNames);
            }
        };
    }
}

