/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.GenericTyped;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TypeParameter
implements GenericTyped {
    private final String name;
    private final Optional<GenericType.OfThrows> firstBound;
    private final List<GenericType.OfThrows> otherBounds;
    private final List<Annotation> visible;
    private final List<Annotation> invisible;
    GenericType.OfTypeVariable genericType;

    TypeParameter(List<Annotation> visible, List<Annotation> invisible, String name, Optional<GenericType.OfThrows> firstBound, List<GenericType.OfThrows> otherBounds) {
        this.name = name;
        this.firstBound = firstBound;
        this.otherBounds = List.copyOf(otherBounds);
        this.visible = visible;
        this.invisible = invisible;
    }

    public Optional<GenericType.OfThrows> firstBound() {
        return this.firstBound;
    }

    public List<GenericType.OfThrows> otherBounds() {
        return this.otherBounds;
    }

    public String name() {
        return this.name;
    }

    @Override
    public GenericType.OfTypeVariable genericType() {
        GenericType.OfTypeVariable genericType = this.genericType;
        if (genericType != null) {
            return genericType;
        }
        this.genericType = GenericType.ofTypeVariable(this.name(), this.type());
        return this.genericType;
    }

    @Override
    public boolean hasGenericType() {
        return true;
    }

    @Override
    public ClassDesc type() {
        return this.erasure();
    }

    public abstract boolean visibleIn(ClassDesc var1);

    public abstract boolean visibleIn(MethodDesc var1);

    public abstract boolean visibleIn(ConstructorDesc var1);

    public final boolean equals(Object obj) {
        TypeParameter tp;
        return obj instanceof TypeParameter && this.equals(tp = (TypeParameter)obj);
    }

    public boolean equals(TypeParameter other) {
        return other != null && this.name.equals(other.name) && this.firstBound.equals(other.firstBound) && this.otherBounds.equals(other.otherBounds) && this.visible.equals(other.visible) && this.invisible.equals(other.invisible);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name, this.firstBound, this.otherBounds, this.visible, this.invisible);
    }

    public String toString() {
        return this.name();
    }

    public ClassDesc erasure() {
        return this.firstBound.map(GenericType::desc).orElseGet(() -> this.otherBounds.stream().map(GenericType::desc).findFirst().orElse(ConstantDescs.CD_Object));
    }

    List<TypeAnnotation> computeAnnotations(RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
        List<TypeAnnotation.TypePathComponent> pathSnapshot = List.copyOf(path);
        for (Annotation annotation : switch (retention) {
            case RetentionPolicy.RUNTIME -> this.visible;
            case RetentionPolicy.CLASS -> this.invisible;
            default -> throw Assert.impossibleSwitchCase((Object)((Object)retention));
        }) {
            list.add(TypeAnnotation.of((TypeAnnotation.TargetInfo)targetInfo, pathSnapshot, (Annotation)annotation));
        }
        if (this.firstBound.isPresent() || !this.otherBounds.isEmpty()) {
            IntFunction<TypeAnnotation.TargetInfo> intFunction;
            if (targetInfo instanceof TypeAnnotation.TypeParameterTarget) {
                TypeAnnotation.TypeParameterTarget tpt = (TypeAnnotation.TypeParameterTarget)targetInfo;
                switch (targetInfo.targetType()) {
                    case METHOD_TYPE_PARAMETER: {
                        intFunction = idx -> TypeAnnotation.TargetInfo.ofMethodTypeParameterBound((int)tpt.typeParameterIndex(), (int)idx);
                        break;
                    }
                    case CLASS_TYPE_PARAMETER: {
                        intFunction = idx -> TypeAnnotation.TargetInfo.ofClassTypeParameterBound((int)tpt.typeParameterIndex(), (int)idx);
                        break;
                    }
                    default: {
                        throw Assert.impossibleSwitchCase((Object)targetInfo.targetType());
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            IntFunction<TypeAnnotation.TargetInfo> targetFn = intFunction;
            this.firstBound.ifPresent(b -> b.computeAnnotations(retention, (TypeAnnotation.TargetInfo)targetFn.apply(0), list, path));
            for (int i = 0; i < this.otherBounds.size(); ++i) {
                this.otherBounds.get(i).computeAnnotations(retention, targetFn.apply(i + 1), list, path);
            }
        }
        return list;
    }

    public static final class OfConstructor
    extends TypeParameter {
        private final ConstructorDesc owner;

        OfConstructor(List<Annotation> visible, List<Annotation> invisible, String name, Optional<GenericType.OfThrows> firstBound, List<GenericType.OfThrows> otherBounds, ConstructorDesc owner) {
            super(visible, invisible, name, firstBound, otherBounds);
            this.owner = owner;
        }

        public ConstructorDesc owner() {
            return this.owner;
        }

        @Override
        public boolean visibleIn(ClassDesc desc) {
            return false;
        }

        @Override
        public boolean visibleIn(MethodDesc desc) {
            return false;
        }

        @Override
        public boolean visibleIn(ConstructorDesc desc) {
            return desc.equals(this.owner);
        }

        @Override
        public boolean equals(TypeParameter other) {
            OfConstructor oc;
            return other instanceof OfConstructor && this.equals(oc = (OfConstructor)other);
        }

        public boolean equals(OfConstructor other) {
            return this == other || super.equals(other) && this.owner.equals(other.owner);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.owner.hashCode();
        }
    }

    public static final class OfMethod
    extends TypeParameter {
        private final MethodDesc owner;

        OfMethod(List<Annotation> visible, List<Annotation> invisible, String name, Optional<GenericType.OfThrows> firstBound, List<GenericType.OfThrows> otherBounds, MethodDesc owner) {
            super(visible, invisible, name, firstBound, otherBounds);
            this.owner = owner;
        }

        public MethodDesc owner() {
            return this.owner;
        }

        @Override
        public boolean visibleIn(ClassDesc desc) {
            return false;
        }

        @Override
        public boolean visibleIn(MethodDesc desc) {
            return desc.equals(this.owner);
        }

        @Override
        public boolean visibleIn(ConstructorDesc desc) {
            return false;
        }

        @Override
        public boolean equals(TypeParameter other) {
            OfMethod om;
            return other instanceof OfMethod && this.equals(om = (OfMethod)other);
        }

        public boolean equals(OfMethod other) {
            return this == other || super.equals(other) && this.owner.equals(other.owner);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.owner.hashCode();
        }
    }

    public static final class OfType
    extends TypeParameter {
        private final ClassDesc owner;

        OfType(List<Annotation> visible, List<Annotation> invisible, String name, Optional<GenericType.OfThrows> firstBound, List<GenericType.OfThrows> otherBounds, ClassDesc owner) {
            super(visible, invisible, name, firstBound, otherBounds);
            this.owner = owner;
        }

        public ClassDesc owner() {
            return this.owner;
        }

        @Override
        public boolean visibleIn(ClassDesc desc) {
            return Util.equals(this.owner, desc);
        }

        @Override
        public boolean visibleIn(MethodDesc desc) {
            return this.visibleIn(desc.owner());
        }

        @Override
        public boolean visibleIn(ConstructorDesc desc) {
            return this.visibleIn(desc.owner());
        }

        @Override
        public boolean equals(TypeParameter other) {
            OfType ot;
            return other instanceof OfType && this.equals(ot = (OfType)other);
        }

        public boolean equals(OfType other) {
            return this == other || super.equals(other) && Util.equals(this.owner, other.owner);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.owner.hashCode();
        }
    }
}

