/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.GenericTypes;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.impl.ArrayDeref;
import io.quarkus.gizmo2.impl.ArrayLength;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.BoundItem;
import io.quarkus.gizmo2.impl.FieldDeref;
import io.quarkus.gizmo2.impl.Nop;
import io.quarkus.gizmo2.impl.Pop;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.function.BiConsumer;

public abstract class Item
implements Expr {
    protected final String creationSite = Util.trackCaller();
    private ClassDesc type;
    private GenericType genericType;

    protected Item() {
    }

    protected Item(ClassDesc type) {
        this.type = type;
    }

    protected Item(GenericType genericType) {
        this.genericType = genericType;
    }

    protected Item(ClassDesc type, GenericType genericType) {
        this.type = type;
        this.genericType = genericType;
    }

    public String itemName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final ClassDesc type() {
        ClassDesc type = this.type;
        if (type != null) {
            return type;
        }
        GenericType genericType = this.genericType;
        if (genericType != null) {
            this.type = genericType.desc();
            return this.type;
        }
        this.computeType();
        type = this.type;
        if (type != null) {
            return type;
        }
        genericType = this.genericType;
        if (genericType != null) {
            this.type = genericType.desc();
            return this.type;
        }
        throw new IllegalStateException("Type not computed");
    }

    protected final void initType(ClassDesc type) {
        this.type = type;
    }

    protected final void initGenericType(GenericType genericType) {
        this.genericType = genericType;
    }

    @Override
    public final GenericType genericType() {
        GenericType genericType = this.genericType;
        if (genericType != null) {
            return genericType;
        }
        ClassDesc type = this.type;
        if (type != null) {
            this.genericType = GenericType.of(type);
            return this.genericType;
        }
        this.computeType();
        genericType = this.genericType;
        if (genericType != null) {
            return genericType;
        }
        type = this.type;
        if (type != null) {
            this.genericType = GenericType.of(type);
            return this.genericType;
        }
        throw new IllegalStateException("Type not computed");
    }

    @Override
    public final boolean hasGenericType() {
        GenericType genericType = this.genericType;
        if (genericType != null) {
            return true;
        }
        if (this.type != null) {
            return false;
        }
        this.computeType();
        return this.genericType != null;
    }

    protected void computeType() {
        this.initType(ConstantDescs.CD_void);
        this.initGenericType(GenericTypes.GT_void);
    }

    public boolean bound() {
        return true;
    }

    void verify(ListIterator<Item> itr) {
        while (itr.hasPrevious()) {
            Item actual = itr.previous();
            if (this.equals(actual)) {
                this.forEachDependency(itr, Item::verify);
                return;
            }
            itr.next();
            actual.pop(itr);
        }
        throw this.missing();
    }

    public void pop(ListIterator<Item> itr) {
        if (this.isVoid()) {
            this.verify(itr);
            return;
        }
        if (!this.bound()) {
            if (itr.hasPrevious()) {
                Item test = Util.peekPrevious(itr);
                while (test.isVoid()) {
                    test.verify(itr);
                    test = Util.peekPrevious(itr);
                }
                if (this.equals(test)) {
                    itr.set(Nop.FILL);
                    itr.previous();
                }
            }
            this.forEachDependency(itr, Item::pop);
            return;
        }
        Pop pop = new Pop(this);
        pop.insert(itr);
        this.verify(itr);
    }

    public void revoke(ListIterator<Item> itr) {
        this.remove(itr);
        this.forEachDependency(itr, Item::pop);
    }

    protected void remove(ListIterator<Item> itr) {
        while (itr.hasPrevious()) {
            Item actual = itr.previous();
            if (this.equals(actual)) {
                itr.set(Nop.FILL);
                return;
            }
            if (actual.isVoid()) {
                itr.next();
                actual.verify(itr);
                continue;
            }
            throw this.missing();
        }
        throw this.missing();
    }

    protected void insert(ListIterator<Item> itr) {
        if (itr.hasNext() && Util.peekNext(itr) == Nop.FILL) {
            itr.set(this);
        } else if (itr.hasPrevious() && Util.peekPrevious(itr) == Nop.FILL) {
            itr.set(this);
            itr.previous();
        } else {
            itr.add(this);
            itr.previous();
        }
        this.bind();
        Util.ensureBefore(itr, this);
    }

    protected void insertIfUnbound(ListIterator<Item> itr) {
        if (!this.bound()) {
            this.insert(itr);
            this.forEachDependency(itr, Item::insertIfUnbound);
        } else {
            this.verify(itr);
        }
    }

    protected void bind() {
    }

    protected void process(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        op.accept(this, itr);
    }

    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        if (!itr.hasPrevious()) {
            throw this.missing();
        }
    }

    private IllegalStateException missing() {
        if (this.creationSite == null) {
            return new IllegalStateException("Item " + String.valueOf(this) + " is not at its expected location (declare a LocalVar to store values which are used away from their creation site)\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
        }
        return new IllegalStateException("Item " + String.valueOf(this) + " created at " + this.creationSite + " is not at its expected location (declare a LocalVar to store values which are used away from their creation site)");
    }

    public abstract void writeCode(CodeBuilder var1, BlockCreatorImpl var2, StackMapBuilder var3);

    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
    }

    public boolean mayFallThrough() {
        return true;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder b) {
        this.toShortString(b);
        return b;
    }

    public StringBuilder toShortString(StringBuilder b) {
        return b.append(this.itemName());
    }

    @Override
    public Assignable elem(Expr index) {
        if (!this.type().isArray()) {
            throw new IllegalArgumentException("Value type is not array: " + this.type().displayName());
        }
        return new ArrayDeref(this, index);
    }

    @Override
    public Expr length() {
        if (!this.type().isArray()) {
            throw new IllegalArgumentException("Value type is not array: " + this.type().displayName());
        }
        return new ArrayLength(this);
    }

    @Override
    public InstanceFieldVar field(FieldDesc desc) {
        Assert.checkNotNullParam((String)"desc", (Object)desc);
        return new FieldDeref(this, desc, null);
    }

    @Override
    public InstanceFieldVar field(FieldDesc desc, GenericType genericType) {
        Assert.checkNotNullParam((String)"desc", (Object)desc);
        Assert.checkNotNullParam((String)"genericType", (Object)genericType);
        if (!Util.equals(desc.type(), genericType.desc())) {
            throw new IllegalArgumentException("Generic type %s does not match field type %s".formatted(genericType, desc.type()));
        }
        return new FieldDeref(this, desc, genericType);
    }

    Item asBound() {
        return this.bound() ? this : new BoundItem(this);
    }
}

