/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ActiveResult;
import io.quarkus.arc.BeanCreator;
import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ConfiguratorBase;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptionProxyInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.QualifierConfigurator;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.DefinitionException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public abstract class BeanConfiguratorBase<THIS extends BeanConfiguratorBase<THIS, T>, T>
extends ConfiguratorBase<THIS>
implements Consumer<AnnotationInstance> {
    protected String identifier;
    protected final DotName implClazz;
    protected final Set<Type> types;
    protected final Set<Type> registeredTypeClosures;
    protected final Set<Type> typesToRemove;
    protected final Set<AnnotationInstance> qualifiers;
    protected ScopeInfo scope;
    protected Boolean alternative;
    protected final List<StereotypeInfo> stereotypes;
    protected String name;
    protected Consumer<CreateGeneration> creatorConsumer;
    protected Consumer<DestroyGeneration> destroyerConsumer;
    protected boolean defaultBean;
    protected boolean removable;
    protected Type providerType;
    protected boolean forceApplicationClass;
    protected String targetPackageName;
    protected Integer priority;
    protected final Set<InjectionPointInfo.TypeAndQualifiers> injectionPoints;
    protected Integer startupPriority;
    protected InterceptionProxyInfo interceptionProxy;
    protected Consumer<CheckActiveGeneration> checkActiveConsumer;

    protected BeanConfiguratorBase(DotName implClazz) {
        this.implClazz = implClazz;
        this.types = new HashSet<Type>();
        this.registeredTypeClosures = new HashSet<Type>();
        this.typesToRemove = new HashSet<Type>();
        this.qualifiers = new HashSet<AnnotationInstance>();
        this.stereotypes = new ArrayList<StereotypeInfo>();
        this.removable = true;
        this.injectionPoints = new HashSet<InjectionPointInfo.TypeAndQualifiers>();
    }

    public THIS read(BeanConfiguratorBase<?, ?> base) {
        super.read(base);
        this.identifier = base.identifier;
        this.types.clear();
        this.types.addAll(base.types);
        this.registeredTypeClosures.clear();
        this.registeredTypeClosures.addAll(base.registeredTypeClosures);
        this.typesToRemove.clear();
        this.typesToRemove.addAll(base.typesToRemove);
        this.qualifiers.clear();
        this.qualifiers.addAll(base.qualifiers);
        this.scope = base.scope;
        this.alternative = base.alternative;
        this.stereotypes.clear();
        this.stereotypes.addAll(base.stereotypes);
        this.name = base.name;
        this.creator(base.creatorConsumer);
        this.destroyer(base.destroyerConsumer);
        if (base.defaultBean) {
            this.defaultBean = true;
        }
        this.removable = base.removable;
        this.providerType = base.providerType;
        this.forceApplicationClass = base.forceApplicationClass;
        this.targetPackageName = base.targetPackageName;
        this.priority = base.priority;
        this.injectionPoints.clear();
        this.injectionPoints.addAll(base.injectionPoints);
        this.startupPriority = base.startupPriority;
        this.interceptionProxy = base.interceptionProxy;
        this.checkActiveConsumer = base.checkActiveConsumer;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS types(Class<?> ... types) {
        for (Class<?> type : types) {
            this.addType(type);
        }
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS types(Type ... types) {
        Collections.addAll(this.types, types);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addType(DotName className) {
        this.types.add(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addType(Type type) {
        this.types.add(type);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addType(Class<?> type) {
        return this.addType(DotName.createSimple((String)type.getName()));
    }

    public THIS addTypeClosure(DotName typeName) {
        return this.addTypeClosure(Type.create((DotName)typeName, (Type.Kind)Type.Kind.CLASS));
    }

    public THIS addTypeClosure(Class<?> type) {
        return this.addTypeClosure(Type.create(type));
    }

    public THIS addTypeClosure(Type type) {
        this.registeredTypeClosures.add(type);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS removeTypes(Class<?> ... types) {
        for (Class<?> classType : types) {
            this.removeTypes(Type.create(classType));
        }
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS removeTypes(DotName ... types) {
        for (DotName name : types) {
            this.removeTypes(Type.create((DotName)name, (Type.Kind)Type.Kind.CLASS));
        }
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS removeTypes(Type ... types) {
        Collections.addAll(this.typesToRemove, types);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addQualifier(Class<? extends Annotation> annotationClass) {
        return this.addQualifier(DotName.createSimple((String)annotationClass.getName()));
    }

    public THIS addQualifier(DotName annotationName) {
        return this.addQualifier(AnnotationInstance.create((DotName)annotationName, null, (AnnotationValue[])new AnnotationValue[0]));
    }

    public THIS addQualifier(AnnotationInstance qualifier) {
        this.qualifiers.add(qualifier);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public QualifierConfigurator<THIS> addQualifier() {
        return new QualifierConfigurator<BeanConfiguratorBase>((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public THIS qualifiers(AnnotationInstance ... qualifiers) {
        Collections.addAll(this.qualifiers, qualifiers);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS scope(ScopeInfo scope) {
        this.scope = scope;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS scope(Class<? extends Annotation> scope) {
        DotName scopeName = DotName.createSimple((String)scope.getName());
        BuiltinScope builtinScope = BuiltinScope.from(scopeName);
        this.scope = builtinScope != null ? builtinScope.getInfo() : new ScopeInfo(scopeName, scope.isAnnotationPresent(NormalScope.class), scope.isAnnotationPresent(Inherited.class));
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS name(String name) {
        this.name = name;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS named(String name) {
        return (THIS)((BeanConfiguratorBase)((BeanConfiguratorBase)this.name(name)).addQualifier().annotation(DotNames.NAMED).addValue("value", name).done());
    }

    public THIS defaultBean() {
        this.defaultBean = true;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS unremovable() {
        this.removable = false;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS forceApplicationClass() {
        this.forceApplicationClass = true;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS targetPackageName(String name) {
        this.targetPackageName = name;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS alternative(boolean alternative) {
        this.alternative = alternative;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS priority(int value) {
        this.priority = value;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addStereotype(StereotypeInfo stereotype) {
        this.stereotypes.add(stereotype);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS stereotypes(StereotypeInfo ... stereotypes) {
        Collections.addAll(this.stereotypes, stereotypes);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS providerType(Type providerType) {
        this.providerType = providerType;
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS addInjectionPoint(Type requiredType, AnnotationInstance ... requiredQualifiers) {
        this.injectionPoints.add(new InjectionPointInfo.TypeAndQualifiers(requiredType, requiredQualifiers.length == 0 ? Set.of(AnnotationInstance.builder(Default.class).build()) : Set.of(requiredQualifiers)));
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public THIS startup(int priority) {
        this.startupPriority = priority;
        return this.unremovable();
    }

    public THIS startup() {
        return this.startup(2500);
    }

    public THIS injectInterceptionProxy() {
        return this.injectInterceptionProxy((DotName)null);
    }

    public THIS injectInterceptionProxy(Class<?> bindingsSource) {
        return this.injectInterceptionProxy(bindingsSource != null ? DotName.createSimple(bindingsSource) : null);
    }

    public THIS injectInterceptionProxy(DotName bindingsSource) {
        if (this.interceptionProxy != null) {
            throw new DefinitionException("Calling injectInterceptionProxy() more than once is invalid");
        }
        this.interceptionProxy = new InterceptionProxyInfo(bindingsSource);
        return (THIS)((BeanConfiguratorBase)this.self());
    }

    public <U extends T> THIS creator(Class<? extends BeanCreator<U>> creatorClazz) {
        return this.creator((CreateGeneration cg) -> {
            BlockCreator bc = cg.createMethod();
            MethodDesc createDesc = MethodDesc.of(BeanCreator.class, (String)"create", Object.class, (Class[])new Class[]{SyntheticCreationalContext.class});
            bc.return_(bc.invokeInterface(createDesc, bc.new_(creatorClazz), (Expr)cg.syntheticCreationalContext()));
        });
    }

    public THIS creator(Consumer<CreateGeneration> creatorConsumer) {
        this.creatorConsumer = creatorConsumer;
        return (THIS)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public <U extends T> THIS destroyer(Class<? extends BeanDestroyer<U>> destroyerClazz) {
        return this.destroyer((DestroyGeneration dg) -> {
            BlockCreator bc = dg.destroyMethod();
            MethodDesc destroyDesc = MethodDesc.of(BeanDestroyer.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class, Map.class});
            bc.invokeInterface(destroyDesc, bc.new_(destroyerClazz), new Expr[]{dg.destroyedInstance(), dg.creationalContext(), dg.paramsMap()});
            bc.return_();
        });
    }

    public THIS destroyer(Consumer<DestroyGeneration> destroyerConsumer) {
        this.destroyerConsumer = destroyerConsumer;
        return (THIS)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public THIS checkActive(Class<? extends Supplier<ActiveResult>> checkActiveClazz) {
        return this.checkActive((CheckActiveGeneration cag) -> {
            BlockCreator bc = cag.checkActiveMethod();
            bc.return_(bc.invokeInterface(MethodDescs.SUPPLIER_GET, bc.new_(checkActiveClazz)));
        });
    }

    public THIS checkActive(Consumer<CheckActiveGeneration> checkActiveConsumer) {
        this.checkActiveConsumer = checkActiveConsumer;
        return (THIS)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    public THIS identifier(String identifier) {
        this.identifier = identifier;
        return (THIS)((BeanConfiguratorBase)BeanConfiguratorBase.cast(this));
    }

    protected static <T> T cast(Object obj) {
        return (T)obj;
    }

    @Override
    public void accept(AnnotationInstance qualifier) {
        this.addQualifier(qualifier);
    }

    public static interface CheckActiveGeneration {
        public ClassCreator beanClass();

        public BlockCreator checkActiveMethod();
    }

    public static interface DestroyGeneration {
        public ClassCreator beanClass();

        public BlockCreator destroyMethod();

        default public Var paramsMap() {
            ClassCreator cc = this.beanClass();
            return cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)"params", Map.class));
        }

        public Var destroyedInstance();

        public Var creationalContext();
    }

    public static interface CreateGeneration {
        public ClassCreator beanClass();

        public BlockCreator createMethod();

        default public Var paramsMap() {
            ClassCreator cc = this.beanClass();
            return cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)"params", Map.class));
        }

        public Var syntheticCreationalContext();
    }
}

