/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.STCodeGenerator;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoUtil;
import java.io.IOException;
import java.io.Writer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

public class ProtoToJavaV2ProtocSchemaCompiler
extends STCodeGenerator {
    public ProtoToJavaV2ProtocSchemaCompiler() {
        super("java_v2protoc_schema");
    }

    static String resolveFileName(Proto proto) {
        String outerClassname = (String)proto.getExtraOption("java_outer_classname");
        return outerClassname == null ? ProtoUtil.toPascalCase((String)proto.getFile().getName().replaceAll(".proto", "")).toString() : outerClassname;
    }

    @Override
    protected void compile(ProtoModule module, Proto proto) throws IOException {
        String javaPackageName = proto.getJavaPackageName();
        StringTemplateGroup group = ProtoToJavaV2ProtocSchemaCompiler.getSTG(this.getOutputId());
        String fileName = ProtoToJavaV2ProtocSchemaCompiler.resolveFileName(proto);
        Writer writer = CompilerUtil.newWriter(module, javaPackageName, "Schema" + fileName + ".java");
        AutoIndentWriter out = new AutoIndentWriter(writer);
        StringTemplate protoOuterBlock = group.getInstanceOf("proto_block");
        protoOuterBlock.setAttribute("proto", (Object)proto);
        protoOuterBlock.setAttribute("module", (Object)module);
        protoOuterBlock.setAttribute("options", (Object)module.getOptions());
        protoOuterBlock.write((StringTemplateWriter)out);
        writer.close();
    }
}

