/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler;

import io.protostuff.compiler.CompilerUtil;
import io.protostuff.compiler.ProtoModule;
import io.protostuff.compiler.STCodeGenerator;
import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import java.io.IOException;
import java.io.Writer;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;

public class ProtoToJavaBeanMeCompiler
extends STCodeGenerator {
    public ProtoToJavaBeanMeCompiler() {
        super("java_bean_me");
    }

    @Override
    public void compile(ProtoModule module, Proto proto) throws IOException {
        AutoIndentWriter out;
        Writer writer;
        String javaPackageName = proto.getJavaPackageName();
        String template = "java_bean_me";
        StringTemplateGroup group = ProtoToJavaBeanMeCompiler.getSTG(template);
        for (EnumGroup eg : proto.getEnumGroups()) {
            writer = CompilerUtil.newWriter(module, javaPackageName, eg.getName() + ".java");
            out = new AutoIndentWriter(writer);
            StringTemplate enumBlock = group.getInstanceOf("enum_block");
            enumBlock.setAttribute("eg", (Object)eg);
            enumBlock.setAttribute("module", (Object)module);
            enumBlock.setAttribute("options", (Object)module.getOptions());
            enumBlock.write((StringTemplateWriter)out);
            writer.close();
        }
        for (Message m : proto.getMessages()) {
            writer = CompilerUtil.newWriter(module, javaPackageName, m.getName() + ".java");
            out = new AutoIndentWriter(writer);
            StringTemplate messageBlock = group.getInstanceOf("message_block");
            messageBlock.setAttribute("message", (Object)m);
            messageBlock.setAttribute("module", (Object)module);
            messageBlock.setAttribute("options", (Object)module.getOptions());
            messageBlock.write((StringTemplateWriter)out);
            writer.close();
        }
    }
}

