/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import io.opentelemetry.sdk.logs.export.LogRecordProcessorInstrumentation;
import io.opentelemetry.sdk.logs.export.LongCallable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class LegacyLogRecordProcessorInstrumentation
implements LogRecordProcessorInstrumentation {
    private static final AttributeKey<String> PROCESSOR_TYPE_LABEL = AttributeKey.stringKey((String)"processorType");
    private static final AttributeKey<Boolean> PROCESSOR_DROPPED_LABEL = AttributeKey.booleanKey((String)"dropped");
    private static final String PROCESSOR_TYPE_VALUE = BatchLogRecordProcessor.class.getSimpleName();
    private final Object lock = new Object();
    private final AtomicBoolean builtQueueMetrics = new AtomicBoolean(false);
    private final Supplier<MeterProvider> meterProvider;
    private final Attributes standardAttrs;
    private final Attributes droppedAttrs;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter processedLogs;

    LegacyLogRecordProcessorInstrumentation(Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
        this.standardAttrs = Attributes.of(PROCESSOR_TYPE_LABEL, (Object)PROCESSOR_TYPE_VALUE, PROCESSOR_DROPPED_LABEL, (Object)false);
        this.droppedAttrs = Attributes.of(PROCESSOR_TYPE_LABEL, (Object)PROCESSOR_TYPE_VALUE, PROCESSOR_DROPPED_LABEL, (Object)true);
    }

    @Override
    public void dropLogs(int count) {
        this.processedLogs().add((long)count, this.droppedAttrs);
    }

    @Override
    public void finishLogs(int count, @Nullable String error) {
        if (error != null) {
            this.processedLogs().add((long)count, this.standardAttrs);
        }
    }

    @Override
    public void buildQueueMetricsOnce(long unusedCapacity, LongCallable getSize) {
        if (!this.builtQueueMetrics.compareAndSet(false, true)) {
            return;
        }
        this.meter().gaugeBuilder("queueSize").ofLongs().setDescription("The number of items queued").setUnit("1").buildWithCallback(result -> result.record(getSize.get(), Attributes.of(PROCESSOR_TYPE_LABEL, (Object)PROCESSOR_TYPE_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter processedLogs() {
        LongCounter processedLogs = this.processedLogs;
        if (processedLogs == null) {
            Object object = this.lock;
            synchronized (object) {
                processedLogs = this.processedLogs;
                if (processedLogs == null) {
                    this.processedLogs = processedLogs = this.meter().counterBuilder("processedLogs").setUnit("1").setDescription("The number of logs processed by the BatchLogRecordProcessor. [dropped=true if they were dropped due to high throughput]").build();
                }
            }
        }
        return processedLogs;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("io.opentelemetry.sdk.logs");
        }
        return this.meter;
    }
}

