/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.incubator.common;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.common.ValueType;
import io.opentelemetry.api.incubator.common.ArrayBackedExtendedAttributesBuilder;
import io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.api.incubator.common.ExtendedAttributeType;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.incubator.common.ExtendedAttributesBuilder;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ArrayBackedExtendedAttributes
extends ImmutableKeyValuePairs<ExtendedAttributeKey<?>, Object>
implements ExtendedAttributes {
    private static final Comparator<ExtendedAttributeKey<?>> KEY_COMPARATOR_FOR_CONSTRUCTION = Comparator.comparing(ExtendedAttributeKey::getKey);
    static final ExtendedAttributes EMPTY = ExtendedAttributes.builder().build();
    @Nullable
    private Attributes attributes;

    private ArrayBackedExtendedAttributes(Object[] data, Comparator<ExtendedAttributeKey<?>> keyComparator) {
        super(data, keyComparator);
    }

    ArrayBackedExtendedAttributes(Object[] data) {
        super(data);
    }

    @Override
    public ExtendedAttributesBuilder toBuilder() {
        return new ArrayBackedExtendedAttributesBuilder(new ArrayList<Object>(this.data()));
    }

    @Override
    @Nullable
    public <T> T get(ExtendedAttributeKey<T> key) {
        if (key == null) {
            return null;
        }
        if (key.getType() == ExtendedAttributeType.VALUE) {
            return (T)this.getAsValue(key.getKey());
        }
        if (ArrayBackedExtendedAttributes.isArrayType(key.getType())) {
            Value<?> valueAttr;
            Object value = super.get(key);
            if (value == null && (valueAttr = this.getValueAttribute(key.getKey())) != null && ArrayBackedExtendedAttributes.isEmptyArray(valueAttr)) {
                return (T)Collections.emptyList();
            }
            return (T)value;
        }
        return (T)super.get(key);
    }

    private static boolean isArrayType(ExtendedAttributeType type) {
        return type == ExtendedAttributeType.STRING_ARRAY || type == ExtendedAttributeType.LONG_ARRAY || type == ExtendedAttributeType.DOUBLE_ARRAY || type == ExtendedAttributeType.BOOLEAN_ARRAY;
    }

    @Nullable
    private Value<?> getValueAttribute(String keyName) {
        List data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            ExtendedAttributeKey currentKey = (ExtendedAttributeKey)data.get(i);
            if (!currentKey.getKey().equals(keyName) || currentKey.getType() != ExtendedAttributeType.VALUE) continue;
            return (Value)data.get(i + 1);
        }
        return null;
    }

    private static boolean isEmptyArray(Value<?> value) {
        if (value.getType() != ValueType.ARRAY) {
            return false;
        }
        List arrayValues = (List)value.getValue();
        return arrayValues.isEmpty();
    }

    @Nullable
    private Value<?> getAsValue(String keyName) {
        List data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            ExtendedAttributeKey currentKey = (ExtendedAttributeKey)data.get(i);
            if (!currentKey.getKey().equals(keyName)) continue;
            Object value = data.get(i + 1);
            return ArrayBackedExtendedAttributes.asValue(currentKey.getType(), value);
        }
        return null;
    }

    @Nullable
    private static Value<?> asValue(ExtendedAttributeType type, Object value) {
        switch (type) {
            case STRING: {
                return Value.of((String)((String)value));
            }
            case LONG: {
                return Value.of((long)((Long)value));
            }
            case DOUBLE: {
                return Value.of((double)((Double)value));
            }
            case BOOLEAN: {
                return Value.of((boolean)((Boolean)value));
            }
            case STRING_ARRAY: {
                List stringList = (List)value;
                Value[] stringValues = new Value[stringList.size()];
                for (int i = 0; i < stringList.size(); ++i) {
                    stringValues[i] = Value.of((String)((String)stringList.get(i)));
                }
                return Value.of((Value[])stringValues);
            }
            case LONG_ARRAY: {
                List longList = (List)value;
                Value[] longValues = new Value[longList.size()];
                for (int i = 0; i < longList.size(); ++i) {
                    longValues[i] = Value.of((long)((Long)longList.get(i)));
                }
                return Value.of((Value[])longValues);
            }
            case DOUBLE_ARRAY: {
                List doubleList = (List)value;
                Value[] doubleValues = new Value[doubleList.size()];
                for (int i = 0; i < doubleList.size(); ++i) {
                    doubleValues[i] = Value.of((double)((Double)doubleList.get(i)));
                }
                return Value.of((Value[])doubleValues);
            }
            case BOOLEAN_ARRAY: {
                List booleanList = (List)value;
                Value[] booleanValues = new Value[booleanList.size()];
                for (int i = 0; i < booleanList.size(); ++i) {
                    booleanValues[i] = Value.of((boolean)((Boolean)booleanList.get(i)));
                }
                return Value.of((Value[])booleanValues);
            }
            case VALUE: {
                return (Value)value;
            }
            case EXTENDED_ATTRIBUTES: {
                return null;
            }
        }
        return null;
    }

    @Override
    public Attributes asAttributes() {
        if (this.attributes == null) {
            AttributesBuilder builder = Attributes.builder();
            this.forEach((extendedAttributeKey, value) -> {
                AttributeKey attributeKey = extendedAttributeKey.asAttributeKey();
                if (attributeKey != null) {
                    builder.put(attributeKey, value);
                }
            });
            this.attributes = builder.build();
        }
        return this.attributes;
    }

    static ExtendedAttributes sortAndFilterToAttributes(Object ... data) {
        for (int i = 0; i < data.length; i += 2) {
            ExtendedAttributeKey key = (ExtendedAttributeKey)data[i];
            if (key == null || !key.getKey().isEmpty()) continue;
            data[i] = null;
        }
        return new ArrayBackedExtendedAttributes(data, KEY_COMPARATOR_FOR_CONSTRUCTION);
    }
}

