/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jakarta9.instrument.jms;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.jakarta9.instrument.jms.JmsKeyValues;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsPublishObservationConvention;
import jakarta.jms.Message;

public class DefaultJmsPublishObservationConvention
implements JmsPublishObservationConvention {
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)"none");
    private static final KeyValue OPERATION_PUBLISH = KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.OPERATION, (String)"publish");

    public String getName() {
        return "jms.message.publish";
    }

    public String getContextualName(JmsPublishObservationContext context) {
        return this.destinationName(context).getValue() + " publish";
    }

    public KeyValues getLowCardinalityKeyValues(JmsPublishObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), OPERATION_PUBLISH, this.temporaryDestination(context)});
    }

    private KeyValue exception(JmsPublishObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of((KeyName)JmsObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, (String)(!simpleName.isEmpty() ? simpleName : error.getClass().getName()));
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue temporaryDestination(JmsPublishObservationContext context) {
        return JmsKeyValues.temporaryDestination((Message)context.getCarrier());
    }

    public KeyValues getHighCardinalityKeyValues(JmsPublishObservationContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.correlationId(context), this.destinationName(context), this.messageId(context)});
    }

    protected KeyValue correlationId(JmsPublishObservationContext context) {
        return JmsKeyValues.conversationId((Message)context.getCarrier());
    }

    protected KeyValue destinationName(JmsPublishObservationContext context) {
        return JmsKeyValues.destinationName((Message)context.getCarrier());
    }

    protected KeyValue messageId(JmsPublishObservationContext context) {
        return JmsKeyValues.messageId((Message)context.getCarrier());
    }
}

