/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterslave.NodeConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;

class ReflectiveNodeConnectionFactory
implements NodeConnectionFactory {
    private final Method connectToNodeAsync;
    private final RedisClient client;

    protected ReflectiveNodeConnectionFactory(RedisClient client) {
        this.client = client;
        try {
            this.connectToNodeAsync = RedisClient.class.getDeclaredMethod("connectStandaloneAsync", RedisCodec.class, RedisURI.class);
            this.connectToNodeAsync.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <K, V> CompletableFuture<StatefulRedisConnection<K, V>> connectToNodeAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        try {
            return (CompletableFuture)this.connectToNodeAsync.invoke((Object)this.client, codec, redisURI);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
    }
}

