/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.CloseEvents;
import io.lettuce.core.FutureSyncInvocationHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class RedisChannelHandler<K, V>
implements Closeable,
ConnectionFacade {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    private Duration timeout;
    private CloseEvents closeEvents = new CloseEvents();
    private final RedisChannelWriter channelWriter;
    private final boolean debugEnabled = logger.isDebugEnabled();
    private volatile boolean closed;
    private volatile boolean active = true;
    private volatile ClientOptions clientOptions;

    public RedisChannelHandler(RedisChannelWriter writer, Duration timeout) {
        this.channelWriter = writer;
        writer.setConnectionFacade(this);
        this.setTimeout(timeout);
    }

    public void setTimeout(Duration timeout) {
        LettuceAssert.notNull(timeout, "Timeout duration must not be null");
        LettuceAssert.isTrue(!timeout.isNegative(), "Timeout duration must be greater or equal to zero");
        this.timeout = timeout;
    }

    @Deprecated
    public void setTimeout(long timeout, TimeUnit unit) {
        this.setTimeout(Duration.ofNanos(unit.toNanos(timeout)));
    }

    @Override
    public synchronized void close() {
        if (this.debugEnabled) {
            logger.debug("close()");
        }
        if (this.closed) {
            logger.warn("Connection is already closed");
            return;
        }
        if (!this.closed) {
            this.active = false;
            this.closed = true;
            this.channelWriter.close();
            this.closeEvents.fireEventClosed(this);
            this.closeEvents = new CloseEvents();
        }
    }

    protected <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        if (this.debugEnabled) {
            logger.debug("dispatching command {}", cmd);
        }
        return this.channelWriter.write(cmd);
    }

    protected Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        if (this.debugEnabled) {
            logger.debug("dispatching commands {}", commands);
        }
        return this.channelWriter.write(commands);
    }

    public void registerCloseables(Collection<Closeable> registry, Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener(resource -> {
            for (Closeable closeable : closeables) {
                if (closeable == this) continue;
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!this.debugEnabled) continue;
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
            registry.removeAll(Arrays.asList(closeables));
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void activated() {
        this.active = true;
        this.closed = false;
    }

    @Override
    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    @Override
    public void reset() {
        this.channelWriter.reset();
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    public void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "ClientOptions must not be null");
        this.clientOptions = clientOptions;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    protected <T> T syncHandler(Object asyncApi, Class<?> ... interfaces) {
        FutureSyncInvocationHandler h = new FutureSyncInvocationHandler((StatefulConnection)((Object)this), asyncApi, interfaces);
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, (InvocationHandler)h);
    }

    public void setAutoFlushCommands(boolean autoFlush) {
        this.getChannelWriter().setAutoFlushCommands(autoFlush);
    }

    public void flushCommands() {
        this.getChannelWriter().flushCommands();
    }
}

