/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range.spring;

import io.hypersistence.utils.common.ReflectionUtils;
import io.hypersistence.utils.hibernate.type.ImmutableType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Properties;
import java.util.function.Function;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.springframework.data.domain.Range;

public class PostgreSQLSpringRangeType
extends ImmutableType<Range>
implements DynamicParameterizedType {
    private static final Range<Integer> EMPTY_INT_RANGE = Range.rightOpen((Object)Integer.MIN_VALUE, (Object)Integer.MIN_VALUE);
    private static final Range<Long> EMPTY_LONG_RANGE = Range.rightOpen((Object)Long.MIN_VALUE, (Object)Long.MIN_VALUE);
    private static final Range<BigDecimal> EMPTY_BIGDECIMAL_RANGE = Range.rightOpen((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
    private static final Range<LocalDateTime> EMPTY_LOCALDATETIME_RANGE = Range.rightOpen((Object)LocalDateTime.MIN, (Object)LocalDateTime.MIN);
    private static final Range<OffsetDateTime> EMPTY_OFFSETDATETIME_RANGE = Range.rightOpen((Object)OffsetDateTime.MIN, (Object)OffsetDateTime.MIN);
    private static final Range<ZonedDateTime> EMPTY_ZONEDDATETIME_RANGE = Range.rightOpen((Object)OffsetDateTime.MIN.toZonedDateTime(), (Object)OffsetDateTime.MIN.toZonedDateTime());
    private static final Range<LocalDate> EMPTY_DATE_RANGE = Range.rightOpen((Object)LocalDate.MIN, (Object)LocalDate.MIN);
    private static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 1, 6, false).optionalEnd().toFormatter();
    private static final DateTimeFormatter OFFSET_DATE_TIME = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 1, 6, false).optionalEnd().appendPattern("X").toFormatter();
    public static final PostgreSQLSpringRangeType INSTANCE = new PostgreSQLSpringRangeType();
    private Type type;
    private Class<?> elementType;

    public PostgreSQLSpringRangeType() {
        super(Range.class);
    }

    public PostgreSQLSpringRangeType(Class<?> elementType) {
        super(Range.class);
        this.elementType = elementType;
    }

    @Override
    protected Range get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        Object pgObject = rs.getObject(position);
        if (pgObject == null) {
            return null;
        }
        String type = (String)ReflectionUtils.invokeGetter(pgObject, "type");
        String value = (String)ReflectionUtils.invokeGetter(pgObject, "value");
        switch (type) {
            case "int4range": {
                return PostgreSQLSpringRangeType.integerRange(value);
            }
            case "int8range": {
                return PostgreSQLSpringRangeType.longRange(value);
            }
            case "numrange": {
                return PostgreSQLSpringRangeType.bigDecimalRange(value);
            }
            case "tsrange": {
                return PostgreSQLSpringRangeType.localDateTimeRange(value);
            }
            case "tstzrange": {
                return ZonedDateTime.class.equals(this.elementType) ? PostgreSQLSpringRangeType.zonedDateTimeRange(value) : PostgreSQLSpringRangeType.offsetDateTimeRange(value);
            }
            case "daterange": {
                return PostgreSQLSpringRangeType.localDateRange(value);
            }
        }
        throw new HibernateException((Throwable)new IllegalStateException("The range type [" + type + "] is not supported!"));
    }

    @Override
    protected void set(PreparedStatement st, Range range, int index, SharedSessionContractImplementor session) throws SQLException {
        if (range == null) {
            st.setNull(index, 1111);
        } else {
            Object holder = ReflectionUtils.newInstance("org.postgresql.util.PGobject");
            ReflectionUtils.invokeSetter(holder, "type", this.determineRangeType(range));
            ReflectionUtils.invokeSetter(holder, "value", this.asString(range));
            st.setObject(index, holder);
        }
    }

    public Range fromStringValue(CharSequence sequence) throws HibernateException {
        if (sequence != null) {
            String stringValue = (String)sequence;
            Class clazz = this.rangeClass();
            if (clazz != null) {
                if (Integer.class.isAssignableFrom(clazz)) {
                    return PostgreSQLSpringRangeType.integerRange(stringValue);
                }
                if (Long.class.isAssignableFrom(clazz)) {
                    return PostgreSQLSpringRangeType.longRange(stringValue);
                }
                if (BigDecimal.class.isAssignableFrom(clazz)) {
                    return PostgreSQLSpringRangeType.bigDecimalRange(stringValue);
                }
                if (LocalDateTime.class.isAssignableFrom(clazz)) {
                    return PostgreSQLSpringRangeType.localDateTimeRange(stringValue);
                }
                if (ZonedDateTime.class.isAssignableFrom(clazz)) {
                    return PostgreSQLSpringRangeType.zonedDateTimeRange(stringValue);
                }
                if (LocalDate.class.isAssignableFrom(clazz)) {
                    return PostgreSQLSpringRangeType.localDateRange(stringValue);
                }
                throw new HibernateException((Throwable)new IllegalStateException("The range type [" + this.type + "] is not supported!"));
            }
        }
        return null;
    }

    public void setParameterValues(Properties properties) {
        DynamicParameterizedType.ParameterType parameterType = (DynamicParameterizedType.ParameterType)properties.get("org.hibernate.type.ParameterType");
        this.type = parameterType.getReturnedClass();
        Type returnedJavaType = parameterType.getReturnedJavaType();
        if (returnedJavaType instanceof ParameterizedType) {
            this.elementType = (Class)((ParameterizedType)returnedJavaType).getActualTypeArguments()[0];
        }
    }

    public int getSqlType() {
        return 1111;
    }

    private String determineRangeType(Range<?> range) {
        Class<?> clazz = this.elementType;
        if (clazz.equals(Integer.class)) {
            return "int4range";
        }
        if (clazz.equals(Long.class)) {
            return "int8range";
        }
        if (clazz.equals(BigDecimal.class)) {
            return "numrange";
        }
        if (clazz.equals(LocalDateTime.class)) {
            return "tsrange";
        }
        if (clazz.equals(ZonedDateTime.class) || clazz.equals(OffsetDateTime.class)) {
            return "tstzrange";
        }
        if (clazz.equals(LocalDate.class)) {
            return "daterange";
        }
        throw new HibernateException((Throwable)new IllegalStateException("The class [" + clazz + "] is not supported!"));
    }

    public static <T extends Comparable<?>> Range<T> ofString(String str, Function<String, T> converter, Class<T> clazz) {
        int delim;
        if ("empty".equals(str)) {
            if (clazz.equals(Integer.class)) {
                return EMPTY_INT_RANGE;
            }
            if (clazz.equals(Long.class)) {
                return EMPTY_LONG_RANGE;
            }
            if (clazz.equals(BigDecimal.class)) {
                return EMPTY_BIGDECIMAL_RANGE;
            }
            if (clazz.equals(LocalDateTime.class)) {
                return EMPTY_LOCALDATETIME_RANGE;
            }
            if (clazz.equals(ZonedDateTime.class)) {
                return EMPTY_ZONEDDATETIME_RANGE;
            }
            if (clazz.equals(OffsetDateTime.class)) {
                return EMPTY_OFFSETDATETIME_RANGE;
            }
            if (clazz.equals(LocalDate.class)) {
                return EMPTY_DATE_RANGE;
            }
        }
        if ((delim = str.indexOf(44)) == -1) {
            throw new HibernateException((Throwable)new IllegalArgumentException("Cannot find comma character"));
        }
        String lowerStr = str.substring(1, delim);
        String upperStr = str.substring(delim + 1, str.length() - 1);
        Range.Bound lowerBound = Range.Bound.unbounded();
        Range.Bound upperBound = Range.Bound.unbounded();
        if (!lowerStr.isEmpty()) {
            Comparable lower = (Comparable)converter.apply(lowerStr);
            Range.Bound bound = lowerBound = str.charAt(0) == '[' ? Range.Bound.inclusive((Object)lower) : Range.Bound.exclusive((Object)lower);
        }
        if (!upperStr.isEmpty()) {
            Comparable upper = (Comparable)converter.apply(upperStr);
            upperBound = str.charAt(str.length() - 1) == ']' ? Range.Bound.inclusive((Object)upper) : Range.Bound.exclusive((Object)upper);
        }
        return Range.of((Range.Bound)lowerBound, (Range.Bound)upperBound);
    }

    public static Range<BigDecimal> bigDecimalRange(String range) {
        return PostgreSQLSpringRangeType.ofString(range, BigDecimal::new, BigDecimal.class);
    }

    public static Range<Integer> integerRange(String range) {
        return PostgreSQLSpringRangeType.ofString(range, Integer::parseInt, Integer.class);
    }

    public static Range<Long> longRange(String range) {
        return PostgreSQLSpringRangeType.ofString(range, Long::parseLong, Long.class);
    }

    public static Range<LocalDateTime> localDateTimeRange(String range) {
        return PostgreSQLSpringRangeType.ofString(range, PostgreSQLSpringRangeType.parseLocalDateTime().compose(PostgreSQLSpringRangeType.unquote()), LocalDateTime.class);
    }

    public static Range<LocalDate> localDateRange(String range) {
        Function<String, LocalDate> parseLocalDate = LocalDate::parse;
        return PostgreSQLSpringRangeType.ofString(range, parseLocalDate.compose(PostgreSQLSpringRangeType.unquote()), LocalDate.class);
    }

    public static Range<ZonedDateTime> zonedDateTimeRange(String rangeStr) {
        ZoneId upperZone;
        ZoneId lowerZone;
        Range<ZonedDateTime> range = PostgreSQLSpringRangeType.ofString(rangeStr, PostgreSQLSpringRangeType.parseZonedDateTime().compose(PostgreSQLSpringRangeType.unquote()), ZonedDateTime.class);
        if (range.getLowerBound().isBounded() && range.getUpperBound().isBounded() && !(lowerZone = ((ZonedDateTime)range.getLowerBound().getValue().get()).getZone()).equals(upperZone = ((ZonedDateTime)range.getUpperBound().getValue().get()).getZone())) {
            long zoneDriftSeconds;
            Duration lowerDst = ZoneId.systemDefault().getRules().getDaylightSavings(((ZonedDateTime)range.getLowerBound().getValue().get()).toInstant());
            Duration upperDst = ZoneId.systemDefault().getRules().getDaylightSavings(((ZonedDateTime)range.getUpperBound().getValue().get()).toInstant());
            long dstSeconds = upperDst.minus(lowerDst).getSeconds();
            if (dstSeconds < 0L) {
                dstSeconds *= -1L;
            }
            if ((zoneDriftSeconds = (long)(((ZoneOffset)lowerZone).getTotalSeconds() - ((ZoneOffset)upperZone).getTotalSeconds())) < 0L) {
                zoneDriftSeconds *= -1L;
            }
            if (dstSeconds != zoneDriftSeconds) {
                throw new HibernateException((Throwable)new IllegalArgumentException("The upper and lower bounds must be in same time zone!"));
            }
        }
        return range;
    }

    public static Range<OffsetDateTime> offsetDateTimeRange(String rangeStr) {
        return PostgreSQLSpringRangeType.ofString(rangeStr, PostgreSQLSpringRangeType.parseOffsetDateTime().compose(PostgreSQLSpringRangeType.unquote()), OffsetDateTime.class);
    }

    private static Function<String, LocalDateTime> parseLocalDateTime() {
        return str -> {
            try {
                return LocalDateTime.parse(str, LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return LocalDateTime.parse(str);
            }
        };
    }

    private static Function<String, ZonedDateTime> parseZonedDateTime() {
        return s -> {
            try {
                return ZonedDateTime.parse(s, OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return ZonedDateTime.parse(s);
            }
        };
    }

    private static Function<String, OffsetDateTime> parseOffsetDateTime() {
        return s -> {
            try {
                return OffsetDateTime.parse(s, OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                return OffsetDateTime.parse(s);
            }
        };
    }

    private static Function<String, String> unquote() {
        return s -> {
            if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                return s.substring(1, s.length() - 1);
            }
            return s;
        };
    }

    String asString(Range<?> range) {
        if (!range.getLowerBound().isBounded() && !range.getUpperBound().isBounded()) {
            return "(,)";
        }
        if (range.getLowerBound().getValue().equals(range.getUpperBound().getValue())) {
            return "empty";
        }
        Range.Bound lower = range.getLowerBound();
        Range.Bound upper = range.getUpperBound();
        StringBuilder sb = new StringBuilder();
        sb.append(lower.isBounded() ? (lower.isInclusive() ? "[" : "(") : "(");
        lower.getValue().ifPresent(sb::append);
        sb.append(",");
        upper.getValue().ifPresent(sb::append);
        sb.append(upper.isBounded() ? (upper.isInclusive() ? "]" : ")") : ")");
        return sb.toString();
    }

    private Class rangeClass() {
        if (this.type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)this.type).getActualTypeArguments();
            return (Class)types[0];
        }
        return null;
    }
}

