/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type;

import io.hypersistence.utils.hibernate.type.ImmutableType;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import jakarta.persistence.metamodel.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.type.BindableType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.ParameterizedType;

public abstract class DescriptorImmutableType<T, JDBC extends JdbcType, JAVA extends JavaType<T>>
extends ImmutableType<T>
implements BindableType<T>,
DomainType<T>,
DynamicParameterizedType {
    private final JDBC jdbcTypeDescriptor;
    private final JAVA javaTypeDescriptor;

    public DescriptorImmutableType(Class<T> clazz, JDBC jdbcTypeDescriptor, JAVA javaTypeDescriptor) {
        super(clazz);
        this.jdbcTypeDescriptor = jdbcTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    public DescriptorImmutableType(Class<T> clazz, JDBC jdbcTypeDescriptor, JAVA javaTypeDescriptor, Configuration configuration) {
        super(clazz, configuration);
        this.jdbcTypeDescriptor = jdbcTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
    }

    @Override
    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return (T)this.jdbcTypeDescriptor.getExtractor(this.javaTypeDescriptor).extract(rs, position, (WrapperOptions)session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.jdbcTypeDescriptor.getBinder(this.javaTypeDescriptor).bind(st, value, index, (WrapperOptions)session);
    }

    @Override
    protected T get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return this.nullSafeGet(rs, position, session, owner);
    }

    @Override
    protected void set(PreparedStatement st, T value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.nullSafeSet(st, value, index, session);
    }

    public int getSqlType() {
        return this.jdbcTypeDescriptor.getJdbcTypeCode();
    }

    public JavaType<T> getExpressibleJavaType() {
        return this.javaTypeDescriptor;
    }

    public SqmBindableType<T> resolveExpressible(BindingContext bindingContext) {
        return bindingContext.getTypeConfiguration().getBasicTypeRegistry().resolve(this.javaTypeDescriptor, this.jdbcTypeDescriptor);
    }

    public Class<T> getJavaType() {
        return this.javaTypeDescriptor.getJavaTypeClass();
    }

    public String getTypeName() {
        return this.javaTypeDescriptor.getTypeName();
    }

    public void setParameterValues(Properties parameters) {
        ParameterizedType parameterizedType;
        if (this.javaTypeDescriptor instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)this.javaTypeDescriptor;
            parameterizedType.setParameterValues(parameters);
        }
        if (this.jdbcTypeDescriptor instanceof ParameterizedType) {
            parameterizedType = (ParameterizedType)this.jdbcTypeDescriptor;
            parameterizedType.setParameterValues(parameters);
        }
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }
}

