/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array;

import io.hypersistence.utils.hibernate.type.array.internal.AbstractArrayType;
import io.hypersistence.utils.hibernate.type.array.internal.EnumArrayTypeDescriptor;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import io.hypersistence.utils.hibernate.type.util.ParameterizedParameterType;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.hibernate.type.spi.TypeBootstrapContext;
import org.hibernate.usertype.DynamicParameterizedType;

public class EnumArrayType
extends AbstractArrayType<Enum[]> {
    public static final EnumArrayType INSTANCE = new EnumArrayType();
    private static final String DEFAULT_TYPE_NAME = "%s_enum_array_type";
    private String name;

    public EnumArrayType() {
        super(new EnumArrayTypeDescriptor());
    }

    public EnumArrayType(Configuration configuration) {
        super(new EnumArrayTypeDescriptor(), configuration);
    }

    public EnumArrayType(Class arrayClass, String sqlArrayType) {
        super(new EnumArrayTypeDescriptor(arrayClass));
        Properties parameters = new Properties();
        parameters.setProperty("sql_array_type", sqlArrayType);
        parameters.put("org.hibernate.type.ParameterType", new ParameterizedParameterType(arrayClass));
        this.setParameterValues(parameters);
    }

    public EnumArrayType(TypeBootstrapContext typeBootstrapContext) {
        this(new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType parameterType = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        Annotation[] annotations = parameterType.getAnnotationsMethod();
        if (this.name == null) {
            this.name = String.format(DEFAULT_TYPE_NAME, parameters.getProperty("sql_array_type"));
        }
        super.setParameterValues(parameters);
    }
}

