/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest.junit;

import io.fabric8.kubeapitest.KubeAPIServer;
import io.fabric8.kubeapitest.KubeAPITestException;
import io.fabric8.kubeapitest.junit.ClientInjectionHandler;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Fabric8ClientInjectionHandler
implements ClientInjectionHandler {
    private KubernetesClient client;

    public boolean isTargetFieldAvailable(ExtensionContext extensionContext, boolean staticField) {
        return Fabric8ClientInjectionHandler.getFieldForKubeClientInjection(extensionContext, staticField).isPresent();
    }

    public void inject(ExtensionContext extensionContext, boolean staticField, KubeAPIServer kubeApiServer) {
        Field field = Fabric8ClientInjectionHandler.getFieldForKubeClientInjection(extensionContext, staticField).orElseThrow();
        this.setKubernetesClientToField(extensionContext, field, kubeApiServer);
    }

    private void setKubernetesClientToField(ExtensionContext extensionContext, Field kubeClientField, KubeAPIServer kubeApiServer) {
        try {
            Object target = extensionContext.getTestInstance().orElseGet(() -> extensionContext.getTestClass().orElseThrow());
            this.client = new KubernetesClientBuilder().withConfig(Config.fromKubeconfig((String)kubeApiServer.getKubeConfigYaml())).build();
            kubeClientField.setAccessible(true);
            kubeClientField.set(target, this.client);
        }
        catch (IllegalAccessException e) {
            throw new KubeAPITestException((Throwable)e);
        }
    }

    public void cleanup(ExtensionContext extensionContext) {
        if (this.client != null) {
            this.client.close();
        }
    }

    public static Optional<Field> getFieldForKubeClientInjection(ExtensionContext extensionContext, boolean staticField) {
        Class clazz = (Class)extensionContext.getTestClass().orElseThrow();
        List kubeConfigFields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> KubernetesClient.class.isAssignableFrom(f.getType())).collect(Collectors.toList());
        if (kubeConfigFields.isEmpty()) {
            return Optional.empty();
        }
        if (kubeConfigFields.size() > 1) {
            throw new KubeAPITestException("More fields type KubernetesClient found");
        }
        Field field = (Field)kubeConfigFields.get(0);
        if (Modifier.isStatic(field.getModifiers()) != staticField) {
            return Optional.empty();
        }
        return Optional.of(field);
    }
}

