/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Value;
import org.parboiled.BaseParser;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.support.Var;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleMethod
extends MethodNode {
    private final List<InstructionGroup> groups = new ArrayList<InstructionGroup>();
    private final List<LabelNode> usedLabels = new ArrayList<LabelNode>();
    private final Class<?> ownerClass;
    private int parameterCount;
    private boolean containsImplicitActions;
    private boolean containsExplicitActions;
    private boolean containsVars;
    private boolean containsPotentialSuperCalls;
    private boolean hasDontExtend;
    private boolean hasExplicitActionOnlyAnnotation;
    private boolean hasCachedAnnotation;
    private boolean hasDontLabelAnnotation;
    private boolean hasSuppressNodeAnnotation;
    private boolean hasSuppressSubnodesAnnotation;
    private boolean hasSkipNodeAnnotation;
    private boolean hasMemoMismatchesAnnotation;
    private boolean hasSkipActionsInPredicatesAnnotation;
    private int numberOfReturns;
    private InstructionGraphNode returnInstructionNode;
    private List<InstructionGraphNode> graphNodes;
    private List<LocalVariableNode> localVarVariables;
    private boolean bodyRewritten;
    private boolean skipGeneration;

    public RuleMethod(Class<?> ownerClass, int access, String name, String desc, String signature, String[] exceptions, boolean hasExplicitActionOnlyAnno, boolean hasDontLabelAnno, boolean hasSkipActionsInPredicates) {
        super(access, name, desc, signature, exceptions);
        this.ownerClass = ownerClass;
        this.parameterCount = Type.getArgumentTypes((String)desc).length;
        this.hasCachedAnnotation = this.parameterCount == 0;
        this.hasDontLabelAnnotation = hasDontLabelAnno;
        this.hasExplicitActionOnlyAnnotation = hasExplicitActionOnlyAnno;
        this.hasSkipActionsInPredicatesAnnotation = hasSkipActionsInPredicates;
        this.skipGeneration = this.isSuperMethod();
    }

    public List<InstructionGroup> getGroups() {
        return this.groups;
    }

    public List<LabelNode> getUsedLabels() {
        return this.usedLabels;
    }

    public Class<?> getOwnerClass() {
        return this.ownerClass;
    }

    public boolean hasDontExtend() {
        return this.hasDontExtend;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public boolean containsImplicitActions() {
        return this.containsImplicitActions;
    }

    public void setContainsImplicitActions(boolean containsImplicitActions) {
        this.containsImplicitActions = containsImplicitActions;
    }

    public boolean containsExplicitActions() {
        return this.containsExplicitActions;
    }

    public void setContainsExplicitActions(boolean containsExplicitActions) {
        this.containsExplicitActions = containsExplicitActions;
    }

    public boolean containsVars() {
        return this.containsVars;
    }

    public boolean containsPotentialSuperCalls() {
        return this.containsPotentialSuperCalls;
    }

    public boolean hasCachedAnnotation() {
        return this.hasCachedAnnotation;
    }

    public boolean hasDontLabelAnnotation() {
        return this.hasDontLabelAnnotation;
    }

    public boolean hasSuppressNodeAnnotation() {
        return this.hasSuppressNodeAnnotation;
    }

    public boolean hasSuppressSubnodesAnnotation() {
        return this.hasSuppressSubnodesAnnotation;
    }

    public boolean hasSkipActionsInPredicatesAnnotation() {
        return this.hasSkipActionsInPredicatesAnnotation;
    }

    public boolean hasSkipNodeAnnotation() {
        return this.hasSkipNodeAnnotation;
    }

    public boolean hasMemoMismatchesAnnotation() {
        return this.hasMemoMismatchesAnnotation;
    }

    public int getNumberOfReturns() {
        return this.numberOfReturns;
    }

    public InstructionGraphNode getReturnInstructionNode() {
        return this.returnInstructionNode;
    }

    public void setReturnInstructionNode(InstructionGraphNode returnInstructionNode) {
        this.returnInstructionNode = returnInstructionNode;
    }

    public List<InstructionGraphNode> getGraphNodes() {
        return this.graphNodes;
    }

    public List<LocalVariableNode> getLocalVarVariables() {
        return this.localVarVariables;
    }

    public boolean isBodyRewritten() {
        return this.bodyRewritten;
    }

    public void setBodyRewritten() {
        this.bodyRewritten = true;
    }

    public boolean isSuperMethod() {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.name));
        return this.name.charAt(0) == '$';
    }

    public InstructionGraphNode setGraphNode(AbstractInsnNode insn, BasicValue resultValue, List<Value> predecessors) {
        int index;
        InstructionGraphNode node;
        if (this.graphNodes == null) {
            this.graphNodes = new ArrayList<InstructionGraphNode>(Arrays.asList(new InstructionGraphNode[this.instructions.size()]));
        }
        if ((node = this.graphNodes.get(index = this.instructions.indexOf(insn))) == null) {
            node = new InstructionGraphNode(insn, resultValue);
            this.graphNodes.set(index, node);
        }
        node.addPredecessors(predecessors);
        return node;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Types.EXPLICIT_ACTIONS_ONLY_DESC.equals(desc)) {
            this.hasExplicitActionOnlyAnnotation = true;
            return null;
        }
        if (Types.CACHED_DESC.equals(desc)) {
            this.hasCachedAnnotation = true;
            return null;
        }
        if (Types.SUPPRESS_NODE_DESC.equals(desc)) {
            this.hasSuppressNodeAnnotation = true;
            return null;
        }
        if (Types.SUPPRESS_SUBNODES_DESC.equals(desc)) {
            this.hasSuppressSubnodesAnnotation = true;
            return null;
        }
        if (Types.SKIP_NODE_DESC.equals(desc)) {
            this.hasSkipNodeAnnotation = true;
            return null;
        }
        if (Types.MEMO_MISMATCHES_DESC.equals(desc)) {
            this.hasMemoMismatchesAnnotation = true;
            return null;
        }
        if (Types.SKIP_ACTIONS_IN_PREDICATES_DESC.equals(desc)) {
            this.hasSkipActionsInPredicatesAnnotation = true;
            return null;
        }
        if (Types.DONT_SKIP_ACTIONS_IN_PREDICATES_DESC.equals(desc)) {
            this.hasSkipActionsInPredicatesAnnotation = false;
            return null;
        }
        if (Types.DONT_LABEL_DESC.equals(desc)) {
            this.hasDontLabelAnnotation = true;
            return null;
        }
        if (Types.DONT_EXTEND_DESC.equals(desc)) {
            this.hasDontExtend = true;
            return null;
        }
        return visible ? super.visitAnnotation(desc, true) : null;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        switch (opcode) {
            case 184: {
                if (!this.hasExplicitActionOnlyAnnotation && AsmUtils.isBooleanValueOfZ(owner, name, desc)) {
                    this.containsImplicitActions = true;
                    break;
                }
                if (!AsmUtils.isActionRoot(owner, name)) break;
                this.containsExplicitActions = true;
                break;
            }
            case 183: {
                if ("<init>".equals(name)) {
                    if (!AsmUtils.isVarRoot(owner, name, desc)) break;
                    this.containsVars = true;
                    break;
                }
                if (!AsmUtils.isAssignableTo(owner, BaseParser.class)) break;
                this.containsPotentialSuperCalls = true;
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitInsn(int opcode) {
        if (opcode == 176) {
            ++this.numberOfReturns;
        }
        super.visitInsn(opcode);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.usedLabels.add(this.getLabelNode(label));
        super.visitJumpInsn(opcode, label);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.usedLabels.add(this.getLabelNode(dflt));
        for (Label label : labels) {
            this.usedLabels.add(this.getLabelNode(label));
        }
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.usedLabels.add(this.getLabelNode(dflt));
        for (Label label : labels) {
            this.usedLabels.add(this.getLabelNode(label));
        }
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index > this.parameterCount && Var.class.isAssignableFrom(AsmUtils.getClassForType(Type.getType((String)desc)))) {
            if (this.localVarVariables == null) {
                this.localVarVariables = new ArrayList<LocalVariableNode>();
            }
            this.localVarVariables.add(new LocalVariableNode(name, desc, null, null, null, index));
        }
    }

    public String toString() {
        return this.name;
    }

    public void moveFlagsTo(RuleMethod overridingMethod) {
        Preconditions.checkArgNotNull((Object)((Object)overridingMethod), (String)"overridingMethod");
        overridingMethod.hasCachedAnnotation |= this.hasCachedAnnotation;
        overridingMethod.hasDontLabelAnnotation |= this.hasDontLabelAnnotation;
        overridingMethod.hasSuppressNodeAnnotation |= this.hasSuppressNodeAnnotation;
        overridingMethod.hasSuppressSubnodesAnnotation |= this.hasSuppressSubnodesAnnotation;
        overridingMethod.hasSkipNodeAnnotation |= this.hasSkipNodeAnnotation;
        overridingMethod.hasMemoMismatchesAnnotation |= this.hasMemoMismatchesAnnotation;
        this.hasCachedAnnotation = false;
        this.hasDontLabelAnnotation = true;
        this.hasSuppressNodeAnnotation = false;
        this.hasSuppressSubnodesAnnotation = false;
        this.hasSkipNodeAnnotation = false;
        this.hasMemoMismatchesAnnotation = false;
    }

    public boolean isGenerationSkipped() {
        return this.skipGeneration;
    }

    public void dontSkipGeneration() {
        this.skipGeneration = false;
    }

    public void suppressNode() {
        this.hasSuppressNodeAnnotation = true;
    }
}

