/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class CachingGenerator
implements RuleMethodProcessor {
    private ParserClassNode classNode;
    private RuleMethod method;
    private InsnList instructions;
    private AbstractInsnNode current;
    private String cacheFieldName;

    CachingGenerator() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.hasCachedAnnotation();
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        Preconditions.checkState((!method.isSuperMethod() ? 1 : 0) != 0);
        this.classNode = classNode;
        this.method = method;
        this.instructions = method.instructions;
        this.current = this.instructions.getFirst();
        this.generateCacheHitReturn();
        this.generateStoreNewProxyMatcher();
        this.seekToReturnInstruction();
        this.generateArmProxyMatcher();
        this.generateStoreInCache();
    }

    private void generateCacheHitReturn() {
        this.generateGetFromCache();
        this.insert((AbstractInsnNode)new InsnNode(89));
        LabelNode cacheMissLabel = new LabelNode();
        this.insert((AbstractInsnNode)new JumpInsnNode(198, cacheMissLabel));
        this.insert((AbstractInsnNode)new InsnNode(176));
        this.insert((AbstractInsnNode)cacheMissLabel);
        this.insert((AbstractInsnNode)new InsnNode(87));
    }

    private void generateGetFromCache() {
        Type[] paramTypes = Type.getArgumentTypes((String)this.method.desc);
        this.cacheFieldName = this.findUnusedCacheFieldName();
        String cacheFieldDesc = paramTypes.length == 0 ? Types.RULE_DESC : "Ljava/util/HashMap;";
        this.classNode.fields.add(new FieldNode(2, this.cacheFieldName, cacheFieldDesc, null, null));
        this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        this.insert((AbstractInsnNode)new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, cacheFieldDesc));
        if (paramTypes.length == 0) {
            return;
        }
        this.insert((AbstractInsnNode)new InsnNode(89));
        LabelNode alreadyInitialized = new LabelNode();
        this.insert((AbstractInsnNode)new JumpInsnNode(199, alreadyInitialized));
        this.insert((AbstractInsnNode)new InsnNode(87));
        this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        this.insert((AbstractInsnNode)new TypeInsnNode(187, "java/util/HashMap"));
        this.insert((AbstractInsnNode)new InsnNode(90));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, "java/util/HashMap", "<init>", "()V"));
        this.insert((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, cacheFieldDesc));
        this.insert((AbstractInsnNode)alreadyInitialized);
        if (paramTypes.length > 1 || paramTypes[0].getSort() == 9) {
            String arguments = Type.getInternalName(Arguments.class);
            this.insert((AbstractInsnNode)new TypeInsnNode(187, arguments));
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.generatePushNewParameterObjectArray(paramTypes);
            this.insert((AbstractInsnNode)new MethodInsnNode(183, arguments, "<init>", "([Ljava/lang/Object;)V"));
        } else {
            this.generatePushParameterAsObject(paramTypes, 0);
        }
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new VarInsnNode(58, this.method.maxLocals));
        this.insert((AbstractInsnNode)new MethodInsnNode(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;"));
        this.insert((AbstractInsnNode)new TypeInsnNode(192, Types.RULE.getInternalName()));
    }

    private String findUnusedCacheFieldName() {
        String name = "cache$" + this.method.name;
        int i = 2;
        while (this.hasField(name)) {
            name = "cache$" + this.method.name + i++;
        }
        return name;
    }

    public boolean hasField(String fieldName) {
        for (Object field : this.classNode.fields) {
            if (!fieldName.equals(((FieldNode)field).name)) continue;
            return true;
        }
        return false;
    }

    private void generatePushNewParameterObjectArray(Type[] paramTypes) {
        this.insert((AbstractInsnNode)new IntInsnNode(16, paramTypes.length));
        this.insert((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        for (int i = 0; i < paramTypes.length; ++i) {
            this.insert((AbstractInsnNode)new InsnNode(89));
            this.insert((AbstractInsnNode)new IntInsnNode(16, i));
            this.generatePushParameterAsObject(paramTypes, i);
            this.insert((AbstractInsnNode)new InsnNode(83));
        }
    }

    private void generatePushParameterAsObject(Type[] paramTypes, int parameterNr) {
        switch (paramTypes[parameterNr++].getSort()) {
            case 1: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;"));
                return;
            }
            case 2: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;"));
                return;
            }
            case 3: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
                return;
            }
            case 4: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;"));
                return;
            }
            case 5: {
                this.insert((AbstractInsnNode)new VarInsnNode(21, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;"));
                return;
            }
            case 6: {
                this.insert((AbstractInsnNode)new VarInsnNode(23, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;"));
                return;
            }
            case 7: {
                this.insert((AbstractInsnNode)new VarInsnNode(22, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;"));
                return;
            }
            case 8: {
                this.insert((AbstractInsnNode)new VarInsnNode(24, parameterNr));
                this.insert((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;"));
                return;
            }
            case 9: 
            case 10: {
                this.insert((AbstractInsnNode)new VarInsnNode(25, parameterNr));
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void generateStoreNewProxyMatcher() {
        String proxyMatcherType = Types.PROXY_MATCHER.getInternalName();
        this.insert((AbstractInsnNode)new TypeInsnNode(187, proxyMatcherType));
        this.insert((AbstractInsnNode)new InsnNode(89));
        this.insert((AbstractInsnNode)new MethodInsnNode(183, proxyMatcherType, "<init>", "()V"));
        this.generateStoreInCache();
    }

    private void seekToReturnInstruction() {
        while (this.current.getOpcode() != 176) {
            this.current = this.current.getNext();
        }
    }

    private void generateArmProxyMatcher() {
        String proxyMatcherType = Types.PROXY_MATCHER.getInternalName();
        this.insert((AbstractInsnNode)new InsnNode(90));
        this.insert((AbstractInsnNode)new TypeInsnNode(192, Types.MATCHER.getInternalName()));
        this.insert((AbstractInsnNode)new MethodInsnNode(182, proxyMatcherType, "arm", '(' + Types.MATCHER_DESC + ")V"));
    }

    private void generateStoreInCache() {
        Type[] paramTypes = Type.getArgumentTypes((String)this.method.desc);
        this.insert((AbstractInsnNode)new InsnNode(89));
        if (paramTypes.length == 0) {
            this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
            this.insert((AbstractInsnNode)new InsnNode(95));
            this.insert((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, Types.RULE_DESC));
            return;
        }
        this.insert((AbstractInsnNode)new VarInsnNode(25, this.method.maxLocals));
        this.insert((AbstractInsnNode)new InsnNode(95));
        this.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        this.insert((AbstractInsnNode)new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, "Ljava/util/HashMap;"));
        this.insert((AbstractInsnNode)new InsnNode(91));
        this.insert((AbstractInsnNode)new InsnNode(87));
        this.insert((AbstractInsnNode)new MethodInsnNode(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"));
        this.insert((AbstractInsnNode)new InsnNode(87));
    }

    private void insert(AbstractInsnNode instruction) {
        this.instructions.insertBefore(this.current, instruction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Arguments {
        private final Object[] params;

        public Arguments(Object[] params) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.unroll(params, list);
            this.params = list.toArray();
        }

        private void unroll(Object[] params, List<Object> list) {
            block11: for (Object param : params) {
                if (param != null && param.getClass().isArray()) {
                    switch (Type.getType(param.getClass().getComponentType()).getSort()) {
                        case 1: {
                            this.unroll(Utils.toObjectArray((boolean[])((boolean[])param)), list);
                            continue block11;
                        }
                        case 3: {
                            this.unroll(Utils.toObjectArray((byte[])((byte[])param)), list);
                            continue block11;
                        }
                        case 2: {
                            this.unroll(Utils.toObjectArray((char[])((char[])param)), list);
                            continue block11;
                        }
                        case 8: {
                            this.unroll(Utils.toObjectArray((double[])((double[])param)), list);
                            continue block11;
                        }
                        case 6: {
                            this.unroll(Utils.toObjectArray((float[])((float[])param)), list);
                            continue block11;
                        }
                        case 5: {
                            this.unroll(Utils.toObjectArray((int[])((int[])param)), list);
                            continue block11;
                        }
                        case 7: {
                            this.unroll(Utils.toObjectArray((long[])((long[])param)), list);
                            continue block11;
                        }
                        case 4: {
                            this.unroll(Utils.toObjectArray((short[])((short[])param)), list);
                            continue block11;
                        }
                        case 9: 
                        case 10: {
                            this.unroll((Object[])param, list);
                            continue block11;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
                list.add(param);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Arguments)) {
                return false;
            }
            Arguments that = (Arguments)o;
            return Arrays.equals(this.params, that.params);
        }

        public int hashCode() {
            return this.params != null ? Arrays.hashCode(this.params) : 0;
        }
    }
}

