/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.addons.importexport.ExportQueryTask;
import org.nuiton.wikitty.addons.importexport.ExportTask;
import org.nuiton.wikitty.addons.importexport.ImportExportCSV;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.addons.importexport.ImportExportXML;
import org.nuiton.wikitty.addons.importexport.ImportTask;
import org.nuiton.wikitty.addons.importexport.JobState;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.search.Criteria;

public class WikittyImportExportService {
    WikittyClient client;
    protected String exportDirectory = "/tmp/";
    protected String exportPublicURL = "file:///tmp/";
    protected ExecutorService importExportExecutor;
    protected Map<String, Future<String>> importExportTask = new HashMap<String, Future<String>>();

    public WikittyImportExportService(WikittyClient client) {
        this.client = client;
        ApplicationConfig config = client.getConfig();
        this.exportDirectory = config.getOption(WikittyConfigOption.WIKITTY_EXPORT_DIRECTORY.getKey());
        this.exportPublicURL = config.getOption(WikittyConfigOption.WIKITTY_EXPORT_PUBLICURL.getKey());
        int maxThread = config.getOptionAsInt(WikittyConfigOption.WIKITTY_EXPORT_THREADNUMBER.getKey());
        this.importExportExecutor = Executors.newFixedThreadPool(maxThread);
    }

    @Deprecated
    public WikittyImportExportService(ApplicationConfig config, String securityToken, WikittyService ws) {
        this(new WikittyClient(config, ws, securityToken));
    }

    public WikittyClient getClient() {
        return this.client;
    }

    public WikittyService getWikittyService() {
        return this.getClient().getWikittyService();
    }

    public String getExportDirectory() {
        return this.exportDirectory;
    }

    public String getExportPublicURL() {
        return this.exportPublicURL;
    }

    public void syncImport(FORMAT format, String s) {
        StringReader reader = new StringReader(s);
        this.syncImport(format, reader);
    }

    public void syncImport(FORMAT format, Reader reader) {
        ImportTask task = new ImportTask(this.client, format, reader);
        task.run();
    }

    public void syncImportFromUri(FORMAT format, String uri) {
        try {
            URL url = new URL(uri);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            ImportTask task = new ImportTask(this.client, format, reader);
            task.run();
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't import in format %s uri %s", new Object[]{format, uri}), eee);
        }
    }

    public String asyncImportFromUri(FORMAT format, String uri) {
        try {
            URL url = new URL(uri);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            ImportTask task = new ImportTask(this.client, format, reader);
            FutureTask<Object> future = new FutureTask<Object>(task, null);
            this.importExportExecutor.submit(future);
            String jobId = UUID.randomUUID().toString();
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't import in format %s uri %s", new Object[]{format, uri}), eee);
        }
    }

    public String asyncExportAllByExample(FORMAT format, BusinessEntityImpl e) {
        WikittyQuery query = new WikittyQueryMaker().wikitty(e).end();
        String result = this.asyncExportAllByQuery(format, query);
        return result;
    }

    public String syncExportAllByExample(FORMAT format, BusinessEntityImpl e) {
        WikittyQuery query = new WikittyQueryMaker().wikitty(e).end();
        String result = this.syncExportAllByQuery(format, query);
        return result;
    }

    public void syncExportAllByExample(FORMAT format, BusinessEntityImpl e, Writer writer) {
        WikittyQuery query = new WikittyQueryMaker().wikitty(e).end();
        this.syncExportAllByQuery(format, query, writer);
    }

    public String asyncExportAllByQuery(FORMAT format, WikittyQuery query) {
        try {
            String jobId = UUID.randomUUID().toString();
            File file = new File(this.exportDirectory, jobId);
            file.getParentFile().mkdirs();
            String url = this.exportPublicURL + jobId;
            FileWriter result = new FileWriter(file);
            ExportQueryTask task = new ExportQueryTask(this.client, format, query, result);
            FutureTask<String> future = new FutureTask<String>(task, url);
            this.importExportExecutor.submit(future);
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't export in format %s", new Object[]{format}), eee);
        }
    }

    public String syncExportAllByQuery(FORMAT format, WikittyQuery query) {
        StringWriter result = new StringWriter();
        this.syncExportAllByQuery(format, query, result);
        return result.toString();
    }

    public void syncExportAllByQuery(FORMAT format, WikittyQuery query, Writer writer) {
        ExportQueryTask task = new ExportQueryTask(this.client, format, query, writer);
        task.run();
    }

    @Deprecated
    public String asyncExportAllByCriteria(FORMAT format, Criteria criteria) {
        try {
            String jobId = UUID.randomUUID().toString();
            File file = new File(this.exportDirectory, jobId);
            file.getParentFile().mkdirs();
            String url = this.exportPublicURL + jobId;
            FileWriter result = new FileWriter(file);
            ExportTask task = new ExportTask(this.client.getSecurityToken(), this.client.getWikittyService(), format, criteria, result);
            FutureTask<String> future = new FutureTask<String>(task, url);
            this.importExportExecutor.submit(future);
            this.importExportTask.put(jobId, future);
            return jobId;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't export in format %s", new Object[]{format}), eee);
        }
    }

    @Deprecated
    public String syncExportAllByCriteria(FORMAT format, Criteria criteria) {
        StringWriter result = new StringWriter();
        this.syncExportAllByCriteria(format, criteria, result);
        return result.toString();
    }

    @Deprecated
    public void syncExportAllByCriteria(FORMAT format, Criteria criteria, Writer writer) {
        ExportTask task = new ExportTask(this.client.getSecurityToken(), this.client.getWikittyService(), format, criteria, writer);
        task.run();
    }

    public JobState infoJob(String jobId) {
        try {
            Future<String> future = this.importExportTask.get(jobId);
            JobState result = new JobState();
            if (future.isDone()) {
                result.status = "done";
                result.resourceUri = future.get();
            } else {
                result.status = future.isCancelled() ? "cancelled" : "inProgress";
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't retrieve job info for job %s", jobId), eee);
        }
    }

    public void cancelJob(String jobId) {
        Future<String> future = this.importExportTask.get(jobId);
        future.cancel(true);
    }

    public void freeJobResource(String jobId) {
        Future<String> future = this.importExportTask.remove(jobId);
        if (future != null) {
            File file = new File(this.exportDirectory, jobId);
            file.delete();
        }
    }

    public static enum FORMAT {
        XML(new ImportExportXML()),
        CSV(new ImportExportCSV());

        protected ImportExportMethod ieporter;

        private FORMAT(ImportExportMethod ieporter) {
            this.ieporter = ieporter;
        }

        public ImportExportMethod ieporter() {
            return this.ieporter;
        }
    }
}

