/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  abstract class AgentAbstract extends BusinessEntityImpl implements Agent {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionAgent;
    /**
     * getRefNumber :
     * @return String 
     */

    @Override
    public String getRefNumber() {
        String value = AgentHelper.getRefNumber(getWikitty());
        return value;
}

    /**
     * setRefNumber :
     * @param refNumber 
     */

    @Override
    public void setRefNumber(String refNumber) {
        String oldValue = getRefNumber();
        AgentHelper.setRefNumber(getWikitty(), refNumber);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_REFNUMBER, oldValue, getRefNumber());
}

    /**
     * getState :
     * @return String 
     */

    @Override
    public String getState() {
        String value = AgentHelper.getState(getWikitty());
        return value;
}

    /**
     * setState :
     * @param state 
     */

    @Override
    public void setState(String state) {
        String oldValue = getState();
        AgentHelper.setState(getWikitty(), state);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_STATE, oldValue, getState());
}

    /**
     * getStateDate :
     * @return Date 
     */

    @Override
    public Date getStateDate() {
        Date value = AgentHelper.getStateDate(getWikitty());
        return value;
}

    /**
     * setStateDate :
     * @param stateDate 
     */

    @Override
    public void setStateDate(Date stateDate) {
        Date oldValue = getStateDate();
        AgentHelper.setStateDate(getWikitty(), stateDate);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_STATEDATE, oldValue, getStateDate());
}

    /**
     * getAgent :
     * @return Boolean 
     */

    @Override
    public Boolean getAgent() {
        Boolean value = AgentHelper.getAgent(getWikitty());
        return value;
}

    /**
     * setAgent :
     * @param agent 
     */

    @Override
    public void setAgent(Boolean agent) {
        Boolean oldValue = getAgent();
        AgentHelper.setAgent(getWikitty(), agent);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_AGENT, oldValue, getAgent());
}

    /**
     * getJobType :
     * @return String 
     */

    @Override
    public String getJobType() {
        String value = AgentHelper.getJobType(getWikitty());
        return value;
}

    /**
     * setJobType :
     * @param jobType 
     */

    @Override
    public void setJobType(String jobType) {
        String oldValue = getJobType();
        AgentHelper.setJobType(getWikitty(), jobType);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_JOBTYPE, oldValue, getJobType());
}

    /**
     * getAddress :
     * @return String 
     */

    @Override
    public String getAddress() {
        String value = AgentHelper.getAddress(getWikitty());
        return value;
}

    /**
     * setAddress :
     * @param address 
     */

    @Override
    public void setAddress(String address) {
        String oldValue = getAddress();
        AgentHelper.setAddress(getWikitty(), address);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_ADDRESS, oldValue, getAddress());
}

    /**
     * getCati :
     * @return String 
     */

    @Override
    public String getCati() {
        String value = AgentHelper.getCati(getWikitty());
        return value;
}

    /**
     * setCati :
     * @param cati 
     */

    @Override
    public void setCati(String cati) {
        String oldValue = getCati();
        AgentHelper.setCati(getWikitty(), cati);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_CATI, oldValue, getCati());
}

    /**
     * getDepartment :
     * @return String 
     */

    @Override
    public String getDepartment() {
        String value = AgentHelper.getDepartment(getWikitty());
        return value;
}

    /**
     * setDepartment :
     * @param department 
     */

    @Override
    public void setDepartment(String department) {
        String oldValue = getDepartment();
        AgentHelper.setDepartment(getWikitty(), department);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_DEPARTMENT, oldValue, getDepartment());
}

    /**
     * getUnit :
     * @return Set<String> 
     */

    @Override
    public Set<String> getUnit() {
        Set<String> result = AgentHelper.getUnit(getWikitty());
        return result;
}

    /**
     * setUnit :
     * @param unit 
     */

    @Override
    public void setUnit(Set<String> unit) {
        Set<String> oldValue = getUnit();
        AgentHelper.setUnit(getWikitty(), unit);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, oldValue, getUnit());
}

    /**
     * addAllUnit :
     * @param unit 
     */

    @Override
    public void addAllUnit(Set<String> unit) {
        Set<String> oldValue = getUnit();
        AgentHelper.addAllUnit(getWikitty(), unit);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, oldValue, getUnit());
}

    /**
     * addUnit :
     * @param element 
     */

    @Override
    public void addUnit(String element) {
        AgentHelper.addUnit(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, null, getUnit());
}

    /**
     * removeUnit :
     * @param element 
     */

    @Override
    public void removeUnit(String element) {
        AgentHelper.removeUnit(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, null, getUnit());
}

    /**
     * clearUnit :
     */

    @Override
    public void clearUnit() {
        AgentHelper.clearUnit(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Agent.FIELD_AGENT_UNIT, null, getUnit());
}

    /**
     * getLastName :
     * @return String 
     */

    public String getLastName() {
        String value = UserHelper.getLastName(getWikitty());
        return value;
}

    /**
     * setLastName :
     * @param lastName 
     */

    public void setLastName(String lastName) {
        String oldValue = getLastName();
        UserHelper.setLastName(getWikitty(), lastName);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_LASTNAME, oldValue, getLastName());
}

    /**
     * getFirstName :
     * @return String 
     */

    public String getFirstName() {
        String value = UserHelper.getFirstName(getWikitty());
        return value;
}

    /**
     * setFirstName :
     * @param firstName 
     */

    public void setFirstName(String firstName) {
        String oldValue = getFirstName();
        UserHelper.setFirstName(getWikitty(), firstName);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_FIRSTNAME, oldValue, getFirstName());
}

    /**
     * getEmail :
     * @return String 
     */

    public String getEmail() {
        String value = UserHelper.getEmail(getWikitty());
        return value;
}

    /**
     * setEmail :
     * @param email 
     */

    public void setEmail(String email) {
        String oldValue = getEmail();
        UserHelper.setEmail(getWikitty(), email);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_EMAIL, oldValue, getEmail());
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        String value = UserHelper.getComment(getWikitty());
        return value;
}

    /**
     * setComment :
     * @param comment 
     */

    public void setComment(String comment) {
        String oldValue = getComment();
        UserHelper.setComment(getWikitty(), comment);
        getPropertyChangeSupport().firePropertyChange(User.FIELD_USER_COMMENT, oldValue, getComment());
}

    /**
     * getLogin :
     * @return String 
     */

    public String getLogin() {
        String value = WikittyUserHelper.getLogin(getWikitty());
        return value;
}

    /**
     * setLogin :
     * @param login 
     */

    public void setLogin(String login) {
        String oldValue = getLogin();
        WikittyUserHelper.setLogin(getWikitty(), login);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_LOGIN, oldValue, getLogin());
}

    /**
     * getPassword :
     * @return String 
     */

    public String getPassword() {
        String value = WikittyUserHelper.getPassword(getWikitty());
        return value;
}

    /**
     * setPassword :
     * @param password 
     */

    public void setPassword(String password) {
        String oldValue = getPassword();
        WikittyUserHelper.setPassword(getWikitty(), password);
        getPropertyChangeSupport().firePropertyChange(WikittyUser.FIELD_WIKITTYUSER_PASSWORD, oldValue, getPassword());
}

    /**
     * AgentAbstract :
     */

    public AgentAbstract() {
        super();
}

    /**
     * AgentAbstract :
     * @param wikitty 
     */

    public AgentAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * AgentAbstract :
     * @param businessEntityImpl 
     */

    public AgentAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionAgent =
                new WikittyExtension(EXT_AGENT,
                                     "3.0", // version
                                     User.EXT_USER,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String refNumber unique=\"true\"", 
                                             "String state unique=\"true\"", 
                                             "Date stateDate unique=\"true\"", 
                                             "Boolean agent unique=\"true\"", 
                                             "String jobType unique=\"true\"", 
                                             "String address unique=\"true\"", 
                                             "Wikitty cati unique=\"true\"", 
                                             "Wikitty department unique=\"true\"", 
                                             "Wikitty unit[1-*] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(UserAbstract.extensions); 
        // current after requires ones

        exts.add(extensionAgent);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //AgentAbstract
