// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringDao.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.physical;

import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.andromda.spring.PaginationResult;

/**
 * Caractéristiques d'un navire, sur une période donnée.
 * Si le navire est inscrit au FPC, les caractéristiques FPC sont utilisées (jauge_ums et
 * jauge_brute).
 * REMARQUE : les données ramenées depuis Harmonie sont fusionnées entre les caractéristiques FPC (à
 * utiliser de préférence si présent), et les caractéristiques d'autres sources.
 * Nombre de lignes : 67375
 * @see VesselFeatures
 */
public interface VesselFeaturesDao
{
    /**
     * This constant is used as a transformation flag; entities can be converted automatically into value objects
     * or other types, different methods in a class implementing this interface support this feature: look for
     * an <code>int</code> parameter called <code>transform</code>.
     * <p>
     * This specific flag denotes no transformation will occur.
     */
    public static final int TRANSFORM_NONE = 0;


    /**
     * Transforms the given results to a collection of {@link VesselFeatures}
     * instances (this is useful when the returned results contains a row of data and you want just entities only).
     *
     * @param results the query results.
     */
    public void toEntities(final Collection<?> results);

    /**
     * Gets an instance of VesselFeatures from the persistent store.
     * @param id
     * @return VesselFeatures
     */
    public VesselFeatures get(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #get(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to get.
     * @return either the entity or the object transformed from the entity.
     */
    public Object get(int transform, Integer id);

    /**
     * Loads an instance of VesselFeatures from the persistent store.
     * @param id
     * @return VesselFeatures
     */
    public VesselFeatures load(Integer id);

    /**
     * <p>
     * Does the same thing as {@link #load(Integer)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined in this class then the result <strong>WILL BE</strong> passed through an operation which can
     * optionally transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform flag to determine transformation type.
     * @param id the identifier of the entity to load.
     * @return either the entity or the object transformed from the entity.
     */
    public Object load(int transform, Integer id);

    /**
     * Loads all entities of type {@link VesselFeatures}.
     *
     * @return the loaded entities.
     */
    public Collection<VesselFeatures> loadAll();

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform);

    /**
     * <p>
     * Does the same thing as {@link #loadAll()} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int pageNumber, final int pageSize);

    /**
     * <p>
     * Does the same thing as {@link #loadAll(int)} with an
     * additional two arguments called <code>pageNumber</code> and <code>pageSize</code>. The <code>pageNumber</code>
     * argument allows you to specify the page number when you are paging the results and the pageSize allows you to specify the size of the
     * page retrieved.
     * </p>
     *
     * @param transform the flag indicating what transformation to use.
     * @param pageNumber the page number to retrieve when paging results.
     * @param pageSize the size of the page to retrieve when paging results.
     * @return the loaded entities.
     */
    public Collection<?> loadAll(final int transform, final int pageNumber, final int pageSize);

    /**
     * Creates an instance of VesselFeatures and adds it to the persistent store.
     * @param vesselFeatures
     * @return VesselFeatures
     */
    public VesselFeatures create(VesselFeatures vesselFeatures);

    /**
     * <p>
     * Does the same thing as {@link #create(VesselFeatures)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param vesselFeatures
     * @return Object
     */
    public Object create(int transform, VesselFeatures vesselFeatures);

    /**
     * Creates a new instance of VesselFeatures and adds
     * from the passed in <code>entities</code> collection
     *
     * @param entities the collection of VesselFeatures
     * instances to create.
     *
     * @return the created instances.
     */
    public Collection<VesselFeatures> create(Collection<VesselFeatures> entities);

    /**
     * <p>
     * Does the same thing as {@link #create(VesselFeatures)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param entities
     * @return Collection
     */
    public Collection<?> create(int transform, Collection<VesselFeatures> entities);

    /**
     * <p>
     * Creates a new <code>VesselFeatures</code>
     * instance from <strong>all</strong> attributes and adds it to
     * the persistent store.
     * </p>
     * @param startDateTime Date de début de validité des caractéristiques navires.
     * @param endDateTime Date de fin de validité des caractéristiques navires.
     * @param name Nom du navire pour la période début-fin
     * @param exteriorMarking Marquage extérieur.
par exemple : "BR 101717"
     * @param administrativePower Puissance principale administrative (en Kw) du navire pour la période début-fin.
Selon le règlement (CEE) no 2930/86
     * @param auxiliaryPower Puissance auxiliaire en kW.
Reprend toute puissance installée non comprise sous la rubrique Puissance administrative
     * @param grossTonnageGT Tonnage GT (Gross Tonnage), exprimé en UMS (Universal Measurement System), et multiplié par 100.
Il s'agit d'un tonnage reconnu internationnellement.
La France s'est engagé à fournir un tonnage GT pour tous les navires de plus de 24m, par application
du Décret N°725 du 10 août 1982.
------
Jauge GT ou Gross Tonnage en accord avec la Convention internationale de 1969 (règlement de Londres,
International Convention on Tonnage Measurement of Ships, London, 1969 (in use since 1996) for
vessels >= 15m"
Par décret n° 82-725 du 10 août 1982, publié au Journal officiel du 20 août 1982, la Convention
internationale de 1969 sur le jaugeage des navires est entrée en vigueur en France le 18 juillet
1982. Le règlement de jaugeage annexé à cette convention conclue à Londres le 23 juin 1969 devient
règlement international. La jauge, de Londres comprend la jauge brute et la jauge nette et doit être
calculée selon les règles énoncées par la convention internationale de 1969 sur le jaugeage des
navires. La jauge brute est obtenue à partir des mesures pratiquées sur tous les espaces fermés d'un
navire, à l'exception des espaces exclus par les règles de la convention précitée. La jauge nette
est déterminée par les dimensions des espaces réservés au fret et par le nombre des passagers.
La jauge de Londres est reprise sur le "certificat international de jaugeage des navires (1969)".
     * @param grossTonnageGRT Tonnage du navire, ou jauge Brute, exprimé en TJB (Tonnage de Jauge Brute), et multiplié par 100.
------
Tonnage (GRT) 'Gross Registered Tonnage' en accord avec la convention d'Oslo (1947) (en emploi en
France jusqu'en 1995, toujours utilisé dans certains pays).
(GRT represent the total cubic measured content of the permanently enclosed spaces of a vessel, with
some allowances or deductions for exempt spaces such as living quarters [1 gross register ton = 100
cubic feet = 2.83 cubic metres]).
     * @param lengthOverAll Longueur hors tout (Length OverAll) en cm du navire pour la période début-fin.
Définie selon le règlement (CEE) no 2930/86.
     * @param lengthBeetweenPerpendiculars Longueur entre perpendiculaires (Length Between Perpendiculars) en cm.
Définie selon le règlement (CEE) no 2930/86.
     * @param constructionYear Année de construction du navire
     * @param IRCS Indicatif radio international du navire (IRCS)
     * @param hasVMS indique si le navire dispose d'un système VMS ou non.
     * @param isFPC Indique si le navire est inscrit au fichier FPC ou non.
     * @param updateDate 
     * @return VesselFeatures
     */
    public VesselFeatures create(
        Date startDateTime,
        Date endDateTime,
        String name,
        String exteriorMarking,
        Float administrativePower,
        Float auxiliaryPower,
        Integer grossTonnageGT,
        Integer grossTonnageGRT,
        Integer lengthOverAll,
        Integer lengthBeetweenPerpendiculars,
        Integer constructionYear,
        String IRCS,
        Boolean hasVMS,
        Boolean isFPC,
        Timestamp updateDate);

    /**
     * <p>
     * Does the same thing as {@link #create(Date, Date, String, String, Float, Float, Integer, Integer, Integer, Integer, Integer, String, Boolean, Boolean, Timestamp)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform
     * @param startDateTime Date de début de validité des caractéristiques navires.
     * @param endDateTime Date de fin de validité des caractéristiques navires.
     * @param name Nom du navire pour la période début-fin
     * @param exteriorMarking Marquage extérieur.
par exemple : "BR 101717"
     * @param administrativePower Puissance principale administrative (en Kw) du navire pour la période début-fin.
Selon le règlement (CEE) no 2930/86
     * @param auxiliaryPower Puissance auxiliaire en kW.
Reprend toute puissance installée non comprise sous la rubrique Puissance administrative
     * @param grossTonnageGT Tonnage GT (Gross Tonnage), exprimé en UMS (Universal Measurement System), et multiplié par 100.
Il s'agit d'un tonnage reconnu internationnellement.
La France s'est engagé à fournir un tonnage GT pour tous les navires de plus de 24m, par application
du Décret N°725 du 10 août 1982.
------
Jauge GT ou Gross Tonnage en accord avec la Convention internationale de 1969 (règlement de Londres,
International Convention on Tonnage Measurement of Ships, London, 1969 (in use since 1996) for
vessels >= 15m"
Par décret n° 82-725 du 10 août 1982, publié au Journal officiel du 20 août 1982, la Convention
internationale de 1969 sur le jaugeage des navires est entrée en vigueur en France le 18 juillet
1982. Le règlement de jaugeage annexé à cette convention conclue à Londres le 23 juin 1969 devient
règlement international. La jauge, de Londres comprend la jauge brute et la jauge nette et doit être
calculée selon les règles énoncées par la convention internationale de 1969 sur le jaugeage des
navires. La jauge brute est obtenue à partir des mesures pratiquées sur tous les espaces fermés d'un
navire, à l'exception des espaces exclus par les règles de la convention précitée. La jauge nette
est déterminée par les dimensions des espaces réservés au fret et par le nombre des passagers.
La jauge de Londres est reprise sur le "certificat international de jaugeage des navires (1969)".
     * @param grossTonnageGRT Tonnage du navire, ou jauge Brute, exprimé en TJB (Tonnage de Jauge Brute), et multiplié par 100.
------
Tonnage (GRT) 'Gross Registered Tonnage' en accord avec la convention d'Oslo (1947) (en emploi en
France jusqu'en 1995, toujours utilisé dans certains pays).
(GRT represent the total cubic measured content of the permanently enclosed spaces of a vessel, with
some allowances or deductions for exempt spaces such as living quarters [1 gross register ton = 100
cubic feet = 2.83 cubic metres]).
     * @param lengthOverAll Longueur hors tout (Length OverAll) en cm du navire pour la période début-fin.
Définie selon le règlement (CEE) no 2930/86.
     * @param lengthBeetweenPerpendiculars Longueur entre perpendiculaires (Length Between Perpendiculars) en cm.
Définie selon le règlement (CEE) no 2930/86.
     * @param constructionYear Année de construction du navire
     * @param IRCS Indicatif radio international du navire (IRCS)
     * @param hasVMS indique si le navire dispose d'un système VMS ou non.
     * @param isFPC Indique si le navire est inscrit au fichier FPC ou non.
     * @param updateDate 
     * @return VesselFeatures
     */
    public Object create(
        int transform,
        Date startDateTime,
        Date endDateTime,
        String name,
        String exteriorMarking,
        Float administrativePower,
        Float auxiliaryPower,
        Integer grossTonnageGT,
        Integer grossTonnageGRT,
        Integer lengthOverAll,
        Integer lengthBeetweenPerpendiculars,
        Integer constructionYear,
        String IRCS,
        Boolean hasVMS,
        Boolean isFPC,
        Timestamp updateDate);

    /**
     * <p>
     * Creates a new <code>VesselFeatures</code>
     * instance from only <strong>required</strong> properties (attributes
     * and association ends) and adds it to the persistent store.
     * </p>
     * @param isFPC
     * @param startDateTime
     * @param vessel
     * @return VesselFeatures
     */
    public VesselFeatures create(
        Boolean isFPC,
        Date startDateTime,
        Vessel vessel);

    /**
     * <p>
     * Does the same thing as {@link #create(Date, Boolean)} with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * the returned entity will <strong>NOT</strong> be transformed. If this flag is any of the other constants
     * defined here then the result <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entity (into a value object for example). By default, transformation does
     * not occur.
     * </p>
     * @param transform flag to determine transformation type.
     * @param isFPC
     * @param startDateTime
     * @param vessel
     * @return Object
     */
    public Object create(
        int transform,
        Boolean isFPC,
        Date startDateTime,
        Vessel vessel);

    /**
     * Updates the <code>vesselFeatures</code> instance in the persistent store.
     * @param vesselFeatures
     */
    public void update(VesselFeatures vesselFeatures);

    /**
     * Updates all instances in the <code>entities</code> collection in the persistent store.
     * @param entities
     */
    public void update(Collection<VesselFeatures> entities);

    /**
     * Removes the instance of VesselFeatures from the persistent store.
     * @param vesselFeatures
     */
    public void remove(VesselFeatures vesselFeatures);

    /**
     * Removes the instance of VesselFeatures having the given
     * <code>identifier</code> from the persistent store.
     * @param id
     */
    public void remove(Integer id);

    /**
     * Removes all entities in the given <code>entities</code> collection.
     * @param entities
     */
    public void remove(Collection<VesselFeatures> entities);


    /**
     * Does the same thing as {@link #search(int, Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param transform the transformation flag.
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int transform, final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional two flags called <code>pageNumber</code> and <code>pageSize</code>. These flags allow you to
     * limit your data to a specified page number and size.
     *
     * @param pageNumber the page number in the data to retrieve
     * @param pageSize the size of the page to retrieve.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search wrapped in a {@link PaginationResult} instance.
     */
    public PaginationResult search(final int pageNumber, final int pageSize, final Search search);

    /**
     * Does the same thing as {@link #search(Search)} but with an
     * additional flag called <code>transform</code>. If this flag is set to <code>TRANSFORM_NONE</code> then
     * finder results will <strong>NOT</strong> be transformed during retrieval.
     * If this flag is any of the other constants defined here
     * then results <strong>WILL BE</strong> passed through an operation which can optionally
     * transform the entities (into value objects for example). By default, transformation does
     * not occur.
     *
     * @param transform the transformation flag.
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<?> search(final int transform, final Search search);

    /**
     * Performs a search using the parameters specified in the given <code>search</code> object.
     *
     * @param search the search object which provides the search parameters and pagination specification.
     * @return any found results from the search.
     */
    public Set<VesselFeatures> search(final Search search);

    /**
     * Allows transformation of entities into value objects
     * (or something else for that matter), when the <code>transform</code>
     * flag is set to one of the constants defined in <code>fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesDao</code>, please note
     * that the {@link #TRANSFORM_NONE} constant denotes no transformation, so the entity itself
     * will be returned.
     *
     * If the integer argument value is unknown {@link #TRANSFORM_NONE} is assumed.
     *
     * @param transform one of the constants declared in {@link fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesDao}
     * @param entity an entity that was found
     * @return the transformed entity (i.e. new value object, etc)
     * @see #transformEntities(int,Collection)
     */
    public Object transformEntity(final int transform, final VesselFeatures entity);

    /**
     * Transforms a collection of entities using the
     * {@link #transformEntity(int,VesselFeatures)}
     * method. This method does not instantiate a new collection.
     * <p>
     * This method is to be used internally only.
     *
     * @param transform one of the constants declared in <code>fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesDao</code>
     * @param entities the collection of entities to transform
     * @see #transformEntity(int,VesselFeatures)
     */
    public void transformEntities(final int transform, final Collection<?> entities);

    // spring-dao merge-point
}