/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionChainResult;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.Unchainable;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChainingInterceptor.class);
    private static final String ACTION_ERRORS = "actionErrors";
    private static final String FIELD_ERRORS = "fieldErrors";
    private static final String ACTION_MESSAGES = "actionMessages";
    private boolean copyMessages = false;
    private boolean copyErrors = false;
    private boolean copyFieldErrors = false;
    protected Collection<String> excludes;
    protected Collection<String> includes;
    protected ReflectionProvider reflectionProvider;

    @Inject
    public void setReflectionProvider(ReflectionProvider prov) {
        this.reflectionProvider = prov;
    }

    @Inject(value="struts.xwork.chaining.copyErrors", required=false)
    public void setCopyErrors(String copyErrors) {
        this.copyErrors = "true".equalsIgnoreCase(copyErrors);
    }

    @Inject(value="struts.xwork.chaining.copyFieldErrors", required=false)
    public void setCopyFieldErrors(String copyFieldErrors) {
        this.copyFieldErrors = "true".equalsIgnoreCase(copyFieldErrors);
    }

    @Inject(value="struts.xwork.chaining.copyMessages", required=false)
    public void setCopyMessages(String copyMessages) {
        this.copyMessages = "true".equalsIgnoreCase(copyMessages);
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        ValueStack stack = invocation.getStack();
        CompoundRoot root = stack.getRoot();
        if (this.shouldCopyStack(invocation, root)) {
            this.copyStack(invocation, root);
        }
        return invocation.invoke();
    }

    private void copyStack(ActionInvocation invocation, CompoundRoot root) {
        List list = this.prepareList(root);
        Map<String, Object> ctxMap = invocation.getInvocationContext().getContextMap();
        for (Object object : list) {
            if (!this.shouldCopy(object)) continue;
            this.reflectionProvider.copy(object, invocation.getAction(), ctxMap, this.prepareExcludes(), this.includes);
        }
    }

    private Collection<String> prepareExcludes() {
        Collection<String> localExcludes = this.excludes;
        if (!(this.copyErrors && this.copyMessages && this.copyFieldErrors || localExcludes != null)) {
            localExcludes = new HashSet<String>();
            if (!this.copyErrors) {
                localExcludes.add(ACTION_ERRORS);
            }
            if (!this.copyMessages) {
                localExcludes.add(ACTION_MESSAGES);
            }
            if (!this.copyFieldErrors) {
                localExcludes.add(FIELD_ERRORS);
            }
        }
        return localExcludes;
    }

    private boolean shouldCopy(Object o) {
        return o != null && !(o instanceof Unchainable);
    }

    private List prepareList(CompoundRoot root) {
        ArrayList list = new ArrayList(root);
        list.remove(0);
        Collections.reverse(list);
        return list;
    }

    private boolean shouldCopyStack(ActionInvocation invocation, CompoundRoot root) throws Exception {
        Result result = invocation.getResult();
        return root.size() > 1 && (result == null || ActionChainResult.class.isAssignableFrom(result.getClass()));
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes = excludes;
    }

    public Collection<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection<String> includes) {
        this.includes = includes;
    }
}

