/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public class CalcifiedPiecesSamplingEditorTableModel
extends AbstractApplicationTableModel<CalcifiedPiecesSamplingEditorRowModel> {
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> SPECIES = ColumnIdentifier.newId((String)"protocolSpecies", (String)I18n.n((String)"tutti.editCps.table.header.species.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.species.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> MATURITY = ColumnIdentifier.newId((String)"maturity", (String)I18n.n((String)"tutti.editCps.table.header.maturity.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.maturity.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> SEX = ColumnIdentifier.newId((String)"sex", (String)I18n.n((String)"tutti.editCps.table.header.sex.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.sex.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> MIN_SIZE = ColumnIdentifier.newId((String)"minSize", (String)I18n.n((String)"tutti.editCps.table.header.minSize.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.minSize.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> MAX_SIZE = ColumnIdentifier.newId((String)"maxSize", (String)I18n.n((String)"tutti.editCps.table.header.maxSize.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.maxSize.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> MAX_BY_LENGHT_STEP = ColumnIdentifier.newId((String)"maxByLenghtStep", (String)I18n.n((String)"tutti.editCps.table.header.maxByLengthStep.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.maxByLengthStep.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> SAMPLING_INTERVAL = ColumnIdentifier.newId((String)"samplingInterval", (String)I18n.n((String)"tutti.editCps.table.header.samplingInterval.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.samplingInterval.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> OPERATION_LIMITATION = ColumnIdentifier.newId((String)"operationLimitation", (String)I18n.n((String)"tutti.editCps.table.header.operationLimitation.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.operationLimitation.field.tip", (Object[])new Object[0]));
    public static final ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> ZONE_LIMITATION = ColumnIdentifier.newId((String)"zoneLimitation", (String)I18n.n((String)"tutti.editCps.table.header.zoneLimitation.field", (Object[])new Object[0]), (String)I18n.n((String)"tutti.editCps.table.header.zoneLimitation.field.tip", (Object[])new Object[0]));

    public CalcifiedPiecesSamplingEditorTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.setNoneEditableCols(new ColumnIdentifier[]{SPECIES, MAX_SIZE, MATURITY});
    }

    public CalcifiedPiecesSamplingEditorRowModel createNewRow() {
        return new CalcifiedPiecesSamplingEditorRowModel();
    }

    public CalcifiedPiecesSamplingEditorRowModel createNewRow(EditProtocolSpeciesRowModel species, Boolean maturity, boolean sex) {
        return this.createNewRow(species, maturity, sex, 0, null);
    }

    public CalcifiedPiecesSamplingEditorRowModel createNewRow(EditProtocolSpeciesRowModel species, Boolean maturity, boolean sex, Integer minSize, Integer maxSize) {
        CalcifiedPiecesSamplingEditorRowModel newRow = this.createNewRow();
        newRow.setValid(true);
        newRow.setProtocolSpecies(species);
        newRow.setMaturity(maturity);
        newRow.setSex(sex);
        newRow.setMinSize(minSize);
        newRow.setMaxSize(maxSize);
        newRow.setMaxByLenghtStep(0);
        newRow.setSamplingInterval(0);
        newRow.setOperationLimitation(0);
        newRow.setZoneLimitation(0);
        return newRow;
    }

    public List<EditProtocolSpeciesRowModel> getSpeciesList() {
        ArrayList result = Lists.newArrayList();
        for (CalcifiedPiecesSamplingEditorRowModel row : this.rows) {
            result.add(row.getProtocolSpecies());
        }
        return result;
    }

    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<CalcifiedPiecesSamplingEditorRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result && MIN_SIZE.equals(propertyName)) {
            int minSize = (Integer)this.getValueAt(rowIndex, columnIndex);
            result = minSize > 0;
        }
        return result;
    }

    public boolean isSpeciesOrderEven(int rowIndex) {
        int nbSpecies;
        CalcifiedPiecesSamplingEditorRowModel selectedRow = (CalcifiedPiecesSamplingEditorRowModel)this.getEntry(rowIndex);
        Integer selectedSpeciesReferenceTaxonId = selectedRow.getProtocolSpecies().getSpeciesReferenceTaxonId();
        LinkedHashSet<Integer> speciesReferenceTaxonIds = new LinkedHashSet<Integer>();
        for (CalcifiedPiecesSamplingEditorRowModel row : this.rows) {
            Integer speciesReferenceTaxonId = row.getProtocolSpecies().getSpeciesReferenceTaxonId();
            speciesReferenceTaxonIds.add(speciesReferenceTaxonId);
            if (!Objects.equals(selectedSpeciesReferenceTaxonId, speciesReferenceTaxonId)) continue;
            break;
        }
        return (nbSpecies = speciesReferenceTaxonIds.size()) == 0 || (nbSpecies + 1) % 2 == 0;
    }
}

