/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.cps;

import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.sampling.CacheExtractedKey;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class SamplingNumberRowModel
extends AbstractTuttiImportExportModel<CacheExtractedKey> {
    public SamplingNumberRowModel(char separator, final Decorator<Species> speciesCodeDecorator) {
        super(separator);
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.surveyCode", (Object[])new Object[0]), "species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species species) {
                return speciesCodeDecorator.toString((Object)species);
            }
        });
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.geniusName", (Object[])new Object[0]), "species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species species) {
                return species.getName();
            }
        });
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.lengthStep", (Object[])new Object[0]), "lengthStep", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.maturity", (Object[])new Object[0]), "maturity", (ValueFormatter)new ValueFormatter<Boolean>(){

            public String format(Boolean maturity) {
                if (maturity == null) {
                    return "";
                }
                return maturity != false ? I18n.t((String)"tutti.maturity.mature", (Object[])new Object[0]) : I18n.t((String)"tutti.maturity.immature", (Object[])new Object[0]);
            }
        });
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.gender", (Object[])new Object[0]), "sex", (ValueFormatter)new ValueFormatter<CaracteristicQualitativeValue>(){

            public String format(CaracteristicQualitativeValue value) {
                return value == null ? "" : I18n.t((String)value.getDescription(), (Object[])new Object[0]);
            }
        });
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.samplingNb", (Object[])new Object[0]), "samplingNb", (ValueFormatter)TuttiCsvUtil.PRIMITIVE_INTEGER);
        this.newColumnForExport(I18n.t((String)"tutti.service.calcifiedPiecesSamplingReport.header.maxByLengthStep", (Object[])new Object[0]), "maxByLengthStep", (ValueFormatter)TuttiCsvUtil.INTEGER);
    }

    public CacheExtractedKey newEmptyInstance() {
        return new CacheExtractedKey();
    }
}

