/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryPersonService;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportExistingTemporaryPersonAction
extends LongActionSupport<ManageTemporaryReferentialUIModel, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ExportExistingTemporaryPersonAction.class);
    private File file;

    public ExportExistingTemporaryPersonAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction;
        boolean bl = doAction = super.prepareAction() && ((ManageTemporaryReferentialUI)this.getUI()).getExportExistingPersonButton().isEnabled();
        if (doAction) {
            this.file = this.saveFile("exportTemporaryPerson", "csv", I18n.t((String)"tutti.manageTemporaryReferential.title.choose.exportExistingTemporaryPersonFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseExistingReferentialPersonFile.export", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export existing persons temporary referential to file: " + this.file));
        }
        ReferentialTemporaryPersonService service = this.getContext().getReferentialTemporaryPersonService();
        service.exportExistingTemporaryPerson(this.file);
    }

    public void postSuccessAction() {
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetComboBoxAction(((ManageTemporaryReferentialUI)this.getUI()).getPersonActionComboBox());
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseExistingReferentialPersonFile.export.success", (Object[])new Object[]{this.file}));
    }
}

