/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.Daos;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorUtils;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadataLoader;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public class SynchroDatabaseMetadata
implements SynchroTableMetadataLoader,
Closeable {
    private static final Log log = LogFactory.getLog(SynchroDatabaseMetadata.class);
    private static final String TABLE_CATALOG_PATTERN = "TABLE_CAT";
    private static final String TABLE_TYPE_PATTERN = "TABLE_TYPE";
    private static final String TABLE_SCHEMA_PATTERN = "TABLE_SCHEM";
    private static final String REMARKS_PATTERN = "REMARKS";
    private static final String TABLE_NAME_PATTERN = "TABLE_NAME";
    protected DatabaseMetadata hibernateMeta;
    protected DatabaseMetaData jdbcMeta;
    protected final Map<String, SynchroTableMetadata> tables;
    protected final SynchroDatabaseConfiguration config;
    protected final Set<String> sequences;
    protected final String[] types;
    protected SQLExceptionConverter sqlExceptionConverter;
    protected List<SynchroInterceptor> interceptors;
    protected List<Object> otherListeners;
    protected Predicate<SynchroColumnMetadata> columnFilter;
    protected boolean isClosed = false;

    public static SynchroDatabaseMetadata loadDatabaseMetadata(Connection connection, SynchroDatabaseConfiguration configuration, Set<String> tableNames) {
        SynchroDatabaseMetadata meta = new SynchroDatabaseMetadata(connection, configuration);
        meta.prepare(tableNames);
        return meta;
    }

    public static SynchroDatabaseMetadata loadDatabaseMetadata(Connection connection, SynchroDatabaseConfiguration configuration) {
        SynchroDatabaseMetadata meta = new SynchroDatabaseMetadata(connection, configuration);
        return meta;
    }

    public SynchroDatabaseMetadata(Connection connection, SynchroDatabaseConfiguration config) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)config);
        this.config = config;
        this.interceptors = this.initInterceptors(config);
        this.otherListeners = Lists.newArrayList();
        this.sqlExceptionConverter = Daos.newSQLExceptionConverter(config.getDialect());
        this.columnFilter = SynchroMetadataUtils.newExcludeColumnPredicate(config.getColumnExcludesAsSet());
        this.tables = Maps.newTreeMap();
        try {
            this.hibernateMeta = this.initHibernateDatabaseMetadata(connection, config, this.sqlExceptionConverter);
            this.sequences = this.initSequences(connection, config.getDialect());
            Field typesField = DatabaseMetadata.class.getDeclaredField("types");
            typesField.setAccessible(true);
            this.types = (String[])typesField.get(this.hibernateMeta);
            this.jdbcMeta = connection.getMetaData();
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.synchro.meta.db.instanciation.error", (Object[])new Object[]{config.getUrl()}), e);
        }
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public SynchroDatabaseConfiguration getConfiguration() {
        return this.config;
    }

    public Dialect getDialect() {
        return this.config.getDialect();
    }

    public int getInExpressionCountLimit() {
        return this.config.getDialect().getInExpressionCountLimit();
    }

    public boolean isSequence(String tableName) {
        String[] strings = StringHelper.split((String)".", (String)tableName);
        return this.sequences.contains(StringHelper.toLowerCase((String)strings[strings.length - 1]));
    }

    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.jdbcMeta.getConnection();
    }

    @Override
    public void close() {
        this.interceptors = null;
        this.otherListeners = null;
        this.sqlExceptionConverter = null;
        this.jdbcMeta = null;
        this.hibernateMeta = null;
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void prepare(Set<String> tableNames) {
        Object tablePattern;
        this.checkNotClosed();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(tableNames), (Object)"'tableNames' must be set and not empty");
        boolean enableFilter = false;
        Iterator<String> iterator = tableNames.iterator();
        while (iterator.hasNext() && !(enableFilter = ((String)(tablePattern = iterator.next())).contains("%"))) {
        }
        Set<String> filteredTableNames = tableNames;
        if (enableFilter) {
            filteredTableNames = this.getTableNames(tableNames, null);
        }
        for (String tableName : filteredTableNames) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load metas of table: " + tableName));
            }
            this.getTableBeforeBuild(tableName);
        }
        HashMap tablesByNames = Maps.newHashMap();
        for (SynchroTableMetadata table : this.tables.values()) {
            if (this.config.isFullMetadataEnable()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Load joins of table: " + table.getName()));
                }
                table.initJoins(this);
            }
            table.build();
            tablesByNames.put(table.getName(), table);
        }
    }

    public void unloadTables() {
        this.tables.clear();
    }

    @Override
    public SynchroTableMetadata getTable(String name) throws HibernateException {
        SynchroTableMetadata result = this.getLoadedTable(name);
        if (result != null) {
            return result;
        }
        result = this.getTableBeforeBuild(name).build();
        return result;
    }

    public SynchroTableMetadata getLoadedTable(String name) throws HibernateException {
        String defaultSchema = ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.config.getProperties());
        String defaultCatalog = ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.config.getProperties());
        return this.getLoadedTable(name, defaultSchema, defaultCatalog);
    }

    public SynchroTableMetadata getLoadedTable(String name, String schema, String catalog) throws HibernateException {
        String key = Table.qualify((String)catalog, (String)schema, (String)name).toLowerCase();
        return this.tables.get(key);
    }

    public Set<String> getTableNames(Predicate<String> tableFilter) {
        return this.getTableNames(Sets.newHashSet((Object[])new String[]{"%"}), tableFilter);
    }

    public Set<String> getTableNames(Set<String> tablePatterns, Predicate<String> tableFilter) {
        this.checkNotClosed();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(tablePatterns));
        HashSet tablenames = Sets.newHashSet();
        String defaultSchema = ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.config.getProperties());
        String defaultCatalog = ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.config.getProperties());
        String[] types = null;
        types = this.config != null && ConfigurationHelper.getBoolean((String)"hibernate.synonyms", (Map)this.config.getProperties(), (boolean)false) ? new String[]{"TABLE", "VIEW", "SYNONYM"} : new String[]{"TABLE", "VIEW"};
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting table names, using filter");
            }
            for (String tablePattern : tablePatterns) {
                rs = this.jdbcMeta.getTables(defaultCatalog, defaultSchema, tablePattern, types);
                while (rs.next()) {
                    String tableName = rs.getString(TABLE_NAME_PATTERN);
                    if (this.hibernateMeta.isSequence((Object)tableName) || tableFilter != null && !tableFilter.apply((Object)tableName)) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(" TABLE_CAT=" + rs.getString(TABLE_CATALOG_PATTERN) + " " + TABLE_SCHEMA_PATTERN + "=" + rs.getString(TABLE_SCHEMA_PATTERN) + " " + TABLE_NAME_PATTERN + "=" + rs.getString(TABLE_NAME_PATTERN) + " " + TABLE_TYPE_PATTERN + "=" + rs.getString(TABLE_TYPE_PATTERN) + " " + REMARKS_PATTERN + "=" + rs.getString(REMARKS_PATTERN)));
                    }
                    tablenames.add(tableName);
                }
            }
        }
        catch (SQLException e) {
            throw this.sqlExceptionConverter.convert(e, "Retrieving database table names", "n/a");
        }
        finally {
            Daos.closeSilently(rs);
        }
        return tablenames;
    }

    public Set<String> getLoadedRootTableNames() {
        LinkedHashSet tablenames = Sets.newLinkedHashSet();
        for (SynchroTableMetadata table : this.tables.values()) {
            if (!table.isRoot()) continue;
            tablenames.add(table.getName());
        }
        return tablenames;
    }

    public Set<String> getLoadedTableNames() {
        LinkedHashSet tablenames = Sets.newLinkedHashSet();
        for (SynchroTableMetadata table : this.tables.values()) {
            tablenames.add(table.getName());
        }
        return tablenames;
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkNotClosed();
        return this.jdbcMeta.getExportedKeys(catalog, schema, table);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.checkNotClosed();
        return this.jdbcMeta.getImportedKeys(catalog, schema, table);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkNotClosed();
        return this.jdbcMeta.getPrimaryKeys(catalog, schema, table);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkNotClosed();
        return this.jdbcMeta.getIndexInfo(catalog, schema, table, unique, approximate);
    }

    public Set<String> getSequences() {
        return this.sequences;
    }

    public void register(Object listener) {
        this.checkNotClosed();
        if (listener instanceof SynchroInterceptor) {
            this.interceptors.add((SynchroInterceptor)listener);
        } else {
            this.otherListeners.add(listener);
        }
    }

    public void unregister(Object listener) {
        this.checkNotClosed();
        if (listener instanceof SynchroInterceptor) {
            this.interceptors.remove((SynchroInterceptor)listener);
        } else {
            this.otherListeners.remove(listener);
        }
    }

    protected List<SynchroInterceptor> initInterceptors(SynchroDatabaseConfiguration config) {
        List<SynchroInterceptor> interceptors = SynchroInterceptorUtils.load(SynchroInterceptor.class);
        interceptors = SynchroInterceptorUtils.filter(interceptors, config);
        return interceptors;
    }

    protected SynchroTableMetadata getTableBeforeBuild(String name) throws HibernateException {
        String defaultSchema = ConfigurationHelper.getString((String)"hibernate.default_schema", (Map)this.config.getProperties());
        String defaultCatalog = ConfigurationHelper.getString((String)"hibernate.default_catalog", (Map)this.config.getProperties());
        SynchroTableMetadata table = this.getTableBeforeBuild(name, defaultSchema, defaultCatalog, false);
        return table;
    }

    protected SynchroTableMetadata getTableBeforeBuild(String name, String schema, String catalog, boolean isQuoted) throws HibernateException {
        this.checkNotClosed();
        String key = Table.qualify((String)catalog, (String)schema, (String)name).toLowerCase();
        SynchroTableMetadata synchroTableMetadata = this.tables.get(key);
        if (synchroTableMetadata == null) {
            TableMetadata tableMetadata = this.hibernateMeta.getTableMetadata(name.toLowerCase(), schema, catalog, isQuoted);
            Preconditions.checkNotNull((Object)tableMetadata, (Object)String.format("Could not find db table '%s' (schema=%s, catalog=%s)", name, schema, catalog));
            boolean enableFullMetadata = this.getConfiguration().isFullMetadataEnable();
            List<Object> listeners = enableFullMetadata ? this.getListeners(tableMetadata) : null;
            synchroTableMetadata = new SynchroTableMetadata(this, tableMetadata, this.getDialect(), listeners, name, this.columnFilter, enableFullMetadata);
            Preconditions.checkNotNull((Object)synchroTableMetadata, (Object)("Could not load metadata for table: " + name));
            this.tables.put(key, synchroTableMetadata);
        }
        return synchroTableMetadata;
    }

    protected DatabaseMetadata initHibernateDatabaseMetadata(Connection connection, SynchroDatabaseConfiguration configuration, SQLExceptionConverter sqlExceptionConverter) throws SQLException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Configuration hibernateConfiguration = new Configuration().setProperties(configuration.getProperties());
        DatabaseMetadata hibernateMeta = new DatabaseMetadata(connection, configuration.getDialect(), hibernateConfiguration, true);
        Field sqlExceptionConverterField = DatabaseMetadata.class.getDeclaredField("sqlExceptionConverter");
        sqlExceptionConverterField.setAccessible(true);
        sqlExceptionConverterField.set(hibernateMeta, sqlExceptionConverter);
        return hibernateMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> initSequences(Connection connection, Dialect dialect) throws SQLException {
        String sql;
        HashSet sequences = Sets.newHashSet();
        if (dialect.supportsSequences() && (sql = dialect.getQuerySequencesString()) != null) {
            Statement statement = null;
            ResultSet rs = null;
            try {
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    sequences.add(StringHelper.toLowerCase((String)rs.getString(1)).trim());
                }
            }
            finally {
                rs.close();
                statement.close();
            }
        }
        return sequences;
    }

    protected List<Object> getListeners(TableMetadata table) {
        List<SynchroInterceptor> filteredInterceptors = SynchroInterceptorUtils.filter(this.interceptors, this, table);
        ArrayList listeners = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(filteredInterceptors)) {
            listeners.addAll(filteredInterceptors);
        }
        if (CollectionUtils.isNotEmpty(this.otherListeners)) {
            listeners.addAll(this.otherListeners);
        }
        return listeners;
    }

    protected void checkNotClosed() {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"This object is closed");
    }
}

