/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.datatools.connectivity.oda.flatfile.InvalidResourceException;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceInputStream;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public final class ResourceLocator {
    public static ResourceInputStream getResourceInputStream(String homeFolder, String table, String fileURI, Object resourceIdentifiers) throws InvalidResourceException {
        if (homeFolder == null && fileURI == null) {
            throw new InvalidResourceException(2, Messages.getString("connection_MISSING_FILELLOCATION"));
        }
        ResourceInputStream stream = ResourceLocator.getResourceInputStream(fileURI, resourceIdentifiers);
        if (stream != null) {
            return stream;
        }
        if (homeFolder == null) {
            throw new InvalidResourceException(1, MessageFormat.format((String)Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_URI"), (Object[])new Object[]{fileURI}));
        }
        stream = ResourceLocator.getResourceInputStream(homeFolder, table, resourceIdentifiers);
        return stream;
    }

    public static void validate(String homeFolder, String table, String fileURI, ResourceIdentifiers resourceIdentifiers) throws InvalidResourceException {
        ResourceInputStream in = null;
        try {
            in = ResourceLocator.getResourceInputStream(homeFolder, table, fileURI, resourceIdentifiers);
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static ResourceInputStream getResourceInputStream(String homeFolder, String table, Object resourceIdentifiers) throws InvalidResourceException {
        ResourceInputStream stream = null;
        if (homeFolder != null) {
            File homeFolderFile = ResourceLocator.getHomeFolderFile(homeFolder, resourceIdentifiers);
            if (table == null || homeFolderFile == null) {
                return null;
            }
            File file = new File(homeFolderFile, table.trim());
            File homeFile = new File(homeFolder);
            String filePath = String.valueOf(homeFolder) + File.separator + table;
            if (!homeFile.isAbsolute()) {
                filePath = homeFolder.endsWith("/") ? String.valueOf(homeFolder) + table : String.valueOf(homeFolder) + "/" + table;
            }
            if (!file.exists()) {
                throw new InvalidResourceException(1, String.valueOf(Messages.getString("query_invalidTableName")) + filePath);
            }
            try {
                stream = new ResourceInputStream(new FileInputStream(file), file.getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidResourceException(1, String.valueOf(Messages.getString("query_invalidTableName")) + filePath);
            }
        }
        return stream;
    }

    public static File getHomeFolderFile(String homeFolder, Object resourceIdentifiers) throws InvalidResourceException {
        if (homeFolder != null) {
            URI uri;
            block9: {
                try {
                    uri = null;
                    File file = new File(homeFolder);
                    if (file.exists() && file.isAbsolute()) {
                        return file;
                    }
                    try {
                        uri = new URI(homeFolder);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uri = new URI(null, null, ResourceLocator.convertURI(homeFolder), null);
                    }
                    if (uri.isAbsolute()) break block9;
                    if (!uri.isAbsolute() && resourceIdentifiers != null) {
                        URI uriResolved = ResourceIdentifiers.resolveApplResource((Object)resourceIdentifiers, (URI)uri);
                        uri = uriResolved == null ? uri : uriResolved;
                        break block9;
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new InvalidResourceException(1, MessageFormat.format((String)Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_URI"), (Object[])new Object[]{homeFolder, e}));
                }
            }
            File homeFile = new File(FileLocator.toFileURL((URL)uri.toURL()).toURI());
            if (homeFile.exists() && homeFile.isDirectory()) {
                return homeFile;
            }
        }
        return null;
    }

    public static ResourceInputStream getResourceInputStream(String fileURI, Object resourceIdentifiers) throws InvalidResourceException {
        ResourceInputStream stream = null;
        if (fileURI != null) {
            URI uri;
            block8: {
                try {
                    uri = null;
                    File file = new File(fileURI);
                    if (file.exists()) {
                        uri = file.toURI();
                        break block8;
                    }
                    try {
                        uri = new URI(fileURI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uri = new URI(null, null, ResourceLocator.convertURI(fileURI), null);
                    }
                    if (uri.isAbsolute()) break block8;
                    if (!uri.isAbsolute() && resourceIdentifiers != null) {
                        URI uriResolved = ResourceIdentifiers.resolveApplResource((Object)resourceIdentifiers, (URI)uri);
                        uri = uriResolved == null ? uri : uriResolved;
                        break block8;
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new InvalidResourceException(1, MessageFormat.format((String)Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_URI"), (Object[])new Object[]{fileURI, e}));
                }
            }
            stream = new ResourceInputStream(uri.toURL().openStream(), fileURI);
        }
        return stream;
    }

    private static String convertURI(String fileURL) {
        return fileURL.replace('\\', '/');
    }

    public static void validateFileURI(String fileURI, ResourceIdentifiers ri) throws InvalidResourceException {
        if (fileURI == null) {
            throw new InvalidResourceException(2, Messages.getString("connection_MISSING_FILEURI"));
        }
        ResourceInputStream stream = null;
        try {
            stream = ResourceLocator.getResourceInputStream(fileURI, ri);
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void validateHomeFolder(String homeFolder, ResourceIdentifiers ri) throws InvalidResourceException {
        if (homeFolder == null) {
            throw new InvalidResourceException(2, Messages.getString("connection_MISSING_HOMEFOLDER"));
        }
        File file = ResourceLocator.getHomeFolderFile(homeFolder, ri);
        if (file == null || !file.exists() || file.isFile()) {
            throw new InvalidResourceException(1, String.valueOf(Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_DB_DIR")) + homeFolder);
        }
    }
}

