// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.pmfm;

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Une fraction analysée est un composant du support sur lequel porte l'analyse.
 * Les fractions analysées sont généralement des fractions "organiques", au sens d'une
 * classification par partie d'un même organisme,
 * ex : foie, écaille, reins, dents, otolithe...
 * Elles peuvent aussi être un sous ensemble quelconque du support. Par exemple, dans le cas des
 * engins : le bras, …
 * Les fractions dites "systématiques", au sens d'une classification systématique (ex : poisson :
 * Cyprinidae / Cyprinus / Cyprinus carpio...) ne sont pas considérées comme des fractions au sens
 * de l'entité, mais comme une précision apportée sur l'individu. Représentées par les entités
 * "taxon" et "groupe de taxon", elles ne font pas partie de la liste des fractions analysées.
 * Etant une liste de référence, une procédure stricte pour la création de nouvelles fractions
 * analysées pourra être mise en place (On pourra s'inspirer des procédures utilisées dans
 * Quadrige2, qui utilisent le référentiel national du SANDRE).
 * Nombre de lignes : 10
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Fraction
    implements Serializable, Comparable<Fraction>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 889767786548315432L;

    // Generate 5 attributes
    private Integer id;

    /**
     * Identifiant unique de la fraction. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique de la fraction. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * Description courte de la fraction.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Description courte de la fraction.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private String description;

    /**
     * Description longue de la fraction.
     * @return this.description String
     */
    public String getDescription()
    {
        return this.description;
    }

    /**
     * Description longue de la fraction.
     * @param descriptionIn String
     */
    public void setDescription(String descriptionIn)
    {
        this.description = descriptionIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 3 associations
    private Collection<Matrix> matrixes = new HashSet<Matrix>();

    /**
     * Le support est un composant du milieu sur lequel porte l'investigation. Les supports sont,
     * par
     * exemple :
     * - un engin,
     * - la mer (ou autre environnement),
     * - bivalve (moule, huître, coque...)
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme	(oursin...)
     * - masse d'eau, eau brute
     * - eau filtrée
     * - ...
     * Le support ne correspond pas au support réellement analysé. En effet, il peut s'agir d'une
     * analyse
     * sur une fraction du support (par exemple, pour le poisson, l'otolite,… ou pour un engin, le
     * bras).
     * Nombre de lignes : 20
     * @return this.matrixes Collection<Matrix>
     */
    public Collection<Matrix> getMatrixes()
    {
        return this.matrixes;
    }

    /**
     * Le support est un composant du milieu sur lequel porte l'investigation. Les supports sont,
     * par
     * exemple :
     * - un engin,
     * - la mer (ou autre environnement),
     * - bivalve (moule, huître, coque...)
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme	(oursin...)
     * - masse d'eau, eau brute
     * - eau filtrée
     * - ...
     * Le support ne correspond pas au support réellement analysé. En effet, il peut s'agir d'une
     * analyse
     * sur une fraction du support (par exemple, pour le poisson, l'otolite,… ou pour un engin, le
     * bras).
     * Nombre de lignes : 20
     * @param matrixesIn Collection<Matrix>
     */
    public void setMatrixes(Collection<Matrix> matrixesIn)
    {
        this.matrixes = matrixesIn;
    }

    /**
     * Le support est un composant du milieu sur lequel porte l'investigation. Les supports sont,
     * par
     * exemple :
     * - un engin,
     * - la mer (ou autre environnement),
     * - bivalve (moule, huître, coque...)
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme	(oursin...)
     * - masse d'eau, eau brute
     * - eau filtrée
     * - ...
     * Le support ne correspond pas au support réellement analysé. En effet, il peut s'agir d'une
     * analyse
     * sur une fraction du support (par exemple, pour le poisson, l'otolite,… ou pour un engin, le
     * bras).
     * Nombre de lignes : 20
     * @param elementToAdd Matrix
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addMatrixes(Matrix elementToAdd)
    {
        return this.matrixes.add(elementToAdd);
    }

    /**
     * Le support est un composant du milieu sur lequel porte l'investigation. Les supports sont,
     * par
     * exemple :
     * - un engin,
     * - la mer (ou autre environnement),
     * - bivalve (moule, huître, coque...)
     * - crustacé (crevette...)
     * - poisson (merlu, sardine...)
     * - gastéropode (bigorneau, littorine...)
     * - echinoderme	(oursin...)
     * - masse d'eau, eau brute
     * - eau filtrée
     * - ...
     * Le support ne correspond pas au support réellement analysé. En effet, il peut s'agir d'une
     * analyse
     * sur une fraction du support (par exemple, pour le poisson, l'otolite,… ou pour un engin, le
     * bras).
     * Nombre de lignes : 20
     * @param elementToRemove Matrix
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeMatrixes(Matrix elementToRemove)
    {
        return this.matrixes.remove(elementToRemove);
    }

    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Fraction instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Fraction))
        {
            return false;
        }
        final Fraction that = (Fraction)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Fraction}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Fraction}.
         * @return new FractionImpl()
         */
        public static Fraction newInstance()
        {
            return new FractionImpl();
        }

        /**
         * Constructs a new instance of {@link Fraction}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param creationDate Date
         * @param status Status
         * @return newInstance
         */
        public static Fraction newInstance(String name, Date creationDate, Status status)
        {
            final Fraction entity = new FractionImpl();
            entity.setName(name);
            entity.setCreationDate(creationDate);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Fraction}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param description String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param matrixes Collection<Matrix>
         * @param status Status
         * @return newInstance Fraction
         */
        public static Fraction newInstance(String name, String description, Date creationDate, Timestamp updateDate, Collection<Matrix> matrixes, Status status)
        {
            final Fraction entity = new FractionImpl();
            entity.setName(name);
            entity.setDescription(description);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setMatrixes(matrixes);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Fraction o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getDescription() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getDescription().compareTo(o.getDescription()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Fraction.java merge-point
}