/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DaoUtils {
    private static final String JDBC_URL_PREFIX_HSQLDB = "jdbc:hsqldb:";
    private static final String JDBC_URL_PREFIX_HSQLDB_FILE = "jdbc:hsqldb:file:";
    private static final Log log = LogFactory.getLog(DaoUtils.class);
    private static final double EARTH_RADIUS = 6378288.0;
    private static final MathContext MATH_CONTEXT_4_DIGIT = new MathContext(4);
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    protected DaoUtils() {
    }

    public static Properties getConnectionProperties(String jdbcUrl, String username, String password, String schema, String dialect, String driver) {
        Properties p = new Properties();
        p.setProperty("hibernate.connection.driver_class", driver);
        p.setProperty("hibernate.dialect", dialect);
        p.setProperty("hibernate.connection.url", jdbcUrl);
        p.setProperty("hibernate.connection.username", username);
        p.setProperty("hibernate.connection.password", password);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            p.setProperty("hibernate.default_schema", schema);
        }
        p.setProperty("hibernate.synonyms", "true");
        if (jdbcUrl.startsWith("jdbc:oracle")) {
            p.setProperty("hibernatetool.metadatadialect", "org.hibernate.cfg.rveng.dialect.OracleMetaDataDialect");
        }
        return p;
    }

    public static void closeSilently(Statement statement) {
        block9: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Connection connection) {
        block3: {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not close connection, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(ResultSet statement) {
        block9: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Session session) {
        block3: {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not close session, but do not care", (Throwable)e);
            }
        }
    }

    public static Connection createConnection(Properties connectionProperties) throws SQLException {
        return DaoUtils.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    public static Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    public static void fillConnectionProperties(Properties p, String url, String username, String password) {
        p.put("hibernate.connection.url", url);
        p.put("hibernate.connection.username", username);
        p.put("hibernate.connection.password", password);
    }

    public static String getJdbcUrl(File directory, String dbName) {
        String jdbcUrl = JDBC_URL_PREFIX_HSQLDB_FILE + directory.getAbsolutePath() + "/" + dbName;
        jdbcUrl = jdbcUrl.replaceAll("\\\\", "/");
        return jdbcUrl;
    }

    public static boolean isFileDatabase(String jdbcUrl) {
        Preconditions.checkNotNull((Object)jdbcUrl);
        return jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB_FILE);
    }

    public static boolean isHsqldbDatabase(String jdbcUrl) {
        Preconditions.checkNotNull((Object)jdbcUrl);
        return jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidConnectionProperties(String jdbcDriver, String jdbcUrl, String user, String password) {
        boolean bl;
        String driverClassName = jdbcDriver;
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            DriverManager.registerDriver((Driver)driverClass.newInstance());
        }
        catch (Exception e) {
            log.error((Object)("Could not load JDBC Driver: " + e.getMessage()), (Throwable)e);
            return false;
        }
        Connection connection = null;
        try {
            connection = DaoUtils.createConnection(jdbcUrl, user, password);
            bl = true;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Could not connect to database: " + e.getMessage().trim()));
            }
            catch (Throwable throwable) {
                DaoUtils.closeSilently(connection);
                throw throwable;
            }
            DaoUtils.closeSilently(connection);
            return false;
        }
        DaoUtils.closeSilently(connection);
        return bl;
    }

    public static boolean isValidConnectionProperties(Properties connectionProperties) {
        return DaoUtils.isValidConnectionProperties(connectionProperties.getProperty("hibernate.connection.driver_class"), connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }

    public static float getRoundedLengthStep(float lengthStep, boolean aroundUp) {
        int intValue = (int)((lengthStep + (aroundUp ? 0.001f : 0.0f)) * 10.0f);
        float result = (float)intValue / 10.0f;
        return result;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(DaoUtils.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = DaoUtils.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static <N extends Number> N getValueOrComputedValue(N value, N computedValue) {
        return value == null ? computedValue : value;
    }

    public static <N extends Number> Boolean getValueOrComputedValueComputed(N value, N computedValue) {
        Boolean result = value == null ? (computedValue == null ? null : Boolean.valueOf(true)) : Boolean.valueOf(false);
        return result;
    }

    public static float roundKiloGram(float value) {
        BigDecimal sumB = new BigDecimal(value);
        float result = sumB.abs(MATH_CONTEXT_4_DIGIT).floatValue();
        return result;
    }

    public static int compareWeights(float v0, float v1) {
        float delta = (v0 = DaoUtils.roundKiloGram(v0)) - (v1 = DaoUtils.roundKiloGram(v1));
        int result = (double)delta > 1.0E-5 ? 1 : (delta < -1.0E-4f ? -1 : 0);
        return result;
    }

    public static boolean isSmallerWeight(float v0, float v1) {
        return DaoUtils.compareWeights(v0, v1) < 0;
    }

    public static boolean isGreaterWeight(float v0, float v1) {
        return DaoUtils.compareWeights(v0, v1) > 0;
    }

    public static boolean isEqualWeight(float v0, float v1) {
        return DaoUtils.compareWeights(v0, v1) == 0;
    }

    public static boolean isNotEqualWeight(float v0, float v1) {
        return DaoUtils.compareWeights(v0, v1) != 0;
    }

    public static Query withStatus(Query query) {
        query.setString("statusValidCode", AdagioConfiguration.getInstance().getStatusCodeValid());
        query.setString("statusTemporaryCode", AdagioConfiguration.getInstance().getStatusCodeTemporary());
        return query;
    }

    public static Double convertToDouble(Float floatValue) {
        if (floatValue == null) {
            return null;
        }
        return Double.parseDouble(Float.toString(floatValue.floatValue()));
    }

    public static Float convertToFloat(Double doubleValue) {
        if (doubleValue == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(Double.toString(doubleValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int sqlUpdate(DataSource dataSource, String sql) {
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        try {
            int n = DaoUtils.sqlUpdate(connection, sql);
            return n;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    public static int sqlUpdate(Connection connection, String sql) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
        }
        catch (SQLException ex) {
            DaoUtils.closeSilently(stmt);
            throw new DataAccessResourceFailureException("Could not open database connection", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sql);
        }
        try {
            int ex = stmt.executeUpdate(sql);
            return ex;
        }
        catch (SQLException ex) {
            throw new DataIntegrityViolationException("Could not execute query: " + sql, (Throwable)ex);
        }
        finally {
            DaoUtils.closeSilently(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object sqlUnique(DataSource dataSource, String sql) {
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        try {
            Object object = DaoUtils.sqlUnique(connection, sql);
            return object;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    public static <T> T sqlUniqueTyped(DataSource dataSource, String sql) {
        return (T)DaoUtils.sqlUnique(dataSource, sql);
    }

    public static Object sqlUnique(Connection connection, String sql) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
        }
        catch (SQLException ex) {
            DaoUtils.closeSilently(stmt);
            throw new DataAccessResourceFailureException("Could not open database connection", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sql);
        }
        try {
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                throw new DataRetrievalFailureException("Executed query return no row: " + sql);
            }
            Object result = rs.getObject(1);
            if (rs.next()) {
                throw new DataRetrievalFailureException("Executed query has more than one row: " + sql);
            }
            Object object = result;
            return object;
        }
        catch (SQLException ex) {
            throw new DataIntegrityViolationException("Could not execute query: " + sql, (Throwable)ex);
        }
        finally {
            DaoUtils.closeSilently(stmt);
        }
    }

    public static Object sqlUniqueOrNull(Connection connection, String sql) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
        }
        catch (SQLException ex) {
            DaoUtils.closeSilently(stmt);
            throw new DataAccessResourceFailureException("Could not open database connection", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sql);
        }
        try {
            ResultSet rs = stmt.executeQuery(sql);
            if (!rs.next()) {
                Object var4_6 = null;
                return var4_6;
            }
            Object result = rs.getObject(1);
            if (rs.next()) {
                throw new DataRetrievalFailureException("Executed query has more than one row: " + sql);
            }
            Object object = result;
            return object;
        }
        catch (SQLException ex) {
            throw new DataIntegrityViolationException("Could not execute query: " + sql, (Throwable)ex);
        }
        finally {
            DaoUtils.closeSilently(stmt);
        }
    }

    public static <T> T sqlUniqueTyped(Connection connection, String sql) {
        return (T)DaoUtils.sqlUnique(connection, sql);
    }

    public static void shutdownDatabase(Connection connection) {
        DaoUtils.shutdownDatabase(connection, false);
    }

    public static void shutdownDatabase(Connection connection, boolean compact) {
        try {
            String jdbcUrl = connection.getMetaData().getURL();
            if (jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB)) {
                String sql = "SHUTDOWN";
                if (compact) {
                    sql = sql + " COMPACT";
                }
                DaoUtils.sqlUpdate(connection, sql);
            }
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.shutdownDatabase.error", (Object[])new Object[0]), e);
        }
    }

    public static void shutdownDatabase(DataSource dataSource, boolean compact) {
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        try {
            DaoUtils.shutdownDatabase(connection, compact);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    public static void shutdownDatabase(Properties connectionProperties) throws SQLException {
        Connection conn = DaoUtils.createConnection(connectionProperties);
        try {
            DaoUtils.shutdownDatabase(conn);
        }
        finally {
            DaoUtils.closeSilently(conn);
        }
    }

    public static void compactDatabase(DataSource dataSource) {
        Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
        try {
            DaoUtils.compactDatabase(connection);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    public static void compactDatabase(Connection connection) {
        try {
            connection.setReadOnly(false);
            String jdbcUrl = connection.getMetaData().getURL();
            if (jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB)) {
                String sql = "CHECKPOINT DEFRAG";
                DaoUtils.sqlUpdate(connection, sql);
            }
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.compactDatabase.error", (Object[])new Object[0]), e);
        }
    }

    public static Timestamp getCurrentTimestamp(Connection connection, Dialect dialect) {
        String sql = dialect.getCurrentTimestampSelectString();
        Statement statement = null;
        try {
            Timestamp result;
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            rs.next();
            Timestamp timestamp = result = rs.getTimestamp(1);
            return timestamp;
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.currentTimestamp.error", (Object[])new Object[0]), e);
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    public static PreparedStatement bindQuery(Connection connection, String sql, Map<String, Object> bindingMap) throws SQLException {
        StringBuilder sb = new StringBuilder();
        StringBuilder debugParams = null;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            debugParams = new StringBuilder();
        }
        ArrayList orderedBindingValues = Lists.newArrayList();
        Matcher paramMatcher = Pattern.compile(":[a-zA-Z_0-9]+").matcher(sql);
        int offset = 0;
        while (paramMatcher.find()) {
            String bindingName = sql.substring(paramMatcher.start() + 1, paramMatcher.end());
            Object bindingValue = bindingMap.get(bindingName);
            if (bindingValue == null && !bindingMap.containsKey(bindingName)) {
                log.error((Object)I18n.t((String)"adagio.persistence.bindingQuery.error.log", (Object[])new Object[]{bindingName, sql}));
                throw new AdagioTechnicalException(I18n.t((String)"adagio.persistence.bindingQuery.error", (Object[])new Object[]{sql}));
            }
            orderedBindingValues.add(bindingValue);
            sb.append(sql.substring(offset, paramMatcher.start())).append("?");
            offset = paramMatcher.end();
            if (!debug) continue;
            debugParams.append(", ").append(bindingValue);
        }
        if (offset > 0) {
            if (offset < sql.length()) {
                sb.append(sql.substring(offset));
            }
            sql = sb.toString();
        }
        if (debug) {
            log.debug((Object)String.format("Execute query: %s", sql));
            log.debug((Object)String.format("  with params: [%s]", debugParams.length() > 2 ? debugParams.substring(2) : "no binding"));
        }
        PreparedStatement statement = connection.prepareStatement(sql);
        int index = 1;
        for (Object value : orderedBindingValues) {
            statement.setObject(index, value);
            ++index;
        }
        return statement;
    }
}

