/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.MaturityCaracteristic;
import fr.ifremer.tutti.persistence.entities.protocol.MaturityCaracteristics;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.protocol.Zone;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.CaracteristicsCount;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.AvailableStratasTreeModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.ZonesTreeModel;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.SubStrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneNode;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditProtocolUIModel
extends AbstractTuttiBeanUIModel<TuttiProtocol, EditProtocolUIModel>
implements TuttiProtocol {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_CARACTERISTIC_MAPPING_ROWS = "caracteristicMappingRows";
    public static final String PROPERTY_OPERATION_FIELD_MAPPING_ROWS = "operationFieldMappingRows";
    public static final String PROPERTY_SPECIES_ROW = "speciesRow";
    public static final String PROPERTY_BENTHOS_ROW = "benthosRow";
    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";
    public static final String PROPERTY_REMOVE_BENTHOS_ENABLED = "removeBenthosEnabled";
    public static final String PROPERTY_REMOVE_CARACTERISTIC_MAPPING_ENABLED = "removeCaracteristicMappingEnabled";
    public static final String PROPERTY_MOVE_UP_CARACTERISTIC_MAPPING_ENABLED = "moveUpCaracteristicMappingEnabled";
    public static final String PROPERTY_MOVE_DOWN_CARACTERISTIC_MAPPING_ENABLED = "moveDownCaracteristicMappingEnabled";
    public static final String PROPERTY_IMPORTED = "imported";
    public static final String PROPERTY_CLONED = "cloned";
    public static final String PROPERTY_CLEANED = "cleaned";
    public static final String PROPERTY_CPS_ROWS = "cpsRows";
    public static final String PROPERTY_MODIFYING_ZONES = "modifyingZones";
    public static final String PROPERTY_MATURITY_PMFM_ID = "maturityPmfmId";
    protected final TuttiProtocol editObject = TuttiProtocols.newTuttiProtocol();
    private final SampleCategoryModel sampleCategoryModel;
    protected boolean imported;
    protected boolean cloned;
    protected boolean cleaned;
    protected boolean removeSpeciesEnabled;
    protected boolean removeBenthosEnabled;
    protected boolean removeCaracteristicMappingEnabled;
    protected boolean moveUpCaracteristicMappingEnabled;
    protected boolean moveDownCaracteristicMappingEnabled;
    protected List<Species> allSpecies;
    protected List<Species> allSynonyms;
    protected Multimap<String, Species> allSpeciesByTaxonId;
    protected Map<String, Species> allReferentSpeciesByTaxonId;
    protected List<Caracteristic> caracteristics;
    protected Map<String, Caracteristic> allCaracteristic;
    protected List<String> maturityPmfmId;
    protected final LinkedHashMap<String, MaturityCaracteristic> maturityCaracteristicsById = new LinkedHashMap();
    protected LinkedHashMap<Caracteristic, EditProtocolCaracteristicsRowModel> caracteristicMappingRows = new LinkedHashMap();
    protected List<EditProtocolOperationFieldsRowModel> operationFieldMappingRows = new ArrayList<EditProtocolOperationFieldsRowModel>();
    protected Map<String, MutableInt> numberOfRowsByColumn = new HashMap<String, MutableInt>();
    protected List<EditProtocolSpeciesRowModel> speciesRow;
    protected List<EditProtocolSpeciesRowModel> benthosRow;
    protected List<CalcifiedPiecesSamplingEditorRowModel> cpsRows;
    protected final ZonesTreeModel zonesTreeModel = new ZonesTreeModel();
    protected final AvailableStratasTreeModel availableStratasTreeModel = new AvailableStratasTreeModel();
    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder = BinderFactory.newBinder(EditProtocolUIModel.class, TuttiProtocol.class);
    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder = BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);
    private boolean modifyingZones;
    private final CaracteristicsCount lengthStepPmfmUsed = new CaracteristicsCount();
    private final CaracteristicsCount maturityPmfmUsed = new CaracteristicsCount();
    protected List<Zone> incomingZones = new LinkedList<Zone>();

    public EditProtocolUIModel(SampleCategoryModel sampleCategoryModel) {
        super(fromBeanBinder, toBeanBinder);
        this.sampleCategoryModel = sampleCategoryModel;
        this.addPropertyChangeListener("maturityCaracteristics", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List newValue = (List)evt.getNewValue();
                EditProtocolUIModel.this.setMaturityPmfmId(newValue.stream().map(MaturityCaracteristic::getId).collect(Collectors.toList()));
                LinkedHashMap<String, MaturityCaracteristic> newMap = new LinkedHashMap<String, MaturityCaracteristic>();
                newValue.forEach(maturityCaracteristic -> newMap.put(maturityCaracteristic.getId(), (MaturityCaracteristic)maturityCaracteristic));
                EditProtocolUIModel.this.setMaturityCaracteristicsById(newMap);
            }
        });
        this.addPropertyChangeListener(PROPERTY_MATURITY_PMFM_ID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List newValue = (List)evt.getNewValue();
                LinkedHashMap<String, MaturityCaracteristic> newMap = new LinkedHashMap<String, MaturityCaracteristic>();
                newValue.forEach(maturityPmfmId -> newMap.put((String)maturityPmfmId, EditProtocolUIModel.this.maturityCaracteristicsById.getOrDefault(maturityPmfmId, MaturityCaracteristics.newMaturityCaracteristic(maturityPmfmId))));
                EditProtocolUIModel.this.setMaturityCaracteristicsById(newMap);
            }
        });
    }

    public CaracteristicsCount getLengthStepPmfmUsed() {
        return this.lengthStepPmfmUsed;
    }

    public CaracteristicsCount getMaturityPmfmUsed() {
        return this.maturityPmfmUsed;
    }

    public EditProtocolSpeciesRowModel newRow() {
        EditProtocolSpeciesRowModel result = new EditProtocolSpeciesRowModel();
        ArrayList mandatoryIds = Lists.newArrayList(this.sampleCategoryModel.getSamplingOrder());
        mandatoryIds.remove(0);
        result.setMandatorySampleCategoryId(mandatoryIds);
        result.setWeightEnabled(true);
        result.setValid(true);
        result.addPropertyChangeListener("lengthStepPmfm", evt -> {
            if (evt.getOldValue() != null) {
                this.lengthStepPmfmUsed.removeCaracteristic((Caracteristic)evt.getOldValue());
            }
            if (evt.getNewValue() == null) {
                EditProtocolSpeciesRowModel rowModel = (EditProtocolSpeciesRowModel)evt.getSource();
                rowModel.setRtpMale(null);
                rowModel.setRtpFemale(null);
                rowModel.setRtpUndefined(null);
            } else {
                this.lengthStepPmfmUsed.addCaracteristic((Caracteristic)evt.getNewValue());
            }
        });
        result.addPropertyChangeListener("maturityPmfm", evt -> {
            if (evt.getOldValue() != null) {
                this.maturityPmfmUsed.removeCaracteristic((Caracteristic)evt.getOldValue());
            }
            if (evt.getNewValue() != null) {
                this.maturityPmfmUsed.addCaracteristic((Caracteristic)evt.getNewValue());
            }
        });
        return result;
    }

    @Override
    protected TuttiProtocol newEntity() {
        return TuttiProtocols.newTuttiProtocol();
    }

    @Override
    public void fromEntity(TuttiProtocol entity) {
        fromBeanBinder.copyExcluding((Object)entity, (Object)this, new String[]{"zone"});
        this.incomingZones.clear();
        if (!entity.isZoneEmpty()) {
            this.incomingZones.addAll(entity.getZone());
        }
    }

    public List<Zone> getIncomingZones() {
        return this.incomingZones;
    }

    @Override
    public TuttiProtocol toEntity() {
        TuttiProtocol result = TuttiProtocols.newTuttiProtocol();
        toBeanBinder.copyExcluding((Object)this, (Object)result, new String[]{"zone", "maturityCaracteristics"});
        Set<Zone> zones = this.zonesTreeModel.getZones();
        result.setZone(zones);
        Collection<EditProtocolCaracteristicsRowModel> protocolCaracteristicMappingRows = this.getCaracteristicMappingRows();
        ArrayList<CaracteristicMappingRow> caracteristicMappingRows = new ArrayList<CaracteristicMappingRow>();
        for (EditProtocolCaracteristicsRowModel row : protocolCaracteristicMappingRows) {
            if (!row.isValid()) continue;
            caracteristicMappingRows.add((CaracteristicMappingRow)row.toEntity());
        }
        result.setCaracteristicMapping(caracteristicMappingRows);
        List<EditProtocolOperationFieldsRowModel> protocolOperationFieldMappingRows = this.getOperationFieldMappingRows();
        ArrayList<OperationFieldMappingRow> operationFieldMappingRows = new ArrayList<OperationFieldMappingRow>();
        for (EditProtocolOperationFieldsRowModel row : protocolOperationFieldMappingRows) {
            if (!StringUtils.isNotBlank((CharSequence)row.getField()) || !StringUtils.isNotBlank((CharSequence)row.getImportColumn()) || !row.isValid()) continue;
            operationFieldMappingRows.add((OperationFieldMappingRow)row.toEntity());
        }
        result.setOperationFieldMapping(operationFieldMappingRows);
        ImmutableListMultimap cpsRowsBySpecies = Multimaps.index(this.getCpsRows(), CalcifiedPiecesSamplingEditorRowModel::getProtocolSpecies);
        ArrayList speciesProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : this.getSpeciesRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toEntity();
            speciesProtocols.add(protocol);
            Collection cpsRows = cpsRowsBySpecies.get((Object)row);
            protocol.setCalcifiedPiecesSamplingDefinition(cpsRows.stream().map(AbstractTuttiBeanUIModel::toEntity).collect(Collectors.toList()));
        }
        result.setSpecies(speciesProtocols);
        ArrayList benthosProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : this.getBenthosRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toEntity();
            benthosProtocols.add(protocol);
            Collection cpsRows = cpsRowsBySpecies.get((Object)row);
            protocol.setCalcifiedPiecesSamplingDefinition(cpsRows.stream().map(AbstractTuttiBeanUIModel::toEntity).collect(Collectors.toList()));
        }
        result.setBenthos(benthosProtocols);
        result.setMaturityCaracteristics(new ArrayList<MaturityCaracteristic>(this.maturityCaracteristicsById.values()));
        return result;
    }

    public ZonesTreeModel getZonesTreeModel() {
        return this.zonesTreeModel;
    }

    public AvailableStratasTreeModel getAvailableStratasTreeModel() {
        return this.availableStratasTreeModel;
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        ArrayList ids = Lists.newArrayList(TuttiEntities.collecIds(lengthClassesPmfm));
        this.setLengthClassesPmfmId(ids);
    }

    public void setIndividualObservationPmfm(List<Caracteristic> individualObservationPmfm) {
        List<String> ids = TuttiEntities.collecIds(individualObservationPmfm);
        this.setIndividualObservationPmfmId(ids);
    }

    public void setMaturityPmfm(List<Caracteristic> maturityPmfm) {
        ArrayList ids = Lists.newArrayList(TuttiEntities.collecIds(maturityPmfm));
        this.setMaturityPmfmId(ids);
    }

    public Collection<EditProtocolCaracteristicsRowModel> getCaracteristicMappingRows() {
        return this.caracteristicMappingRows.values();
    }

    public void addCaracteristicMappingRow(EditProtocolCaracteristicsRowModel newRow) {
        this.caracteristicMappingRows.put(newRow.getPsfm(), newRow);
        this.firePropertyChange(PROPERTY_CARACTERISTIC_MAPPING_ROWS, null, this.getCaracteristicMappingRows());
    }

    public void removeCaracteristicMappingRows(Collection<EditProtocolCaracteristicsRowModel> rowsToRemove) {
        for (EditProtocolCaracteristicsRowModel row : rowsToRemove) {
            this.caracteristicMappingRows.remove(row.getPsfm());
        }
        this.firePropertyChange(PROPERTY_CARACTERISTIC_MAPPING_ROWS, null, this.getCaracteristicMappingRows());
    }

    public void setCaracteristicMappingRows(List<EditProtocolCaracteristicsRowModel> caracteristicMappingRows) {
        this.caracteristicMappingRows = new LinkedHashMap(Maps.uniqueIndex(caracteristicMappingRows, EditProtocolCaracteristicsRowModel::getPsfm));
        this.firePropertyChange(PROPERTY_CARACTERISTIC_MAPPING_ROWS, null, caracteristicMappingRows);
    }

    public boolean isCaracteristicUsedInMapping(Caracteristic caracteristic) {
        return this.caracteristicMappingRows.containsKey(caracteristic);
    }

    public Collection<Caracteristic> getUsedCaracteristics() {
        return this.caracteristicMappingRows.keySet();
    }

    public List<EditProtocolOperationFieldsRowModel> getOperationFieldMappingRows() {
        return this.operationFieldMappingRows;
    }

    public void setOperationFieldMappingRows(List<EditProtocolOperationFieldsRowModel> operationFieldMappingRows) {
        List<EditProtocolOperationFieldsRowModel> oldValue = this.getOperationFieldMappingRows();
        this.operationFieldMappingRows = operationFieldMappingRows;
        this.firePropertyChange(PROPERTY_OPERATION_FIELD_MAPPING_ROWS, oldValue, operationFieldMappingRows);
    }

    public List<EditProtocolSpeciesRowModel> getSpeciesRow() {
        return this.speciesRow;
    }

    public void setSpeciesRow(List<EditProtocolSpeciesRowModel> speciesRow) {
        List<EditProtocolSpeciesRowModel> oldValue = this.getSpeciesRow();
        this.speciesRow = speciesRow;
        this.firePropertyChange(PROPERTY_SPECIES_ROW, oldValue, speciesRow);
    }

    public List<EditProtocolSpeciesRowModel> getBenthosRow() {
        return this.benthosRow;
    }

    public void setBenthosRow(List<EditProtocolSpeciesRowModel> benthosRow) {
        List<EditProtocolSpeciesRowModel> oldValue = this.getBenthosRow();
        this.benthosRow = benthosRow;
        this.firePropertyChange(PROPERTY_BENTHOS_ROW, oldValue, benthosRow);
    }

    public Optional<EditProtocolSpeciesRowModel> getProtocolSpeciesRowForSpecies(Species species) {
        ArrayList<EditProtocolSpeciesRowModel> allRows = new ArrayList<EditProtocolSpeciesRowModel>();
        if (this.speciesRow != null) {
            allRows.addAll(this.speciesRow);
        }
        if (this.benthosRow != null) {
            allRows.addAll(this.benthosRow);
        }
        return allRows.stream().filter(row -> row.getSpecies().equals(species)).findFirst();
    }

    public List<CalcifiedPiecesSamplingEditorRowModel> getCpsRows() {
        return this.cpsRows;
    }

    public void setCpsRows(List<CalcifiedPiecesSamplingEditorRowModel> cpsRows) {
        List<CalcifiedPiecesSamplingEditorRowModel> oldValue = this.getCpsRows();
        this.cpsRows = cpsRows;
        this.firePropertyChange(PROPERTY_CPS_ROWS, oldValue, cpsRows);
    }

    public boolean isRemoveSpeciesEnabled() {
        return this.removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, null, removeSpeciesEnabled);
    }

    public boolean isRemoveBenthosEnabled() {
        return this.removeBenthosEnabled;
    }

    public void setRemoveBenthosEnabled(boolean removeBenthosEnabled) {
        this.removeBenthosEnabled = removeBenthosEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_BENTHOS_ENABLED, null, removeBenthosEnabled);
    }

    public boolean isRemoveCaracteristicMappingEnabled() {
        return this.removeCaracteristicMappingEnabled;
    }

    public void setRemoveCaracteristicMappingEnabled(boolean removeCaracteristicMappingEnabled) {
        this.removeCaracteristicMappingEnabled = removeCaracteristicMappingEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_CARACTERISTIC_MAPPING_ENABLED, null, removeCaracteristicMappingEnabled);
    }

    public boolean isMoveUpCaracteristicMappingEnabled() {
        return this.moveUpCaracteristicMappingEnabled;
    }

    public void setMoveUpCaracteristicMappingEnabled(boolean moveUpCaracteristicMappingEnabled) {
        this.moveUpCaracteristicMappingEnabled = moveUpCaracteristicMappingEnabled;
        this.firePropertyChange(PROPERTY_MOVE_UP_CARACTERISTIC_MAPPING_ENABLED, null, moveUpCaracteristicMappingEnabled);
    }

    public boolean isMoveDownCaracteristicMappingEnabled() {
        return this.moveDownCaracteristicMappingEnabled;
    }

    public void setMoveDownCaracteristicMappingEnabled(boolean moveDownCaracteristicMappingEnabled) {
        this.moveDownCaracteristicMappingEnabled = moveDownCaracteristicMappingEnabled;
        this.firePropertyChange(PROPERTY_MOVE_DOWN_CARACTERISTIC_MAPPING_ENABLED, null, moveDownCaracteristicMappingEnabled);
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        Boolean oldValue = this.isImported();
        this.imported = imported;
        this.firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean cloned) {
        Boolean oldValue = this.isCloned();
        this.cloned = cloned;
        this.firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public boolean isCleaned() {
        return this.cleaned;
    }

    public void setCleaned(boolean cleaned) {
        Boolean oldValue = this.isCleaned();
        this.cleaned = cleaned;
        this.firePropertyChange(PROPERTY_CLEANED, oldValue, cleaned);
    }

    public List<Species> getAllSpecies() {
        return this.allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (this.allReferentSpeciesByTaxonId != null && allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(allSpecies);
            this.allSynonyms.removeAll(this.allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return this.allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return this.allSpeciesByTaxonId.get((Object)taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return this.allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return this.allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && this.allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(this.allSpecies);
            for (Species species : allReferentSpeciesByTaxonId.values()) {
                this.allSynonyms.remove(species);
            }
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return this.caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return this.allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }

    @Override
    public String getName() {
        return this.editObject.getName();
    }

    @Override
    public void setName(String name) {
        String oldValue = this.getName();
        this.editObject.setName(name);
        this.firePropertyChange("name", oldValue, name);
    }

    @Override
    public String getComment() {
        return this.editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public String getProgramId() {
        return this.editObject.getProgramId();
    }

    @Override
    public void setProgramId(String programId) {
        String oldValue = this.getProgramId();
        this.editObject.setProgramId(programId);
        this.firePropertyChange("programId", oldValue, programId);
    }

    @Override
    public List<String> getLengthClassesPmfmId() {
        return this.editObject.getLengthClassesPmfmId();
    }

    @Override
    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        this.editObject.setLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, lengthClassesPmfmId);
    }

    @Override
    public List<String> getIndividualObservationPmfmId() {
        return this.editObject.getIndividualObservationPmfmId();
    }

    @Override
    public void setIndividualObservationPmfmId(List<String> individualObservationPmfmId) {
        this.editObject.setIndividualObservationPmfmId(individualObservationPmfmId);
        this.firePropertyChange("individualObservationPmfmId", null, individualObservationPmfmId);
    }

    public List<String> getMaturityPmfmId() {
        return this.maturityPmfmId;
    }

    public void setMaturityPmfmId(List<String> maturityPmfmId) {
        this.maturityPmfmId = maturityPmfmId;
        this.firePropertyChange(PROPERTY_MATURITY_PMFM_ID, null, maturityPmfmId);
    }

    @Override
    public List<CaracteristicMappingRow> getCaracteristicMapping() {
        return this.editObject.getCaracteristicMapping();
    }

    @Override
    public void setCaracteristicMapping(List<CaracteristicMappingRow> caracteristicMapping) {
        this.editObject.setCaracteristicMapping(caracteristicMapping);
        this.firePropertyChange("caracteristicMapping", null, caracteristicMapping);
    }

    @Override
    public CaracteristicMappingRow getCaracteristicMapping(int index) {
        return this.editObject.getCaracteristicMapping(index);
    }

    @Override
    public boolean isCaracteristicMappingEmpty() {
        return this.editObject.isCaracteristicMappingEmpty();
    }

    @Override
    public int sizeCaracteristicMapping() {
        return this.editObject.sizeCaracteristicMapping();
    }

    @Override
    public void addCaracteristicMapping(CaracteristicMappingRow caracteristicMapping) {
        this.editObject.addCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public void addAllCaracteristicMapping(Collection<CaracteristicMappingRow> caracteristicMapping) {
        this.editObject.addAllCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean removeCaracteristicMapping(CaracteristicMappingRow caracteristicMapping) {
        return this.editObject.removeCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean removeAllCaracteristicMapping(Collection<CaracteristicMappingRow> caracteristicMapping) {
        return this.editObject.removeAllCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean containsCaracteristicMapping(CaracteristicMappingRow caracteristicMapping) {
        return this.editObject.containsCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public boolean containsAllCaracteristicMapping(Collection<CaracteristicMappingRow> caracteristicMapping) {
        return this.editObject.containsAllCaracteristicMapping(caracteristicMapping);
    }

    @Override
    public String getIndividualObservationPmfmId(int index) {
        return this.editObject.getIndividualObservationPmfmId(index);
    }

    @Override
    public boolean isIndividualObservationPmfmIdEmpty() {
        return this.editObject.isIndividualObservationPmfmIdEmpty();
    }

    @Override
    public int sizeIndividualObservationPmfmId() {
        return this.editObject.sizeIndividualObservationPmfmId();
    }

    @Override
    public void addIndividualObservationPmfmId(String individualObservationPmfmId) {
        this.editObject.addIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public void addAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        this.editObject.addAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeIndividualObservationPmfmId(String individualObservationPmfmId) {
        return this.editObject.removeIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return this.editObject.removeAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsIndividualObservationPmfmId(String individualObservationPmfmId) {
        return this.editObject.containsIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return this.editObject.containsAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public String getLengthClassesPmfmId(int index) {
        return this.editObject.getLengthClassesPmfmId(index);
    }

    @Override
    public boolean isLengthClassesPmfmIdEmpty() {
        return this.editObject.isLengthClassesPmfmIdEmpty();
    }

    @Override
    public int sizeLengthClassesPmfmId() {
        return this.editObject.sizeLengthClassesPmfmId();
    }

    @Override
    public void addLengthClassesPmfmId(String lengthClassesPmfmId) {
        this.editObject.addLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
    }

    @Override
    public void addAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        this.editObject.addAllLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
    }

    @Override
    public boolean removeLengthClassesPmfmId(String lengthClassesPmfmId) {
        boolean result = this.editObject.removeLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean removeAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        boolean result = this.editObject.removeAllLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean containsLengthClassesPmfmId(String lengthClassesPmfmId) {
        return this.editObject.containsLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public boolean containsAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        return this.editObject.containsAllLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public void addAllMaturityCaracteristics(Collection<MaturityCaracteristic> maturityCaracteristics) {
        this.editObject.addAllMaturityCaracteristics(maturityCaracteristics);
        this.firePropertyChanged("maturityCaracteristics", null, this.getMaturityCaracteristics());
    }

    @Override
    public MaturityCaracteristic getMaturityCaracteristics(int index) {
        return this.editObject.getMaturityCaracteristics(index);
    }

    @Override
    public boolean isMaturityCaracteristicsEmpty() {
        return this.editObject.isMaturityCaracteristicsEmpty();
    }

    @Override
    public int sizeMaturityCaracteristics() {
        return this.editObject.sizeMaturityCaracteristics();
    }

    @Override
    public void addMaturityCaracteristics(MaturityCaracteristic maturityCaracteristics) {
        this.editObject.addMaturityCaracteristics(maturityCaracteristics);
        this.firePropertyChanged("maturityCaracteristics", null, this.getMaturityCaracteristics());
    }

    @Override
    public boolean removeMaturityCaracteristics(MaturityCaracteristic maturityCaracteristics) {
        boolean result = this.editObject.removeMaturityCaracteristics(maturityCaracteristics);
        this.firePropertyChanged("maturityCaracteristics", null, this.getMaturityCaracteristics());
        return result;
    }

    @Override
    public boolean removeAllMaturityCaracteristics(Collection<MaturityCaracteristic> maturityCaracteristics) {
        boolean result = this.editObject.removeAllMaturityCaracteristics(maturityCaracteristics);
        this.firePropertyChanged("maturityCaracteristics", null, this.getMaturityCaracteristics());
        return result;
    }

    @Override
    public boolean containsMaturityCaracteristics(MaturityCaracteristic maturityCaracteristics) {
        return this.editObject.containsMaturityCaracteristics(maturityCaracteristics);
    }

    @Override
    public boolean containsAllMaturityCaracteristics(Collection<MaturityCaracteristic> maturityCaracteristics) {
        return this.editObject.containsAllMaturityCaracteristics(maturityCaracteristics);
    }

    @Override
    public List<MaturityCaracteristic> getMaturityCaracteristics() {
        return this.editObject.getMaturityCaracteristics();
    }

    @Override
    public void setMaturityCaracteristics(List<MaturityCaracteristic> maturityCaracteristics) {
        this.editObject.setMaturityCaracteristics(maturityCaracteristics);
        this.firePropertyChanged("maturityCaracteristics", null, maturityCaracteristics);
    }

    @Override
    public SpeciesProtocol getSpecies(int index) {
        return this.editObject.getSpecies(index);
    }

    @Override
    public boolean isSpeciesEmpty() {
        return this.editObject.isSpeciesEmpty();
    }

    @Override
    public int sizeSpecies() {
        return this.editObject.sizeSpecies();
    }

    @Override
    public void addSpecies(SpeciesProtocol species) {
        this.editObject.addSpecies(species);
    }

    @Override
    public void addAllSpecies(Collection<SpeciesProtocol> species) {
        this.editObject.addAllSpecies(species);
    }

    @Override
    public boolean removeSpecies(SpeciesProtocol species) {
        return this.editObject.removeSpecies(species);
    }

    @Override
    public boolean removeAllSpecies(Collection<SpeciesProtocol> species) {
        return this.editObject.removeAllSpecies(species);
    }

    @Override
    public boolean containsSpecies(SpeciesProtocol species) {
        return this.editObject.containsSpecies(species);
    }

    @Override
    public boolean containsAllSpecies(Collection<SpeciesProtocol> species) {
        return this.editObject.containsAllSpecies(species);
    }

    @Override
    public List<SpeciesProtocol> getSpecies() {
        return this.editObject.getSpecies();
    }

    @Override
    public void setSpecies(List<SpeciesProtocol> species) {
        this.editObject.setSpecies(species);
    }

    @Override
    public SpeciesProtocol getBenthos(int index) {
        return this.editObject.getBenthos(index);
    }

    @Override
    public boolean isBenthosEmpty() {
        return this.editObject.isBenthosEmpty();
    }

    @Override
    public int sizeBenthos() {
        return this.editObject.sizeBenthos();
    }

    @Override
    public void addBenthos(SpeciesProtocol benthos) {
        this.editObject.addBenthos(benthos);
    }

    @Override
    public void addAllBenthos(Collection<SpeciesProtocol> benthos) {
        this.editObject.addAllBenthos(benthos);
    }

    @Override
    public boolean removeBenthos(SpeciesProtocol benthos) {
        return this.editObject.removeBenthos(benthos);
    }

    @Override
    public boolean removeAllBenthos(Collection<SpeciesProtocol> benthos) {
        return this.editObject.removeAllBenthos(benthos);
    }

    @Override
    public boolean containsBenthos(SpeciesProtocol benthos) {
        return this.editObject.containsBenthos(benthos);
    }

    @Override
    public boolean containsAllBenthos(Collection<SpeciesProtocol> benthos) {
        return this.editObject.containsAllBenthos(benthos);
    }

    @Override
    public List<SpeciesProtocol> getBenthos() {
        return this.editObject.getBenthos();
    }

    @Override
    public void setBenthos(List<SpeciesProtocol> benthos) {
        this.editObject.setBenthos(benthos);
    }

    @Override
    public Integer getVersion() {
        return this.editObject.getVersion();
    }

    @Override
    public void setVersion(Integer version) {
        this.editObject.setVersion(version);
    }

    @Override
    public String getImportColumns(int index) {
        return this.editObject.getImportColumns(index);
    }

    @Override
    public boolean isImportColumnsEmpty() {
        return this.editObject.isImportColumnsEmpty();
    }

    @Override
    public int sizeImportColumns() {
        return this.editObject.sizeImportColumns();
    }

    @Override
    public void addImportColumns(String importColumns) {
        this.editObject.addImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
    }

    @Override
    public void addAllImportColumns(Collection<String> importColumns) {
        this.editObject.addAllImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
    }

    @Override
    public boolean removeImportColumns(String importColumns) {
        boolean removeImportColumns = this.editObject.removeImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
        return removeImportColumns;
    }

    @Override
    public boolean removeAllImportColumns(Collection<String> importColumns) {
        boolean removeAllImportColumns = this.editObject.removeAllImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
        return removeAllImportColumns;
    }

    @Override
    public boolean containsImportColumns(String importColumns) {
        return this.editObject.containsImportColumns(importColumns);
    }

    @Override
    public boolean containsAllImportColumns(Collection<String> importColumns) {
        return this.editObject.containsAllImportColumns(importColumns);
    }

    @Override
    public Collection<String> getImportColumns() {
        return this.editObject.getImportColumns();
    }

    @Override
    public void setImportColumns(Collection<String> importColumns) {
        this.editObject.setImportColumns(importColumns);
        this.firePropertyChanged("importColumns", null, this.getImportColumns());
    }

    @Override
    public void setOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        this.editObject.setOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
    }

    public boolean isAvailableStratas() {
        return this.getAvailableStratasTreeModel().isAvailableStratas();
    }

    public void setAvailableStratas(boolean availableStratas) {
    }

    @Override
    public Collection<Zone> getZone() {
        return null;
    }

    @Override
    public void setZone(Collection<Zone> zones) {
    }

    @Override
    public Zone getZone(int index) {
        return null;
    }

    @Override
    public boolean isZoneEmpty() {
        return true;
    }

    @Override
    public int sizeZone() {
        return 0;
    }

    @Override
    public void addZone(Zone zone) {
    }

    @Override
    public void addAllZone(Collection<Zone> zones) {
    }

    @Override
    public boolean removeZone(Zone zone) {
        return false;
    }

    @Override
    public boolean removeAllZone(Collection<Zone> zones) {
        return false;
    }

    @Override
    public boolean containsZone(Zone zone) {
        return false;
    }

    @Override
    public boolean containsAllZone(Collection<Zone> zones) {
        return false;
    }

    @Override
    public Collection<OperationFieldMappingRow> getOperationFieldMapping() {
        return this.editObject.getOperationFieldMapping();
    }

    @Override
    public boolean containsAllOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        return this.editObject.containsAllOperationFieldMapping(operationFieldMapping);
    }

    @Override
    public boolean containsOperationFieldMapping(OperationFieldMappingRow operationFieldMapping) {
        return this.editObject.containsOperationFieldMapping(operationFieldMapping);
    }

    @Override
    public boolean removeAllOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        boolean removeAllOperationFieldMapping = this.editObject.removeAllOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
        return removeAllOperationFieldMapping;
    }

    @Override
    public boolean removeOperationFieldMapping(OperationFieldMappingRow operationFieldMapping) {
        boolean removeOperationFieldMapping = this.editObject.removeOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
        return removeOperationFieldMapping;
    }

    @Override
    public void addAllOperationFieldMapping(Collection<OperationFieldMappingRow> operationFieldMapping) {
        this.editObject.addAllOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
    }

    @Override
    public void addOperationFieldMapping(OperationFieldMappingRow operationFieldMapping) {
        this.editObject.addOperationFieldMapping(operationFieldMapping);
        this.firePropertyChanged("operationFieldMapping", null, this.getOperationFieldMapping());
    }

    @Override
    public int sizeOperationFieldMapping() {
        return this.editObject.sizeOperationFieldMapping();
    }

    @Override
    public boolean isOperationFieldMappingEmpty() {
        return this.editObject.isOperationFieldMappingEmpty();
    }

    @Override
    public OperationFieldMappingRow getOperationFieldMapping(int index) {
        return this.editObject.getOperationFieldMapping(index);
    }

    @Override
    public boolean isUseCalcifiedPieceSampling() {
        return this.editObject.isUseCalcifiedPieceSampling();
    }

    @Override
    public void setUseCalcifiedPieceSampling(boolean useCalcifiedPieceSampling) {
        boolean oldValue = this.isUseCalcifiedPieceSampling();
        this.editObject.setUseCalcifiedPieceSampling(useCalcifiedPieceSampling);
        this.firePropertyChanged("useCalcifiedPieceSampling", oldValue, useCalcifiedPieceSampling);
    }

    public int numberOfRows(String column) {
        int result = 0;
        MutableInt mutableInt = this.numberOfRowsByColumn.get(column);
        if (mutableInt != null) {
            result = mutableInt.intValue();
        }
        return result;
    }

    public void resetNumbersOfRows() {
        this.numberOfRowsByColumn = new HashMap<String, MutableInt>();
    }

    public int incNumberOfRows(String column) {
        MutableInt mutableInt = this.numberOfRowsByColumn.get(column);
        if (mutableInt == null) {
            mutableInt = new MutableInt(1);
            this.numberOfRowsByColumn.put(column, mutableInt);
        } else {
            mutableInt.increment();
        }
        return mutableInt.intValue();
    }

    public int decNumberOfRows(String column) {
        MutableInt mutableInt = this.numberOfRowsByColumn.get(column);
        Preconditions.checkNotNull((Object)mutableInt);
        Preconditions.checkArgument((mutableInt.intValue() > 0 ? 1 : 0) != 0);
        mutableInt.decrement();
        return mutableInt.intValue();
    }

    public void selectStrataNodes(ZoneNode selectedZoneNode, StrataNode sourceStrataNode) {
        this.availableStratasTreeModel.removeNodeFromParent(sourceStrataNode);
        String sourceStrataId = sourceStrataNode.getId();
        StrataNode targetStrataNode = this.zonesTreeModel.getOrCreateStrataNode(selectedZoneNode, sourceStrataId);
        this.zonesTreeModel.moveSubStratas(sourceStrataNode, targetStrataNode);
        this.setModify(true);
    }

    public void selectedSubStraNodes(ZoneNode selectedZoneNode, SubStrataNode sourceSubStrataNode) {
        StrataNode sourceStrataNode = sourceSubStrataNode.getParent();
        this.availableStratasTreeModel.removeNodeFromParent(sourceSubStrataNode);
        if (sourceStrataNode.isLeaf()) {
            this.availableStratasTreeModel.removeNodeFromParent(sourceStrataNode);
        }
        StrataNode targetStrataNode = this.zonesTreeModel.getOrCreateStrataNode(selectedZoneNode, sourceStrataNode.getId());
        this.zonesTreeModel.addNode(targetStrataNode, sourceSubStrataNode);
        this.setModify(true);
    }

    public void unselectStrataNode(StrataNode sourceStrataNode) {
        this.zonesTreeModel.removeNodeFromParent(sourceStrataNode);
        StrataNode targetStrataNode = this.availableStratasTreeModel.getOrCreateStrataNode(sourceStrataNode.getId());
        this.availableStratasTreeModel.moveSubStratas(sourceStrataNode, targetStrataNode);
        this.setModify(true);
    }

    public void unselectSubStrataNode(SubStrataNode sourceSubStrataNode) {
        StrataNode sourceStrataNode = sourceSubStrataNode.getParent();
        this.zonesTreeModel.removeNodeFromParent(sourceSubStrataNode);
        if (sourceStrataNode.isLeaf()) {
            this.zonesTreeModel.removeNodeFromParent(sourceStrataNode);
        }
        StrataNode targetStrataNode = this.availableStratasTreeModel.getOrCreateStrataNode(sourceStrataNode.getId());
        this.availableStratasTreeModel.addNode(targetStrataNode, sourceSubStrataNode);
        this.setModify(true);
    }

    public boolean isModifyingZones() {
        return this.modifyingZones;
    }

    public void setModifyingZones(boolean modifyingZones) {
        Boolean oldValue = this.isModifyingZones();
        this.modifyingZones = modifyingZones;
        this.firePropertyChange(PROPERTY_MODIFYING_ZONES, oldValue, modifyingZones);
    }

    public void setLocationLabelCache(ImmutableMap<String, String> locationLabelCache) {
        this.zonesTreeModel.setLocationLabelCache(locationLabelCache);
        this.availableStratasTreeModel.setLocationLabelCache(locationLabelCache);
    }

    public Map<String, MaturityCaracteristic> getMaturityCaracteristicsById() {
        return this.maturityCaracteristicsById;
    }

    public void setMaturityCaracteristicsById(LinkedHashMap<String, MaturityCaracteristic> maturityCaracteristicsById) {
        this.maturityCaracteristicsById.clear();
        if (maturityCaracteristicsById != null) {
            this.maturityCaracteristicsById.putAll(maturityCaracteristicsById);
        }
    }

    public MaturityCaracteristic getMaturityCaracteristic(String id) {
        return this.maturityCaracteristicsById.get(id);
    }

    public boolean isMaturityValid(Caracteristic maturityCaracteristic) {
        Objects.requireNonNull(maturityCaracteristic);
        return this.isMaturityValid(maturityCaracteristic.getId());
    }

    public boolean isMaturityValid(String maturityCaracteristicId) {
        MaturityCaracteristic maturityCaracteristic = this.maturityCaracteristicsById.get(maturityCaracteristicId);
        return maturityCaracteristic != null && CollectionUtils.isNotEmpty(maturityCaracteristic.getMatureStateIds());
    }

    public boolean areAllMaturitiesValid() {
        return this.maturityPmfmId == null || this.maturityPmfmId.stream().allMatch(this::isMaturityValid);
    }
}

