/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.MoreObjects;
import fr.ifremer.tutti.persistence.entities.referential.AbstractCaracteristicBean;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.util.Numbers;

public class CaracteristicBean
extends AbstractCaracteristicBean {
    private static final long serialVersionUID = 1L;
    public static final Float DEFAULT_PRECISION = Float.valueOf(0.1f);

    @Override
    public Integer getLengthStepInMm(Float lengthStep) {
        Integer lengthClass;
        if (lengthStep == null) {
            lengthClass = null;
        } else {
            int intValue = (int)(lengthStep.floatValue() * 10.0f);
            int intStep = (int)(this.getPrecision().floatValue() * 10.0f);
            int correctIntStep = intValue - intValue % intStep;
            lengthClass = Numbers.convertToMm((float)correctIntStep / 10.0f, this.getUnit());
        }
        return lengthClass;
    }

    @Override
    public Float getPrecision() {
        Float result = super.getPrecision();
        if (result == null) {
            result = DEFAULT_PRECISION;
        }
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(Caracteristic.class).add("id", (Object)this.getId()).add("parameterName", (Object)this.getParameterName()).add("methodName", (Object)this.getMethodName()).add("fractionName", (Object)this.getFractionName()).add("matrixName", (Object)this.getMatrixName()).add("caracteristicType", (Object)this.getCaracteristicType()).toString();
    }
}

