/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.util;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.AdvancedQuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.datatools.connectivity.oda.spec.basequery.AtomicQuery;
import org.eclipse.datatools.connectivity.oda.spec.basequery.CombinedQuery;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultProjection;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultSetSpecification;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationFactory;

public class QuerySpecificationHelper {
    private static final String LOG_NEWLINE_CHAR = "\n ";
    private static final String LOG_PAIR_ENTRY_SEPARATOR = " -> ";
    private static final String SPACE = " ";
    private QuerySpecificationFactory m_factory;

    public QuerySpecificationHelper(String dynamicResultSetExtnId) {
        if (dynamicResultSetExtnId == null) {
            return;
        }
        try {
            ExtensionContributor contributor = ResultExtensionExplorer.getInstance().getExtensionContributor(dynamicResultSetExtnId);
            this.setFactory(contributor);
        }
        catch (OdaException odaException) {}
    }

    public QuerySpecificationHelper(ExtensionContributor contributor) {
        this.setFactory(contributor);
    }

    public QuerySpecificationHelper(QuerySpecificationFactory factory) {
        this.m_factory = factory;
    }

    QuerySpecificationHelper() {
        this((QuerySpecificationFactory)null);
    }

    private void setFactory(ExtensionContributor contributor) {
        if (contributor == null) {
            return;
        }
        try {
            this.m_factory = contributor.getSpecificationFactory();
        }
        catch (OdaException odaException) {}
    }

    public QuerySpecificationFactory getFactory() {
        if (this.m_factory == null) {
            this.m_factory = new QuerySpecificationFactory();
        }
        return this.m_factory;
    }

    public QuerySpecification createQuerySpecification(FilterExpression filterExpr) {
        return this.createQuerySpecification(filterExpr, null, null);
    }

    public QuerySpecification createQuerySpecification(ResultProjection projectionSpec) {
        return this.createQuerySpecification(null, projectionSpec, null);
    }

    public QuerySpecification createQuerySpecification(SortSpecification sortSpec) {
        return this.createQuerySpecification(null, null, sortSpec);
    }

    public QuerySpecification createQuerySpecification(FilterExpression filterExpr, ResultProjection projectionSpec, SortSpecification sortSpec) {
        return this.getFactory().createQuerySpecification(filterExpr, projectionSpec, sortSpec);
    }

    public QuerySpecification createQuerySpecification() {
        return this.getFactory().createQuerySpecification();
    }

    public AdvancedQuerySpecification createAdvancedQuerySpecification() {
        return this.getFactory().createAdvancedQuerySpecification();
    }

    public ResultSetSpecification createResultSetSpecification() {
        return this.getFactory().createResultSetSpecification();
    }

    public ResultProjection createResultProjection() {
        return this.getFactory().createResultProjection();
    }

    public SortSpecification createSortSpecification() {
        return this.getFactory().createSortSpecification();
    }

    public SortSpecification createSortSpecification(int sortMode) {
        return this.getFactory().createSortSpecification(sortMode);
    }

    public static FilterExpression getFilterSpecification(QuerySpecification querySpec) {
        ResultSetSpecification resultSpec = QuerySpecificationHelper.getResultSetSpecification(querySpec);
        return resultSpec != null ? resultSpec.getFilterSpecification() : null;
    }

    public static ResultProjection getResultProjection(QuerySpecification querySpec) {
        ResultSetSpecification resultSpec = QuerySpecificationHelper.getResultSetSpecification(querySpec);
        return resultSpec != null ? resultSpec.getResultProjection() : null;
    }

    public static SortSpecification getSortSpecification(QuerySpecification querySpec) {
        ResultSetSpecification resultSpec = QuerySpecificationHelper.getResultSetSpecification(querySpec);
        return resultSpec != null ? resultSpec.getSortSpecification() : null;
    }

    public static ResultSetSpecification getResultSetSpecification(QuerySpecification querySpec) {
        return querySpec != null ? querySpec.getResultSetSpecification() : null;
    }

    public static AtomicQuery getAtomicQuery(QuerySpecification querySpec) {
        BaseQuery baseQuery = querySpec != null ? querySpec.getBaseQuery() : null;
        return baseQuery instanceof AtomicQuery ? (AtomicQuery)baseQuery : null;
    }

    public static CombinedQuery getCombinedQuery(QuerySpecification querySpec) {
        BaseQuery baseQuery = querySpec != null ? querySpec.getBaseQuery() : null;
        return baseQuery instanceof CombinedQuery ? (CombinedQuery)baseQuery : null;
    }

    public static boolean hasAtomicQueryText(QuerySpecification querySpec) {
        AtomicQuery atomicQuery = QuerySpecificationHelper.getAtomicQuery(querySpec);
        return atomicQuery != null ? atomicQuery.hasQueryText() : false;
    }

    public static boolean hasCombinedQuery(QuerySpecification querySpec) {
        return QuerySpecificationHelper.getCombinedQuery(querySpec) != null;
    }

    public static String getContentAsString(QuerySpecification querySpec) {
        StringBuffer buffer = new StringBuffer(String.valueOf(QuerySpecification.class.getSimpleName()) + " [");
        if (querySpec == null) {
            buffer.append("null]");
            return buffer.toString();
        }
        buffer.append("\nProperty name-value pairs: ");
        for (Map.Entry<String, Object> entry : querySpec.getProperties().entrySet()) {
            String propValueClassName = entry.getValue() != null ? entry.getValue().getClass().getSimpleName() : "null";
            buffer.append(LOG_NEWLINE_CHAR + entry.getKey() + LOG_PAIR_ENTRY_SEPARATOR + propValueClassName + SPACE + entry.getValue());
        }
        buffer.append("\nParameter values: ");
        for (Map.Entry<Object, Object> entry : querySpec.getParameterValues().entrySet()) {
            String paramValueClassName = entry.getValue() != null ? entry.getValue().getClass().getSimpleName() : "null";
            buffer.append(LOG_NEWLINE_CHAR + entry.getKey() + LOG_PAIR_ENTRY_SEPARATOR + paramValueClassName + SPACE + entry.getValue());
        }
        buffer.append("\nFilter spec: ");
        buffer.append(QuerySpecificationHelper.getFilterSpecification(querySpec));
        buffer.append("\nResult projection: ");
        buffer.append(QuerySpecificationHelper.getResultProjection(querySpec));
        buffer.append("\nSort spec: ");
        buffer.append(QuerySpecificationHelper.getSortSpecification(querySpec));
        buffer.append("]");
        return buffer.toString();
    }

    public static Logger getLogger(String loggerName) {
        return Logger.getLogger(loggerName);
    }

    public static void logValidationException(String className, Throwable exception) {
        if (exception == null) {
            return;
        }
        QuerySpecificationHelper.getLogger("org.eclipse.datatools.connectivity.oda.spec").logp(Level.FINE, className, "validate(ValidationContext)", "Validation result: " + exception.toString());
    }
}

