/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.data.AbstractSpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SpeciesBatchs
extends AbstractSpeciesBatchs {
    public static final Function<SpeciesBatch, Serializable> GET_SAMPLE_CATEGORY_VALUE = SpeciesBatch::getSampleCategoryValue;

    public static SpeciesBatch newInstance(SpeciesBatch parent) {
        SpeciesBatch speciesBatch = SpeciesBatchs.newSpeciesBatch();
        speciesBatch.setBenthosBatch(parent.isBenthosBatch());
        return speciesBatch;
    }

    public static Map<Integer, SpeciesBatch> getAllSpeciesBatchesById(BatchContainer<SpeciesBatch> rootSpeciesBatch) {
        TreeMap<Integer, SpeciesBatch> result = new TreeMap<Integer, SpeciesBatch>();
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            SpeciesBatchs.getAllspeciesBatchesById(speciesBatch, result);
        }
        return result;
    }

    private static void getAllspeciesBatchesById(SpeciesBatch speciesBatch, Map<Integer, SpeciesBatch> result) {
        result.put(speciesBatch.getIdAsInt(), speciesBatch);
        if (!speciesBatch.isChildBatchsEmpty()) {
            for (SpeciesBatch batch : speciesBatch.getChildBatchs()) {
                SpeciesBatchs.getAllspeciesBatchesById(batch, result);
            }
        }
    }

    public static Predicate<SpeciesBatch> newSpeciesAbleBatchCategoryPredicate(Integer cateogryId, Integer value) {
        return new SpeciesAbleBatchCategoryPredicate(cateogryId, value);
    }

    public static SpeciesBatch createNewChild(SpeciesBatch parent) {
        SpeciesBatch child = SpeciesBatchs.newInstance(parent);
        child.setFishingOperation(parent.getFishingOperation());
        child.setSpecies(parent.getSpecies());
        child.setParentBatch(parent);
        parent.addChildBatchs(child);
        return child;
    }

    public static SpeciesBatch newBenthosBatch() {
        SpeciesBatch speciesBatch = SpeciesBatchs.newSpeciesBatch();
        speciesBatch.setBenthosBatch(true);
        return speciesBatch;
    }

    public static void grabSpeciesChildBatchs(Collection<SpeciesBatch> childs, Set<Species> speciesSet) {
        for (SpeciesBatch child : childs) {
            speciesSet.add(child.getSpecies());
        }
    }

    public static void grabSampleCategorieValuesChildBatchs(SpeciesBatch batch, Set<Integer> categoryIds) {
        CaracteristicQualitativeValue sampleCategoryValue = (CaracteristicQualitativeValue)batch.getSampleCategoryValue();
        categoryIds.add(sampleCategoryValue.getIdAsInt());
        if (!batch.isChildBatchsEmpty()) {
            for (SpeciesBatch child : batch.getChildBatchs()) {
                SpeciesBatchs.grabSampleCategorieValuesChildBatchs(child, categoryIds);
            }
        }
    }

    public static class SpeciesAbleBatchCategoryPredicate
    implements Predicate<SpeciesBatch> {
        private final Integer id;
        private final Integer qualitativeValue;

        public SpeciesAbleBatchCategoryPredicate(Integer id, Integer qualitativeValue) {
            this.id = id;
            this.qualitativeValue = qualitativeValue;
        }

        public boolean apply(SpeciesBatch input) {
            return this.id.equals(input.getSampleCategoryId()) && input.getSampleCategoryValue() instanceof CaracteristicQualitativeValue && this.qualitativeValue.equals(((CaracteristicQualitativeValue)input.getSampleCategoryValue()).getIdAsInt());
        }
    }
}

