/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.producer;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.csv.CsvProducer;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicModel;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicRow;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CsvProducerForGearCaracteristics
extends CsvProducer<GearCaracteristicRow, GearCaracteristicModel> {
    public CsvProducerForGearCaracteristics(Path file, GearCaracteristicModel model) {
        super(file, model);
    }

    public List<GearCaracteristicRow> getDataToExport(Cruise cruise, Gear gear) {
        ArrayList<GearCaracteristicRow> rows = new ArrayList<GearCaracteristicRow>();
        CaracteristicMap caracteristics = gear.getCaracteristics();
        if (caracteristics != null) {
            for (Map.Entry entry : caracteristics.entrySet()) {
                Caracteristic caracteristic = (Caracteristic)entry.getKey();
                Serializable value = (Serializable)entry.getValue();
                GearCaracteristicRow row = new GearCaracteristicRow();
                row.setCruise(cruise);
                row.setGear(gear);
                row.setRankOrder(gear.getRankOrder());
                row.setCaracteristic(caracteristic);
                row.setValue(value);
                rows.add(row);
            }
        }
        return rows;
    }
}

