/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.ooxml.ContentType;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.Package;
import org.eclipse.birt.report.engine.ooxml.PartContainer;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class PartReference
implements IPart {
    private PartContainer parentPart;
    private IPart realPart;
    private int relationshipId;
    private String uri;

    PartReference(PartContainer partContainer, IPart realPart, int relationshipId) {
        this.parentPart = partContainer;
        this.realPart = realPart;
        this.relationshipId = relationshipId;
        this.uri = OOXmlUtil.getRelativeUri(this.parentPart.getAbsoluteUri(), this.getAbsoluteUri());
    }

    @Override
    public String getAbsoluteUri() {
        return this.realPart.getAbsoluteUri();
    }

    @Override
    public ContentType getContentType() {
        return this.realPart.getContentType();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.realPart.getOutputStream();
    }

    @Override
    public Package getPackage() {
        return this.realPart.getPackage();
    }

    @Override
    public String getRelationshipId() {
        return OOXmlUtil.getRelationShipId(this.relationshipId);
    }

    @Override
    public String getRelationshipType() {
        return this.realPart.getRelationshipType();
    }

    @Override
    public String getRelationshipUri() {
        return this.realPart.getRelationshipUri();
    }

    @Override
    public String getRelativeUri() {
        return this.uri;
    }

    @Override
    public OOXmlWriter getCacheWriter() throws IOException {
        return this.realPart.getCacheWriter();
    }

    @Override
    public IPart getPart(String uri, String type, String relationshipType) {
        return this.realPart.getPart(uri, type, relationshipType);
    }

    @Override
    public IPart createPartReference(IPart part) {
        return this.realPart.createPartReference(part);
    }

    @Override
    public IPart getPart(String uri, ContentType type, String relationshipType) {
        return this.realPart.getPart(uri, type, relationshipType);
    }

    @Override
    public IPart getPart(String uri) {
        return this.realPart.getPart(uri);
    }

    @Override
    public String getHyperlinkId(String url) {
        return this.realPart.getHyperlinkId(url);
    }

    @Override
    public String getExternalImageId(String url) {
        return this.realPart.getExternalImageId(url);
    }

    @Override
    public OutputStream getCacheOutputStream() throws IOException {
        return this.realPart.getCacheOutputStream();
    }

    @Override
    public OOXmlWriter getWriter() throws IOException {
        return this.realPart.getWriter();
    }

    @Override
    public boolean isCached() {
        return this.realPart.isCached();
    }

    @Override
    public boolean isReference() {
        return true;
    }
}

